/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.generateaccountflow;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.dto.generateaccountflow.GenerateAccountFlowRpcDTO;
import com.elitesland.fin.param.generateaccountflow.GenerateAccountFlowRpcParam;
import com.elitesland.fin.service.generateaccountflow.GenerateAccountFlowRpcService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"rpc/generateAccountFlow"})
public class GenerateAccountFlowRpcServiceImpl
implements GenerateAccountFlowRpcService {
    private static final Logger log = LoggerFactory.getLogger(GenerateAccountFlowRpcServiceImpl.class);
    private final AccountFlowService accountFlowService;
    private final CreditAccountFlowService creditAccountFlowService;

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<GenerateAccountFlowRpcDTO>> generateAccountFlow(List<GenerateAccountFlowRpcParam> param) {
        log.info("\u5f00\u59cb\u8c03\u7528\u751f\u6210\u8d26\u6237\u6d41\u6c34:{}", (Object)JSON.toJSONString(param));
        this.checkRefundParam(param);
        ArrayList generateAccountFlowRpcDTOList = new ArrayList();
        generateAccountFlowRpcDTOList.addAll(this.buildAccountFlowParam(param).stream().map(item -> {
            String flowNo = this.accountFlowService.generateAccountFlow((AccountFlowParam)((Object)item));
            GenerateAccountFlowRpcDTO generateAccountFlowRpcDTO = new GenerateAccountFlowRpcDTO();
            generateAccountFlowRpcDTO.setAccountType(item.getAccountType());
            generateAccountFlowRpcDTO.setAccountTypeName(item.getAccountTypeName());
            generateAccountFlowRpcDTO.setAccountCode(item.getAccountCode());
            generateAccountFlowRpcDTO.setAccountName(item.getAccountName());
            generateAccountFlowRpcDTO.setTime(LocalDateTime.now());
            generateAccountFlowRpcDTO.setFlowNo(flowNo);
            generateAccountFlowRpcDTO.setAmount(item.getSourceDocAmount());
            return generateAccountFlowRpcDTO;
        }).collect(Collectors.toList()));
        generateAccountFlowRpcDTOList.addAll(this.buildCreditAccountFlowParam(param).stream().map(item -> {
            String flowNo = this.creditAccountFlowService.generateCreditAccountFlow((CreditAccountFlowParam)((Object)item));
            GenerateAccountFlowRpcDTO generateAccountFlowRpcDTO = new GenerateAccountFlowRpcDTO();
            generateAccountFlowRpcDTO.setAccountType(item.getCreditAccountType());
            generateAccountFlowRpcDTO.setAccountTypeName(item.getCreditAccountTypeName());
            generateAccountFlowRpcDTO.setAccountCode(item.getCreditAccountCode());
            generateAccountFlowRpcDTO.setAccountName(item.getCreditAccountName());
            generateAccountFlowRpcDTO.setTime(LocalDateTime.now());
            generateAccountFlowRpcDTO.setFlowNo(flowNo);
            generateAccountFlowRpcDTO.setAmount(item.getSourceDocAmount());
            return generateAccountFlowRpcDTO;
        }).collect(Collectors.toList()));
        return ApiResult.ok(generateAccountFlowRpcDTOList);
    }

    void checkRefundParam(List<GenerateAccountFlowRpcParam> param) {
        Assert.notEmpty(param, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        param.stream().forEach(item -> {
            Assert.notEmpty((CharSequence)item.getAccountType(), (String)"\u8d26\u6237\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getAccountName(), (String)"\u8d26\u6237\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isTrue((UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode().equals(item.getAccountType()) || UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(item.getAccountType()) || UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(item.getAccountType()) ? 1 : 0) != 0, (String)"\u8d26\u6237\u7c7b\u578b\u9519\u8bef", (Object[])new Object[0]);
        });
    }

    private List<CreditAccountFlowParam> buildCreditAccountFlowParam(List<GenerateAccountFlowRpcParam> param) {
        List<CreditAccountFlowParam> creditAccountFlowParamList = param.stream().filter(item -> UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode().equals(item.getAccountType())).map(item -> {
            CreditAccountFlowParam creditAccountFlowParam = new CreditAccountFlowParam();
            creditAccountFlowParam.setSourceDoc(item.getDoc());
            creditAccountFlowParam.setSourceDocType(item.getDocType());
            creditAccountFlowParam.setSourceDocStatus(item.getDocStatus());
            creditAccountFlowParam.setSourceDocAmount(item.getDocAmount());
            creditAccountFlowParam.setSourceId(item.getSourceId());
            creditAccountFlowParam.setSourceNo(item.getSourceNo());
            creditAccountFlowParam.setCreditAccountType(item.getAccountType());
            creditAccountFlowParam.setCreditAccountTypeName(item.getAccountTypeName());
            creditAccountFlowParam.setCreditAccountCode(item.getAccountCode());
            creditAccountFlowParam.setCreditAccountName(item.getAccountName());
            return creditAccountFlowParam;
        }).collect(Collectors.toList());
        return creditAccountFlowParamList;
    }

    private List<AccountFlowParam> buildAccountFlowParam(List<GenerateAccountFlowRpcParam> param) {
        List<AccountFlowParam> accountFlowParamList = param.stream().filter(item -> UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(item.getAccountType()) || UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(item.getAccountType())).map(item -> {
            AccountFlowParam accountFlowParam = new AccountFlowParam();
            accountFlowParam.setSourceDoc(item.getDoc());
            accountFlowParam.setSourceDocType(item.getDocType());
            accountFlowParam.setSourceDocStatus(item.getDocStatus());
            accountFlowParam.setSourceDocAmount(item.getDocAmount());
            accountFlowParam.setSourceId(item.getSourceId());
            accountFlowParam.setSourceNo(item.getSourceNo());
            accountFlowParam.setAccountCode(item.getAccountCode());
            accountFlowParam.setAccountType(item.getAccountType());
            accountFlowParam.setAccountTypeName(item.getAccountTypeName());
            accountFlowParam.setAccountName(item.getAccountName());
            return accountFlowParam;
        }).collect(Collectors.toList());
        return accountFlowParamList;
    }

    public GenerateAccountFlowRpcServiceImpl(AccountFlowService accountFlowService, CreditAccountFlowService creditAccountFlowService) {
        this.accountFlowService = accountFlowService;
        this.creditAccountFlowService = creditAccountFlowService;
    }
}

