/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.creditaccount;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.cloudt.apm.common.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.creditaccount.CreditAccountConvert;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountDTO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountPageParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountSaveParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountStatusParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountDetailVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountPageVO;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.common.SysNumEnum;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.creditaccount.CreditAccountDO;
import com.elitesland.fin.entity.creditaccount.CreditAccountInitialLimitDO;
import com.elitesland.fin.repo.creditaccount.CreditAccountInitialLimitRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountInitialLimitRepoProc;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.sale.api.vo.param.crm.AllowShipCustGroupDParam;
import com.elitesland.sale.api.vo.resp.crm.AllowShipCustGroupDVO;
import com.elitesland.sale.constant.AllowShipCustGroupEnum;
import com.elitesland.sale.constant.AllowShipStatus;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CreditAccountServiceImpl
implements CreditAccountService {
    private final CreditAccountRepo creditAccountRepo;
    private final CreditAccountRepoProc creditAccountRepoProc;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final SystemRpcService systemRpcService;
    private final CreditAccountInitialLimitRepo creditAccountInitialLimitRepo;
    private final CreditAccountInitialLimitRepoProc creditAccountInitialLimitRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<CreditAccountPageVO> pageSearch(CreditAccountPageParam accountPageParam) {
        return this.creditAccountRepoProc.search(accountPageParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Object saveOrUpdate(CreditAccountSaveParam param) {
        this.saveOrUpdateCheck(param);
        CreditAccountDO creditAccountDO = CreditAccountConvert.INSTANCE.saveParam2DO(param);
        CreditAccountDO save = (CreditAccountDO)((Object)this.creditAccountRepo.save((Object)creditAccountDO));
        return save.getId();
    }

    @Override
    @SysCodeProc
    public CreditAccountDetailVO queryDetailById(Long id) {
        Assert.notNull((Object)id, (String)"\u67e5\u8be2\u8be6\u60c5\u4fe1\u606f\u672a\u4f20\u53c2\u6570", (Object[])new Object[0]);
        Optional byId = this.creditAccountRepo.findById(id);
        if (byId.isEmpty()) {
            throw new BusinessException("\u6ca1\u6709\u67e5\u8be2\u5230\u4fe1\u7528\u8d26\u6237\u8be6\u60c5");
        }
        return CreditAccountConvert.INSTANCE.do2DetailVO((CreditAccountDO)((Object)byId.get()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(CreditAccountStatusParam param) {
        List creditAccountDOList = this.creditAccountRepo.findAllById(param.getId());
        if (CollectionUtil.isEmpty((Collection)creditAccountDOList)) {
            throw new BusinessException("\u6ca1\u6709\u67e5\u8be2\u5230\u4fe1\u7528\u8d26\u6237\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        if (StrUtil.equals((CharSequence)param.getStatus(), (CharSequence)UdcEnum.FIN_ACTIVE_STATUS_CLOSED.getValueCode())) {
            this.creditAccountRepo.updateStatusByIds(param.getStatus(), param.getId());
            return;
        }
        Set<String> accountCodeList = creditAccountDOList.stream().map(item -> item.getCreditAccountCode()).collect(Collectors.toSet());
        List<CreditAccountInitialLimitDO> initialLimitDOList = this.creditAccountInitialLimitRepo.findByCreditAccountCodeIn(accountCodeList);
        Map<String, String> accountCodeStatusMap = initialLimitDOList.stream().filter(item -> StrUtil.equals((CharSequence)item.getStatus(), (CharSequence)UdcEnum.INITIAL_STATUS_FINISHED.getValueCode())).collect(Collectors.toMap(CreditAccountInitialLimitDO::getCreditAccountCode, CreditAccountInitialLimitDO::getStatus, (t1, t2) -> t1));
        this.creditAccountInitialLimitRepo.deleteByAccountCodesAndStatus(accountCodeList, UdcEnum.INITIAL_STATUS_DRAFT.getValueCode());
        ArrayList<CreditAccountParam> list = new ArrayList<CreditAccountParam>();
        ArrayList initialLimitDOS = new ArrayList();
        creditAccountDOList.stream().forEach(item -> {
            CreditAccountParam creditAccountParam = new CreditAccountParam();
            creditAccountParam.setId(item.getId());
            creditAccountParam.setCreditAccountCodeName(item.getCreditAccountCode());
            creditAccountParam.setStatus(param.getStatus());
            if (accountCodeStatusMap.containsKey(item.getCreditAccountCode())) {
                creditAccountParam.setCreditAccountLimit(item.getCreditAccountLimit());
                creditAccountParam.setCreditAccountOccupancyLimit(item.getCreditAccountOccupancyLimit());
                creditAccountParam.setCreditAccountUsedLimit(item.getCreditAccountUsedLimit());
                creditAccountParam.setCreditAccountAvailableLimit(item.getCreditAccountAvailableLimit());
            } else {
                CreditAccountInitialLimitDO initialLimitDO = new CreditAccountInitialLimitDO();
                creditAccountParam.setCreditAccountLimit(BigDecimal.ZERO);
                creditAccountParam.setCreditAccountOccupancyLimit(BigDecimal.ZERO);
                creditAccountParam.setCreditAccountUsedLimit(BigDecimal.ZERO);
                creditAccountParam.setCreditAccountAvailableLimit(BigDecimal.ZERO);
                initialLimitDO.setFinishedTime(LocalDateTime.now());
                initialLimitDO.setCreditAccountName(item.getCreditAccountName());
                initialLimitDO.setCreditAccountCode(item.getCreditAccountCode());
                initialLimitDO.setInitialAccountLimit(BigDecimal.ZERO);
                initialLimitDO.setInitialAccountUsedLimit(BigDecimal.ZERO);
                initialLimitDO.setInitialAccountOccupancyLimit(BigDecimal.ZERO);
                initialLimitDO.setInitialAccountAvailableLimit(BigDecimal.ZERO);
                initialLimitDO.setStatus(UdcEnum.INITIAL_STATUS_FINISHED.getValueCode());
                initialLimitDOS.add(initialLimitDO);
            }
            list.add(creditAccountParam);
        });
        this.creditAccountRepoProc.updateByParam(list);
        if (CollectionUtil.isNotEmpty(initialLimitDOS)) {
            this.creditAccountInitialLimitRepo.saveAll(initialLimitDOS);
        }
    }

    @Override
    public List<CreditAccountDTO> getAccountByAccountParam(CreditAccountParam param) {
        return this.creditAccountRepoProc.getAccountByAccountParam(param);
    }

    private void saveOrUpdateCheck(CreditAccountSaveParam param) {
        Assert.notBlank((CharSequence)param.getOuCode(), (String)"\u6388\u4fe1\u7ec4\u7ec7\u4fe1\u606f\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)param.getObjectType(), (String)"\u5bf9\u8c61\u7c7b\u578b\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)param.getObjectName(), (String)"\u5bf9\u8c61\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)param.getObjectCode(), (String)"\u5bf9\u8c61\u4fe1\u606f\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)param.getCreditAccountType(), (String)"\u8d26\u6237\u7c7b\u578b\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)param.getCreditAccountName(), (String)"\u8d26\u6237\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        if (ObjectUtil.isNull((Object)param.getId())) {
            String groupCode;
            CreditAccountDO creditDO;
            String code = this.systemRpcService.sysNumberRuleGenerateCode("yst-fin", SysNumEnum.FIN_XYZH_NO.getCode(), new ArrayList<String>());
            param.setCreditAccountCode(code);
            if (this.creditAccountRepo.existsByCreditAccountCode(code)) {
                throw new BusinessException("\u8d26\u6237\u7f16\u7801[" + code + "]\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4");
            }
            CreditAccountDO creditAccountDO = this.creditAccountRepo.findByObjectCodeAndOuCode(param.getObjectCode(), param.getOuCode());
            if (ObjectUtil.isNotNull((Object)((Object)creditAccountDO))) {
                throw new BusinessException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u8d26\u6237\uff0c\u8d26\u6237\u7f16\u7801\u4e3a:" + creditAccountDO.getCreditAccountCode());
            }
            List<AllowShipCustGroupDVO> custGroupInfo = this.getAllowShipCustGroupInfo(param);
            if (StrUtil.equals((CharSequence)param.getObjectType(), (CharSequence)UdcEnum.OBJECT_TYPE_CUST_GROUP.getValueCode())) {
                if (CollectionUtil.isEmpty(custGroupInfo)) {
                    throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u7ec4\u4fe1\u606f");
                }
                List<String> custCodeList = custGroupInfo.stream().map(AllowShipCustGroupDVO::getCustCode).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(custCodeList)) {
                    List<CreditAccountDO> creditList = this.creditAccountRepo.findByObjectCodeInAndOuCode(custCodeList, param.getOuCode());
                    List collect = creditList.stream().map(CreditAccountDO::getCreditAccountCode).collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty(creditList)) {
                        throw new BusinessException("\u5ba2\u6237\u5df2\u7ecf\u5b58\u5728\u8d26\u6237 " + collect + " \u4e2d\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa\uff0c\u8bf7\u8c03\u6574\u5ba2\u6237\u7ec4\u8303\u56f4\u540e\u518d\u521b\u5efa");
                    }
                }
            } else if (StrUtil.equals((CharSequence)param.getObjectType(), (CharSequence)UdcEnum.OBJECT_TYPE_CUST.getValueCode()) && CollectionUtil.isNotEmpty(custGroupInfo) && ObjectUtil.isNotNull((Object)((Object)(creditDO = this.creditAccountRepo.findByObjectCodeAndOuCode(groupCode = custGroupInfo.get(0).getCode(), param.getOuCode()))))) {
                throw new BusinessException("\u5f53\u524d\u521b\u5efa\u7684\u5ba2\u6237\u5df2\u7ecf\u5b58\u5728\u8d26\u6237\uff0c\u8d26\u6237\u7f16\u7801\u4e3a:" + creditDO.getCreditAccountCode());
            }
        }
    }

    private List<AllowShipCustGroupDVO> getAllowShipCustGroupInfo(CreditAccountSaveParam param) {
        AllowShipCustGroupDParam groupDParam = new AllowShipCustGroupDParam();
        if (StrUtil.equals((CharSequence)param.getObjectType(), (CharSequence)UdcEnum.OBJECT_TYPE_CUST_GROUP.getValueCode())) {
            groupDParam.setCodes(List.of(param.getObjectCode()));
        } else {
            groupDParam.setCustCodes(List.of(param.getObjectCode()));
        }
        groupDParam.setType(AllowShipCustGroupEnum.CREIDT_ACCOUNT_GROUP.getType());
        groupDParam.setStatus(AllowShipStatus.ACTIVE.getType());
        List<AllowShipCustGroupDVO> custGroupInfo = this.rmiSaleRpcService.getCustGroupInfo(groupDParam);
        return custGroupInfo;
    }

    public CreditAccountServiceImpl(CreditAccountRepo creditAccountRepo, CreditAccountRepoProc creditAccountRepoProc, RmiSaleRpcService rmiSaleRpcService, SystemRpcService systemRpcService, CreditAccountInitialLimitRepo creditAccountInitialLimitRepo, CreditAccountInitialLimitRepoProc creditAccountInitialLimitRepoProc) {
        this.creditAccountRepo = creditAccountRepo;
        this.creditAccountRepoProc = creditAccountRepoProc;
        this.rmiSaleRpcService = rmiSaleRpcService;
        this.systemRpcService = systemRpcService;
        this.creditAccountInitialLimitRepo = creditAccountInitialLimitRepo;
        this.creditAccountInitialLimitRepoProc = creditAccountInitialLimitRepoProc;
    }
}

