/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinAccountPeriodConvert;
import com.elitesland.fin.application.convert.accountingengine.FinAccountPeriodLineConvert;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccountPeriodLineParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccountPeriodParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccountPeriodVO;
import com.elitesland.fin.application.service.accountingengine.FinAccountPeriodService;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountPeriodDO;
import com.elitesland.fin.repo.accountingengine.FinAccountPeriodLineRepo;
import com.elitesland.fin.repo.accountingengine.FinAccountPeriodRepo;
import com.elitesland.fin.repo.accountingengine.FinAccountPeriodRepoProc;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FinAccountPeriodServiceImpl
implements FinAccountPeriodService {
    private static final Logger log = LoggerFactory.getLogger(FinAccountPeriodServiceImpl.class);
    private final FinAccountPeriodRepo finAccountPeriodRepo;
    private final FinAccountPeriodRepoProc finAccountPeriodRepoProc;
    private final FinAccountPeriodLineRepo finAccountPeriodLineRepo;

    @Override
    @SysCodeProc
    public PagingVO<FinAccountPeriodVO> page(FinAccountPeriodParam finAccountPeriodParam) {
        return FinAccountPeriodConvert.INSTANCE.DTOToVO(this.finAccountPeriodRepoProc.page(finAccountPeriodParam));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdate(FinAccountPeriodParam finAccountPeriodParam) {
        this.checkSaveOrUpdateParam(finAccountPeriodParam);
        this.checkIdempotent(finAccountPeriodParam);
        this.checkDetailList(finAccountPeriodParam);
        FinAccountPeriodDO finAccountPeriodDO = (FinAccountPeriodDO)this.finAccountPeriodRepo.save(FinAccountPeriodConvert.INSTANCE.paramToDO(finAccountPeriodParam));
        this.finAccountPeriodLineRepo.deleteAllByMasId(finAccountPeriodDO.getId());
        List<FinAccountPeriodLineParam> finAccountPeriodLineParamList = finAccountPeriodParam.getDetailList();
        finAccountPeriodLineParamList.stream().forEach(item -> item.setMasId(finAccountPeriodDO.getId()));
        this.finAccountPeriodLineRepo.saveAll(FinAccountPeriodLineConvert.INSTANCE.paramToDO(finAccountPeriodLineParamList));
        return finAccountPeriodDO.getId();
    }

    private void checkDetailList(FinAccountPeriodParam finAccountPeriodParam) {
        List<FinAccountPeriodLineParam> finAccountPeriodLineParamList = finAccountPeriodParam.getDetailList();
        for (int i = 0; i < finAccountPeriodLineParamList.size(); ++i) {
            LocalDateTime currentActiveStartTime = finAccountPeriodLineParamList.get(i).getActiveStartTime();
            LocalDateTime currentActiveEndTime = finAccountPeriodLineParamList.get(i).getActiveEndTime();
            for (int j = 0; j < finAccountPeriodLineParamList.size(); ++j) {
                if (i == j) continue;
                LocalDateTime activeStartTime = finAccountPeriodLineParamList.get(j).getActiveStartTime();
                LocalDateTime activeEndTime = finAccountPeriodLineParamList.get(j).getActiveEndTime();
                Assert.isTrue((currentActiveEndTime.compareTo(activeStartTime) == -1 || currentActiveStartTime.compareTo(activeEndTime) == 1 ? 1 : 0) != 0, (String)"\u8d77\u59cb\u65e5\u671f\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u91cd\u53e0", (Object[])new Object[0]);
            }
        }
    }

    private void checkIdempotent(FinAccountPeriodParam finAccountPeriodParam) {
        FinAccountPeriodDO finAccountPeriodDO = this.finAccountPeriodRepoProc.findByAccountPeriodCode(finAccountPeriodParam.getAccountPeriodCode());
        if (finAccountPeriodDO != null) {
            Assert.equals((Object)finAccountPeriodDO.getId(), (Object)finAccountPeriodParam.getId(), (String)"\u4f1a\u8ba1\u671f\u95f4\u7f16\u7801\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        }
    }

    private void checkSaveOrUpdateParam(FinAccountPeriodParam finAccountPeriodParam) {
        Assert.notEmpty((CharSequence)finAccountPeriodParam.getAccountPeriodCode(), (String)"\u4f1a\u8ba1\u671f\u95f4\u7f16\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountPeriodParam.getAccountPeriodName(), (String)"\u4f1a\u8ba1\u671f\u95f4\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountPeriodParam.getStatus(), (String)"\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
        List<FinAccountPeriodLineParam> finAccountPeriodLineParamList = finAccountPeriodParam.getDetailList();
        Assert.notEmpty(finAccountPeriodLineParamList, (String)"\u660e\u7ec6\u5fc5\u586b", (Object[])new Object[0]);
        finAccountPeriodLineParamList.stream().forEach(item -> {
            Assert.notEmpty((CharSequence)item.getPeriodStyle(), (String)"\u671f\u95f4\u683c\u5f0f\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getYear(), (String)"\u5e74\u4efd\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getQuarter(), (String)"\u5b63\u5ea6\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getMonth(), (String)"\u6708\u4efd\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notNull((Object)item.getActiveStartTime(), (String)"\u8d77\u59cb\u6709\u6548\u65e5\u671f\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notNull((Object)item.getActiveEndTime(), (String)"\u7ec8\u6b62\u6709\u6548\u65e5\u671f\u5fc5\u586b", (Object[])new Object[0]);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableOrDisable(FinAccountPeriodParam finAccountPeriodParam) {
        this.checkEnableOrDisableParam(finAccountPeriodParam);
        List finAccountPeriodDOList = this.finAccountPeriodRepo.findAllById(finAccountPeriodParam.getIds());
        finAccountPeriodDOList.stream().forEach(item -> Assert.isFalse((boolean)finAccountPeriodParam.getStatus().equals(item.getStatus()), (String)"\u6570\u636e\u5df2\u7ecf\u542f\u7528/\u7981\u7528", (Object[])new Object[0]));
        finAccountPeriodDOList.stream().forEach(item -> item.setStatus(finAccountPeriodParam.getStatus()));
    }

    private void checkEnableOrDisableParam(FinAccountPeriodParam finAccountPeriodParam) {
        Assert.notEmpty(finAccountPeriodParam.getIds(), (String)"id\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountPeriodParam.getStatus(), (String)"\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
    }

    public FinAccountPeriodServiceImpl(FinAccountPeriodRepo finAccountPeriodRepo, FinAccountPeriodRepoProc finAccountPeriodRepoProc, FinAccountPeriodLineRepo finAccountPeriodLineRepo) {
        this.finAccountPeriodRepo = finAccountPeriodRepo;
        this.finAccountPeriodRepoProc = finAccountPeriodRepoProc;
        this.finAccountPeriodLineRepo = finAccountPeriodLineRepo;
    }
}

