/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.apverconfig;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.convert.aporder.ApOrderConvert;
import com.elitesland.fin.application.convert.apverconfig.ApVerConfigConvert;
import com.elitesland.fin.application.convert.apverconfig.ApVerConfigDtlConvert;
import com.elitesland.fin.application.convert.payorder.PayOrderConvert;
import com.elitesland.fin.application.facade.param.apverconfig.ApVerConfigDtlSaveParam;
import com.elitesland.fin.application.facade.param.apverconfig.ApVerConfigSaveParam;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderVO;
import com.elitesland.fin.application.facade.vo.apverconfig.ApVerConfigDtlVO;
import com.elitesland.fin.application.facade.vo.apverconfig.ApVerConfigVO;
import com.elitesland.fin.application.facade.vo.apverconfig.PayAndApOrderVO;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderVO;
import com.elitesland.fin.application.service.apverconfig.ApVerConfigService;
import com.elitesland.fin.domain.entity.apverconfig.ApVerConfig;
import com.elitesland.fin.domain.param.aporder.ApOrderParam;
import com.elitesland.fin.domain.param.apverconfig.ApVerConfigPageParam;
import com.elitesland.fin.domain.param.apverconfig.OrderParam;
import com.elitesland.fin.domain.param.payorder.PayOrderParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.apverconfig.ApVerConfigDomainService;
import com.elitesland.fin.domain.service.apverconfig.ApVerConfigDtlDomainService;
import com.elitesland.fin.domain.service.apverrec.ApVerRecDomainService;
import com.elitesland.fin.domain.service.payorder.PayOrderDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.apverconfig.ApVerConfigDTO;
import com.elitesland.fin.infr.dto.apverconfig.ApVerConfigDtlDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApVerConfigServiceImpl
implements ApVerConfigService {
    private final PayOrderDomainService payOrderService;
    private final ApOrderDomainService apOrderService;
    private final ApVerConfigDomainService apVerConfigDomainService;
    private final ApVerConfigDtlDomainService apVerConfigDtlDomainService;
    private final ApVerRecDomainService apVerRecDomainService;

    @Override
    @SysCodeProc
    public PayAndApOrderVO queryOrderByParam(OrderParam param) {
        if (param.getOuId() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u516c\u53f8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (param.getSuppId() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (param.getBuDateStart() == null || param.getBuDateEnd() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        PayAndApOrderVO payAndApOrderVO = new PayAndApOrderVO();
        payAndApOrderVO.setPayOrderList(this.getPayOrderList(param));
        payAndApOrderVO.setApOrderList(this.getApOrderList(param));
        return payAndApOrderVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> save(ApVerConfigSaveParam param) {
        if (param.getId() != null) {
            Map<String, ApVerConfigDtlDTO> dtlMap = this.apVerConfigDtlDomainService.queryByMasId(param.getId()).stream().collect(Collectors.toMap(ApVerConfigDtlDTO::getFieldNo, t -> t));
            Boolean aBoolean = this.apVerRecDomainService.queryByScId(param.getId());
            param.getConfigDtlSaveParamList().forEach(params -> {
                if (dtlMap.get(params.getFieldNo()) != null) {
                    ApVerConfigServiceImpl.checkFieldNo(dtlMap, aBoolean, params);
                }
            });
        }
        ApVerConfig apVerConfig = ApVerConfigConvert.INSTANCE.paramConvert(param);
        String id = this.apVerConfigDomainService.save(apVerConfig);
        return ApiResult.ok((Object)id);
    }

    private static void checkFieldNo(Map<String, ApVerConfigDtlDTO> dtlMap, Boolean aBoolean, ApVerConfigDtlSaveParam params) {
        if (!dtlMap.get(params.getFieldNo()).getMatchFlag().equals(params.getMatchFlag()) && aBoolean.booleanValue()) {
            throw new BusinessException("\u5df2\u88ab\u6838\u9500\u8bb0\u5f55\u5173\u8054,\u4e0d\u5141\u8bb8\u4fee\u6539\u5339\u914d\u5b57\u6bb5!");
        }
    }

    @Override
    public ApiResult<ApVerConfigVO> queryById(Long id) {
        ApVerConfigDTO apVerConfigDTO = this.apVerConfigDomainService.queryById(id);
        ApVerConfigVO apVerConfigVO = ApVerConfigConvert.INSTANCE.convertVo(apVerConfigDTO);
        Boolean aBoolean = this.apVerRecDomainService.queryByScId(id);
        apVerConfigVO.setFlag(aBoolean);
        return ApiResult.ok((Object)apVerConfigVO);
    }

    @Override
    public ApiResult<ApVerConfigVO> getDef() {
        ApVerConfigDTO apVerConfigDTO = this.apVerConfigDomainService.queryDef();
        ApVerConfigVO apVerConfigVO = ApVerConfigConvert.INSTANCE.convertVo(apVerConfigDTO);
        if (apVerConfigVO == null) {
            return ApiResult.ok((Object)new ApVerConfigVO());
        }
        return ApiResult.ok((Object)apVerConfigVO);
    }

    @Override
    public ApiResult<PagingVO<ApVerConfigVO>> page(ApVerConfigPageParam param) {
        PagingVO<ApVerConfigDTO> page = this.apVerConfigDomainService.page(param);
        PagingVO<ApVerConfigVO> apVerConfigVOPagingVO = ApVerConfigConvert.INSTANCE.convertPage(page);
        return ApiResult.ok(apVerConfigVOPagingVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> stop(List<Long> ids) {
        this.apVerConfigDomainService.updateEnable(ids);
        return ApiResult.ok(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateDef(Long id) {
        Long count = this.apVerConfigDomainService.updateDef(id);
        return ApiResult.ok((Object)count);
    }

    @Override
    public ApiResult<List<ApVerConfigDtlVO>> queryDtl() {
        List<ApVerConfigDtlDTO> dtlDTOList = this.apVerConfigDtlDomainService.queryDtl();
        List<ApVerConfigDtlVO> dtlVOS = ApVerConfigDtlConvert.INSTANCE.convertVo(dtlDTOList);
        return ApiResult.ok(dtlVOS);
    }

    @Override
    public ApiResult<List<ApVerConfigVO>> queryAllConfig() {
        List<ApVerConfigDTO> apVerConfigDTOS = this.apVerConfigDomainService.queryAll();
        List<ApVerConfigVO> apVerConfigVOS = ApVerConfigConvert.INSTANCE.dtoToVo(apVerConfigDTOS);
        return ApiResult.ok(apVerConfigVOS);
    }

    private List<ApOrderVO> getApOrderList(OrderParam param) {
        ApOrderParam apOrderParam = new ApOrderParam();
        apOrderParam.setOuId(param.getOuId());
        apOrderParam.setSuppId(param.getSuppId());
        apOrderParam.setCurrCode(param.getCurrCode());
        apOrderParam.setBuDateStart(param.getBuDateStart());
        apOrderParam.setBuDateEnd(param.getBuDateEnd());
        List<ApOrderDTO> apOrderDTOList = this.apOrderService.getApOrderList(apOrderParam);
        List<ApOrderVO> apOrderVOS = ApOrderConvert.INSTANCE.convertList(apOrderDTOList);
        List<ApOrderVO> res = apOrderVOS.stream().filter(x -> {
            x.setUnVerAmt(x.getTotalAmt().subtract(x.getVerAmt()));
            return x.getUnVerAmt().compareTo(BigDecimal.ZERO) != 0;
        }).collect(Collectors.toList());
        return res;
    }

    private List<PayOrderVO> getPayOrderList(OrderParam param) {
        PayOrderParam payOrderParam = new PayOrderParam();
        payOrderParam.setOuId(param.getOuId());
        payOrderParam.setSuppId(param.getSuppId());
        payOrderParam.setCurrCode(param.getCurrCode());
        payOrderParam.setBuDateStart(param.getBuDateStart());
        payOrderParam.setBuDateEnd(param.getBuDateEnd());
        List<PayOrderDTO> payOrderDTOS = this.payOrderService.queryByParam(payOrderParam);
        List<PayOrderVO> payOrderVOS = PayOrderConvert.INSTANCE.dtoListToVO(payOrderDTOS);
        return payOrderVOS.stream().filter(vo -> {
            vo.setUnVerAmt(vo.getTotalAmt().subtract(vo.getVerAmt()));
            return vo.getUnVerAmt().compareTo(BigDecimal.ZERO) != 0;
        }).collect(Collectors.toList());
    }

    public ApVerConfigServiceImpl(PayOrderDomainService payOrderService, ApOrderDomainService apOrderService, ApVerConfigDomainService apVerConfigDomainService, ApVerConfigDtlDomainService apVerConfigDtlDomainService, ApVerRecDomainService apVerRecDomainService) {
        this.payOrderService = payOrderService;
        this.apOrderService = apOrderService;
        this.apVerConfigDomainService = apVerConfigDomainService;
        this.apVerConfigDtlDomainService = apVerConfigDtlDomainService;
        this.apVerRecDomainService = apVerRecDomainService;
    }
}

