/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.creditaccount;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountInitialLimitParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountParam;
import com.elitesland.fin.application.facade.vo.creditaccount.InitialLimitPageVO;
import com.elitesland.fin.application.service.creditaccount.CreditAccountInitialLimitService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.repo.creditaccount.CreditAccountInitialLimitRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountInitialLimitRepoProc;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CreditAccountInitialLimitServiceImpl
implements CreditAccountInitialLimitService {
    private static final Logger log = LoggerFactory.getLogger(CreditAccountInitialLimitServiceImpl.class);
    private final CreditAccountInitialLimitRepo creditAccountInitialLimitRepo;
    private final CreditAccountInitialLimitRepoProc creditAccountInitialLimitRepoProc;
    private final CreditAccountRepoProc creditAccountRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<InitialLimitPageVO> pageSearch(CreditAccountInitialLimitParam pageParam) {
        return this.creditAccountInitialLimitRepoProc.pageSearch(pageParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void finishedInitial(List<Long> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u9700\u8981\u7ed3\u675f\u521d\u59cb\u5316\u7684\u6570\u636e", (Object[])new Object[0]);
        List initialLimitDOList = this.creditAccountInitialLimitRepo.findAllById(ids);
        Assert.notEmpty((Iterable)initialLimitDOList, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u9700\u8981\u521d\u59cb\u5316\u7684\u6570\u636e", (Object[])new Object[0]);
        List finishedDOS = initialLimitDOList.stream().filter(item -> StrUtil.equals((CharSequence)item.getStatus(), (CharSequence)UdcEnum.INITIAL_STATUS_FINISHED.getValueCode())).collect(Collectors.toList());
        Assert.isTrue((boolean)CollectionUtil.isEmpty(finishedDOS), (String)"\u8bf7\u9009\u62e9\u6ca1\u6709\u521d\u59cb\u5316\u7684\u6570\u636e", (Object[])new Object[0]);
        ArrayList<CreditAccountParam> params = new ArrayList<CreditAccountParam>();
        initialLimitDOList.stream().forEach(item -> {
            CreditAccountParam param = new CreditAccountParam();
            param.setCreditAccountCodeName(item.getCreditAccountCode());
            param.setCreditAccountLimit(ObjectUtil.isNotNull((Object)item.getInitialAccountLimit()) ? item.getInitialAccountLimit() : BigDecimal.ZERO);
            param.setCreditAccountOccupancyLimit(ObjectUtil.isNotNull((Object)item.getInitialAccountOccupancyLimit()) ? item.getInitialAccountOccupancyLimit() : BigDecimal.ZERO);
            param.setCreditAccountUsedLimit(ObjectUtil.isNotNull((Object)item.getInitialAccountUsedLimit()) ? item.getInitialAccountUsedLimit() : BigDecimal.ZERO);
            param.setCreditAccountAvailableLimit(NumberUtil.sub((BigDecimal[])new BigDecimal[]{item.getInitialAccountLimit(), item.getInitialAccountOccupancyLimit(), item.getInitialAccountUsedLimit()}));
            params.add(param);
        });
        this.creditAccountRepoProc.updateByParam(params);
        initialLimitDOList.stream().forEach(item -> {
            item.setStatus(UdcEnum.INITIAL_STATUS_FINISHED.getValueCode());
            item.setFinishedTime(LocalDateTime.now());
            item.setInitialAccountAvailableLimit(NumberUtil.sub((BigDecimal[])new BigDecimal[]{item.getInitialAccountLimit(), item.getInitialAccountOccupancyLimit(), item.getInitialAccountUsedLimit()}));
        });
        this.creditAccountInitialLimitRepo.saveAll(initialLimitDOList);
    }

    public CreditAccountInitialLimitServiceImpl(CreditAccountInitialLimitRepo creditAccountInitialLimitRepo, CreditAccountInitialLimitRepoProc creditAccountInitialLimitRepoProc, CreditAccountRepoProc creditAccountRepoProc) {
        this.creditAccountInitialLimitRepo = creditAccountInitialLimitRepo;
        this.creditAccountInitialLimitRepoProc = creditAccountInitialLimitRepoProc;
        this.creditAccountRepoProc = creditAccountRepoProc;
    }
}

