/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.utils;

import com.elitescloud.cloudt.common.base.QBaseModel;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.fin.application.facade.param.common.FinQueryParam;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.jdbc.AbstractSQL;
import org.apache.ibatis.jdbc.SQL;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class SqlUtil {
    public static final String SQL_EMPTY_SET = "(NULL)";
    private static final Pattern RE_WORD = Pattern.compile("^\\w+$");
    private static final Map<Character, String> SQL_ESC = new HashMap<Character, String>();

    public static String toSqlString(CharSequence val) {
        if (StringUtils.isEmpty((Object)val)) {
            throw new IllegalArgumentException("[EDP-SQL] Parameter(val) is null or empty");
        }
        return SqlUtil.escapeString(new StringBuilder(), val).toString();
    }

    private static StringBuilder escapeString(StringBuilder sb, CharSequence input) {
        sb.append('\'');
        int n = input.length();
        for (int i = 0; i < n; ++i) {
            char ch = input.charAt(i);
            sb = ch == '\'' ? sb.append("''") : sb.append(ch);
        }
        sb.append('\'');
        return sb;
    }

    public static String toSqlLikeString(CharSequence val, SqlLikeOption option) {
        if (StringUtils.isEmpty((Object)val)) {
            throw new IllegalArgumentException("[EDP-SQL] Parameter(val) is null or empty");
        }
        return SqlUtil.escapeLikeString(new StringBuilder(), val, option).toString();
    }

    private static StringBuilder escapeLikeString(StringBuilder sb, CharSequence input, SqlLikeOption option) {
        Map<Character, String> escapeTable = SqlUtil.escapeTable();
        sb.append(option != SqlLikeOption.RIGHT_SIDE ? "%" : "");
        int n = input.length();
        for (int i = 0; i < n; ++i) {
            char ch = input.charAt(i);
            String escaped = escapeTable.get(Character.valueOf(ch));
            sb = escaped != null ? sb.append(escaped) : sb.append(ch);
        }
        sb.append(option != SqlLikeOption.LEFT_SIDE ? "%" : "");
        return sb;
    }

    public static String toSqlLikeString(String val) {
        return SqlUtil.toSqlLikeString(val, SqlLikeOption.BOTH_SIDES);
    }

    public static String toSqlStringSet(Collection<? extends CharSequence> vals) {
        List nonNullVals = vals.stream().filter(Objects::nonNull).collect(Collectors.toList());
        return nonNullVals.isEmpty() ? SQL_EMPTY_SET : nonNullVals.stream().map(SqlUtil::toSqlString).collect(Collectors.joining(",", "(", ")"));
    }

    public static String toSqlNumberSet(Collection<? extends Number> vals) {
        List nonNullVals = vals.stream().filter(Objects::nonNull).collect(Collectors.toList());
        return nonNullVals.isEmpty() ? SQL_EMPTY_SET : nonNullVals.stream().map(String::valueOf).collect(Collectors.joining(",", "(", ")"));
    }

    public static String unionAll(SQL ... sqls) {
        return Stream.of(sqls).map(AbstractSQL::toString).collect(Collectors.joining(" UNION ALL "));
    }

    public static String toSqlWord(String input) {
        if (!RE_WORD.matcher(input).matches()) {
            throw new IllegalArgumentException("[CORE-JDBC] Illegal inputted sql word: " + input);
        }
        return input;
    }

    public static Map<Character, String> escapeTable() {
        return SQL_ESC;
    }

    public static String escapeClause() {
        return " escape '\\'";
    }

    public static <T> void handleCommonJpaQuery(JPAQuery<T> jpaQuery, QBaseModel qBaseModel, FinQueryParam query) {
        jpaQuery.where((Predicate)qBaseModel.deleteFlag.eq((Object)0));
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            jpaQuery.where((Predicate)qBaseModel.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            jpaQuery.where((Predicate)qBaseModel.createUserId.eq((Object)query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateTimeStart())) {
            jpaQuery.where((Predicate)qBaseModel.createTime.goe((Comparable)query.getCreateTimeStart()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateTimeEnd())) {
            jpaQuery.where((Predicate)qBaseModel.createTime.loe((Comparable)query.getCreateTimeEnd()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRemark())) {
            jpaQuery.where((Predicate)qBaseModel.remark.like(SqlUtil.toSqlLikeString(query.getRemark())));
        }
    }

    public static <T> OrderSpecifier<?>[] getSortedColumn(EntityPathBase<T> pathBase, List<OrderItem> orders) {
        if (orders == null || orders.size() == 0) {
            SimplePath fieldPath = Expressions.path(String.class, pathBase, (String)"createTime");
            return new OrderSpecifier[]{new OrderSpecifier(Order.DESC, (Expression)fieldPath)};
        }
        OrderSpecifier[] orderSpecifiers = new OrderSpecifier[orders.size()];
        for (int i = 0; i < orders.size(); ++i) {
            OrderItem orderItem = orders.get(i);
            Order order = orderItem.isAsc() ? Order.ASC : Order.DESC;
            SimplePath fieldPath = Expressions.path(String.class, pathBase, (String)orderItem.getColumn());
            orderSpecifiers[i] = new OrderSpecifier(order, (Expression)fieldPath);
        }
        return orderSpecifiers;
    }

    static {
        SQL_ESC.put(Character.valueOf('\''), "''");
        SQL_ESC.put(Character.valueOf('%'), "\\%");
        SQL_ESC.put(Character.valueOf('_'), "\\_");
        SQL_ESC.put(Character.valueOf('&'), "\\&");
    }

    public static enum SqlLikeOption {
        BOTH_SIDES,
        LEFT_SIDE,
        RIGHT_SIDE;

    }
}

