/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.creditaccount;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.creditaccount.CreditAccountConvert;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountDTO;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountInitialLimitDTO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountInitialLimitParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountPageParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountPageVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.creditaccount.CreditAccountDO;
import com.elitesland.fin.entity.creditaccount.QCreditAccountDO;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CreditAccountRepoProc
extends BaseRepoProc<CreditAccountDO> {
    private static final QCreditAccountDO Q_DO = QCreditAccountDO.creditAccountDO;
    @Autowired
    private CreditAccountRepo creditAccountRepo;

    protected CreditAccountRepoProc() {
        super((EntityPathBase)Q_DO);
    }

    public PagingVO<CreditAccountPageVO> search(CreditAccountPageParam pageParam) {
        Predicate predicate = this.commonBuilder(CreditAccountConvert.INSTANCE.pageParam2QueryParam(pageParam)).build();
        JPAQuery query = (JPAQuery)this.select(CreditAccountPageVO.class).where(predicate);
        pageParam.setPaging(query);
        pageParam.fillOrders(query, Q_DO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{CreditAccountRepoProc.Q_DO.id, CreditAccountRepoProc.Q_DO.ouCode, CreditAccountRepoProc.Q_DO.ouId, CreditAccountRepoProc.Q_DO.ouName, CreditAccountRepoProc.Q_DO.objectType, CreditAccountRepoProc.Q_DO.objectName, CreditAccountRepoProc.Q_DO.creditAccountCode, CreditAccountRepoProc.Q_DO.creditAccountName, CreditAccountRepoProc.Q_DO.creditAccountType, CreditAccountRepoProc.Q_DO.objectCode, CreditAccountRepoProc.Q_DO.deptId, CreditAccountRepoProc.Q_DO.deptName, CreditAccountRepoProc.Q_DO.productLineCode, CreditAccountRepoProc.Q_DO.productLineName, CreditAccountRepoProc.Q_DO.creditAccountLimit, CreditAccountRepoProc.Q_DO.creditAccountUsedLimit, CreditAccountRepoProc.Q_DO.creditAccountOccupancyLimit, CreditAccountRepoProc.Q_DO.creditAccountAvailableLimit, CreditAccountRepoProc.Q_DO.status, CreditAccountRepoProc.Q_DO.remark, CreditAccountRepoProc.Q_DO.createTime, CreditAccountRepoProc.Q_DO.creator, CreditAccountRepoProc.Q_DO.createUserId, CreditAccountRepoProc.Q_DO.modifyTime, CreditAccountRepoProc.Q_DO.modifyUserId, CreditAccountRepoProc.Q_DO.updater, CreditAccountRepoProc.Q_DO.tenantId})).from((EntityPath)Q_DO);
    }

    private BaseRepoProc.PredicateBuilder commonBuilder(CreditAccountParam param) {
        return BaseRepoProc.PredicateBuilder.builder().andLike(StrUtil.isNotBlank((CharSequence)param.getOuName()), (StringExpression)CreditAccountRepoProc.Q_DO.ouName, param.getOuName()).andLike(StrUtil.isNotBlank((CharSequence)param.getCreditAccountCodeName()), new StringExpression[]{CreditAccountRepoProc.Q_DO.creditAccountCode, CreditAccountRepoProc.Q_DO.creditAccountName}, param.getCreditAccountCodeName()).andEq(StrUtil.isNotBlank((CharSequence)param.getOuCode()), (SimpleExpression)CreditAccountRepoProc.Q_DO.ouCode, (Object)param.getOuCode()).andLike(StrUtil.isNotBlank((CharSequence)param.getObjectName()), (StringExpression)CreditAccountRepoProc.Q_DO.objectName, param.getObjectName()).andEq(StrUtil.isNotBlank((CharSequence)param.getObjectCode()), (SimpleExpression)CreditAccountRepoProc.Q_DO.objectCode, (Object)param.getObjectCode()).andEq(StrUtil.isNotBlank((CharSequence)param.getStatus()), (SimpleExpression)CreditAccountRepoProc.Q_DO.status, (Object)param.getStatus()).andIn(CollectionUtil.isNotEmpty(param.getCreditAccountCodes()), (SimpleExpression)CreditAccountRepoProc.Q_DO.creditAccountCode, param.getCreditAccountCodes()).andEq(StringUtils.isNotEmpty((CharSequence)param.getCreditAccountType()), (SimpleExpression)CreditAccountRepoProc.Q_DO.creditAccountType, (Object)param.getCreditAccountType());
    }

    public List<CreditAccountDTO> findByParam(CreditAccountParam param) {
        Predicate predicate = this.commonBuilder(param).build();
        JPAQuery query = (JPAQuery)this.select(CreditAccountDTO.class).where(predicate);
        return query.fetch();
    }

    public List<CreditAccountDTO> getAccountByAccountParam(CreditAccountParam param) {
        Predicate predicate = this.commonBuilder(param).build();
        JPAQuery query = (JPAQuery)this.select(CreditAccountDTO.class).where(predicate);
        return query.fetch();
    }

    public List<CreditAccountInitialLimitDTO> findByInitialParam(List<CreditAccountInitialLimitParam> params) {
        ArrayList predicates = new ArrayList();
        params.stream().forEach(param -> {
            Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(StrUtil.isNotBlank((CharSequence)param.getCreditAccountName()), (SimpleExpression)CreditAccountRepoProc.Q_DO.creditAccountName, (Object)param.getCreditAccountName()).andEq(StrUtil.isNotBlank((CharSequence)param.getCreditAccountCode()), (SimpleExpression)CreditAccountRepoProc.Q_DO.creditAccountCode, (Object)param.getCreditAccountCode()).build();
            predicates.add(predicate);
        });
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CreditAccountInitialLimitDTO.class, (Expression[])new Expression[]{CreditAccountRepoProc.Q_DO.creditAccountCode, CreditAccountRepoProc.Q_DO.creditAccountName})).from((EntityPath)Q_DO)).where(ExpressionUtils.anyOf(predicates));
        return jpaQuery.fetch();
    }

    public void updateByParam(List<CreditAccountParam> params) {
        params.stream().forEach(param -> {
            JPAUpdateClause updateClause = this.jpaQueryFactory.update((EntityPath)Q_DO);
            updateClause.set(CreditAccountRepoProc.Q_DO.creditAccountLimit, (Object)param.getCreditAccountLimit()).set(CreditAccountRepoProc.Q_DO.creditAccountOccupancyLimit, (Object)param.getCreditAccountOccupancyLimit()).set(CreditAccountRepoProc.Q_DO.creditAccountUsedLimit, (Object)param.getCreditAccountUsedLimit()).set(CreditAccountRepoProc.Q_DO.creditAccountAvailableLimit, (Object)param.getCreditAccountAvailableLimit());
            updateClause.set(CreditAccountRepoProc.Q_DO.modifyTime, (Object)LocalDateTime.now());
            if (StrUtil.isNotBlank((CharSequence)param.getStatus())) {
                updateClause.set((Path)CreditAccountRepoProc.Q_DO.status, (Object)param.getStatus());
            }
            updateClause.where(new Predicate[]{CreditAccountRepoProc.Q_DO.creditAccountCode.eq((Object)param.getCreditAccountCodeName())});
            updateClause.execute();
        });
    }

    public CreditAccountDO findByCreditAccountCode(String creditAccountCode) {
        List<CreditAccountDO> creditAccountDOList = this.creditAccountRepo.findAllByCreditAccountCode(creditAccountCode);
        Assert.notEmpty(creditAccountDOList, (String)"\u4fe1\u7528\u8d26\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Assert.isTrue((creditAccountDOList.size() == 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5230\u591a\u6761\u4fe1\u7528\u8d26\u6237", (Object[])new Object[0]);
        CreditAccountDO creditAccountDO = creditAccountDOList.get(0);
        Assert.equals((Object)creditAccountDO.getStatus(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u4fe1\u7528\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
        return creditAccountDOList.get(0);
    }

    public CreditAccountDO findByCreditObjectCode(String objectCode) {
        List<CreditAccountDO> creditAccountDOList = this.creditAccountRepo.findAllByObjectCode(objectCode);
        Assert.notEmpty(creditAccountDOList, (String)"\u4fe1\u7528\u8d26\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Assert.isTrue((creditAccountDOList.size() == 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5230\u591a\u6761\u4fe1\u7528\u8d26\u6237", (Object[])new Object[0]);
        return creditAccountDOList.get(0);
    }

    public String findByCreditAccountName(String creditAccountName) {
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)CreditAccountRepoProc.Q_DO.creditAccountCode).from((EntityPath)Q_DO)).where((Predicate)CreditAccountRepoProc.Q_DO.creditAccountName.eq((Object)creditAccountName));
        return (String)query.fetchOne();
    }
}

