/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.imp;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitesland.fin.application.convert.limitadjustorder.LimitAdjustOrderConvert;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountDTO;
import com.elitesland.fin.application.facade.excel.adjust.CreditAdjustOrderImportEntity;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountParam;
import com.elitesland.fin.application.facade.param.limitadjustorder.LimitAdjustOrderParam;
import com.elitesland.fin.application.service.limitadjustorder.LimitAdjustOrderService;
import com.elitesland.fin.common.SysNumEnum;
import com.elitesland.fin.common.SysNumberGenerator;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.limitadjustorder.LimitAdjustOrderDO;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import com.elitesland.fin.repo.limitadjustorder.LimitAdjustOrderRepo;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CreditAdjustOrderImportServiceImpl
implements DataImport<CreditAdjustOrderImportEntity> {
    private static final Logger log = LoggerFactory.getLogger(CreditAdjustOrderImportServiceImpl.class);
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private final LimitAdjustOrderRepo limitAdjustOrderRepo;
    private final CreditAccountRepoProc creditAccountRepoProc;
    private final UdcProvider udcProvider;
    private final SysNumberGenerator sysNumberGenerator;
    private final LimitAdjustOrderService limitAdjustOrderService;

    public String getTmplCode() {
        return "credit_adjust_order_import";
    }

    public List<String> executeImport(List<CreditAdjustOrderImportEntity> dataList, int rowId) {
        if (CollectionUtil.isEmpty(dataList)) {
            return List.of();
        }
        Set<String> accountCodeList = dataList.stream().map(CreditAdjustOrderImportEntity::getCreditAccountCode).filter(code -> StrUtil.isNotBlank((CharSequence)code)).collect(Collectors.toSet());
        HashMap<String, CreditAccountDTO> accountMap = new HashMap();
        if (CollectionUtil.isNotEmpty(accountCodeList)) {
            CreditAccountParam creditAccountParam = new CreditAccountParam();
            creditAccountParam.setCreditAccountCodes(accountCodeList);
            List<CreditAccountDTO> creditCreditAccountDTOList = this.creditAccountRepoProc.getAccountByAccountParam(creditAccountParam);
            accountMap = creditCreditAccountDTOList.stream().collect(Collectors.toMap(CreditAccountDTO::getCreditAccountCode, t -> t, (t1, t2) -> t2));
        }
        Map udcCodeMap = this.udcProvider.getValueMapByUdcCode(UdcEnum.CREDIT_TYPE_1.getModel(), Set.of(UdcEnum.CREDIT_TYPE_1.getCode(), UdcEnum.ADJUST_TYPE_1.getCode(), UdcEnum.FIN_ADJUST_REASON_1.getCode()));
        Map<String, String> creditTypeMap = ((Map)udcCodeMap.get(UdcEnum.CREDIT_TYPE_1.getCode())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (v1, v2) -> v1));
        Map<String, String> adjustTypeMap = ((Map)udcCodeMap.get(UdcEnum.ADJUST_TYPE_1.getCode())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (v1, v2) -> v1));
        Map<String, String> adjustReasonMap = ((Map)udcCodeMap.get(UdcEnum.FIN_ADJUST_REASON_1.getCode())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (v1, v2) -> v1));
        ArrayList<String> errorResult = new ArrayList<String>();
        ArrayList<LimitAdjustOrderParam> saveList = new ArrayList<LimitAdjustOrderParam>();
        HashMap<String, BigDecimal> amtMap = new HashMap<String, BigDecimal>();
        for (CreditAdjustOrderImportEntity entity : dataList) {
            if (!StrUtil.isNotBlank((CharSequence)entity.getCreditAccountCode()) || !NumberUtil.isNumber((CharSequence)entity.getAdjustLimit()) || !StrUtil.equals((CharSequence)entity.getAdjustTypeName(), (CharSequence)UdcEnum.ADJUST_TYPE_2.getValueCodeName())) continue;
            BigDecimal bigDecimal = new BigDecimal(entity.getAdjustLimit());
            BigDecimal totalAmt = amtMap.get(entity.getCreditAccountCode()) == null ? bigDecimal : ((BigDecimal)amtMap.get(entity.getCreditAccountCode())).add(bigDecimal);
            amtMap.put(entity.getCreditAccountCode(), totalAmt);
        }
        for (CreditAdjustOrderImportEntity importEntity : dataList) {
            LimitAdjustOrderParam adjustOrderParam = new LimitAdjustOrderParam();
            ArrayList<String> errorList = new ArrayList<String>();
            this.checkImportMandatoryField(importEntity, errorList, rowId);
            this.checkUdc(rowId, importEntity, adjustOrderParam, errorList, adjustTypeMap, adjustReasonMap, creditTypeMap);
            this.checkAccount(rowId, importEntity, adjustOrderParam, errorList, accountMap, amtMap);
            adjustOrderParam.setRemark(importEntity.getRemark());
            adjustOrderParam.setDocState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
            if (CollectionUtils.isNotEmpty(errorList)) {
                errorResult.add(StringUtils.join(errorList, (String)"\n"));
            } else {
                String docNo = this.sysNumberGenerator.generate(SysNumEnum.FIN_ADJ_ORDER.getCode());
                adjustOrderParam.setDocNo(docNo);
                errorResult.add(null);
                saveList.add(adjustOrderParam);
            }
            ++rowId;
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.saveData(saveList);
            return CollectionUtil.isNotEmpty(errorResult) ? errorResult : null;
        }
        return errorResult;
    }

    private void checkUdc(int rowId, CreditAdjustOrderImportEntity importEntity, LimitAdjustOrderParam adjustOrderParam, List<String> errorList, Map<String, String> adjustTypeMap, Map<String, String> adjustReasonMap, Map<String, String> creditTypeMap) {
        if (adjustReasonMap.containsKey(importEntity.getAdjustReasonName())) {
            adjustOrderParam.setAdjustReason(adjustReasonMap.get(importEntity.getAdjustReasonName()));
        } else {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u539f\u56e0", "\u586b\u5199\u4e0d\u6b63\u786e"));
        }
        if (adjustTypeMap.containsKey(importEntity.getAdjustTypeName())) {
            adjustOrderParam.setAdjustType(adjustTypeMap.get(importEntity.getAdjustTypeName()));
        } else {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u7c7b\u578b", "\u586b\u5199\u4e0d\u6b63\u786e"));
        }
        if (creditTypeMap.containsKey(importEntity.getCreditTypeName())) {
            adjustOrderParam.setCreditType(creditTypeMap.get(importEntity.getCreditTypeName()));
        } else {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u6388\u4fe1\u7c7b\u578b", "\u586b\u5199\u4e0d\u6b63\u786e"));
        }
    }

    private void checkAccount(int rowId, CreditAdjustOrderImportEntity importEntity, LimitAdjustOrderParam adjustOrderParam, List<String> errorList, Map<String, CreditAccountDTO> accountMap, Map<String, BigDecimal> amtMap) {
        BigDecimal amt = BigDecimal.ZERO;
        if (NumberUtil.isNumber((CharSequence)importEntity.getAdjustLimit())) {
            amt = new BigDecimal(importEntity.getAdjustLimit());
            if (NumberUtil.isLess((BigDecimal)amt, (BigDecimal)BigDecimal.ZERO)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u91d1\u989d", "\u4e0d\u80fd\u5c0f\u4e8e0"));
            } else {
                Pattern pattern = Pattern.compile("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$");
                if (!pattern.matcher(importEntity.getAdjustLimit()).matches()) {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u91d1\u989d", "\u8c03\u6574\u91d1\u989d\uff0c\u6700\u591a\u4e24\u4f4d\u5c0f\u6570"));
                }
            }
        } else {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u91d1\u989d", "\u683c\u5f0f\u4e0d\u5bf9"));
        }
        if (accountMap.containsKey(importEntity.getCreditAccountCode())) {
            CreditAccountDTO accountDTO = accountMap.get(importEntity.getCreditAccountCode());
            if (!StrUtil.equals((CharSequence)accountDTO.getStatus(), (CharSequence)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode())) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u672a\u6fc0\u6d3b"));
            }
            if (StrUtil.equals((CharSequence)adjustOrderParam.getAdjustType(), (CharSequence)UdcEnum.ADJUST_TYPE_2.getValueCode()) && amtMap.containsKey(importEntity.getCreditAccountCode())) {
                if (NumberUtil.isGreater((BigDecimal)amtMap.get(importEntity.getCreditAccountCode()), (BigDecimal)accountDTO.getCreditAccountLimit())) {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u91d1\u989d", "\u8c03\u51fa\u91d1\u989d\u5927\u4e8e\u4fe1\u7528\u8d26\u6237\u989d\u5ea6"));
                }
                if (NumberUtil.isGreater((BigDecimal)amtMap.get(importEntity.getCreditAccountCode()), (BigDecimal)accountDTO.getCreditAccountAvailableLimit())) {
                    errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u91d1\u989d", "\u8c03\u51fa\u91d1\u989d\u5927\u4e8e\u4fe1\u7528\u8d26\u6237\u53ef\u7528\u989d\u5ea6"));
                }
            }
            adjustOrderParam.setCreditAccountCode(accountDTO.getCreditAccountCode());
            adjustOrderParam.setCreditAccountName(accountDTO.getCreditAccountName());
            adjustOrderParam.setAdjustLimit(amt);
            adjustOrderParam.setOuName(accountDTO.getOuName());
            adjustOrderParam.setOuCode(accountDTO.getOuCode());
            adjustOrderParam.setObjectType(accountDTO.getObjectType());
            adjustOrderParam.setObjectName(accountDTO.getObjectName());
            adjustOrderParam.setProductLine(accountDTO.getProductLineCode());
            adjustOrderParam.setSaleUser(accountDTO.getSalesmanName());
            adjustOrderParam.setBuName(accountDTO.getDeptName());
            adjustOrderParam.setBuCode(accountDTO.getDeptCode());
        } else {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u4e0d\u5b58\u5728"));
        }
        try {
            if (StrUtil.isNotBlank((CharSequence)importEntity.getEffectiveTime())) {
                LocalDateTime effectiveTime = LocalDateTimeUtil.parse((CharSequence)importEntity.getEffectiveTime(), (DateTimeFormatter)DatetimeUtil.FORMATTER_DATE);
                adjustOrderParam.setEffectiveTime(effectiveTime);
            }
        }
        catch (Exception e) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u6548\u671f\u8d77", "\u6548\u671f\u8d77\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u9700\u4e3ayyyy-MM-dd"));
        }
        try {
            if (StrUtil.isNotBlank((CharSequence)importEntity.getExpireTime())) {
                LocalDateTime expireTime = LocalDateTimeUtil.parse((CharSequence)importEntity.getExpireTime(), (DateTimeFormatter)DatetimeUtil.FORMATTER_DATE);
                LocalDateTime localDateTime = expireTime.withHour(23).withMinute(59).withSecond(59);
                adjustOrderParam.setExpireTime(localDateTime);
            }
        }
        catch (Exception e) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u6548\u671f\u81f3", "\u6548\u671f\u81f3\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u9700\u4e3ayyyy-MM-dd"));
        }
        if (ObjUtil.isNotNull((Object)adjustOrderParam.getEffectiveTime()) && ObjUtil.isNotNull((Object)adjustOrderParam.getExpireTime()) && adjustOrderParam.getEffectiveTime().isAfter(adjustOrderParam.getExpireTime())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u6709\u6548\u671f", "\u6548\u671f\u81f3\u4e0d\u80fd\u65e9\u4e8e\u6548\u671f\u8d77"));
        }
    }

    private void checkImportMandatoryField(CreditAdjustOrderImportEntity importEntity, List<String> errorList, int rowId) {
        if (StringUtils.isBlank((CharSequence)importEntity.getCreditTypeName())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u6388\u4fe1\u7c7b\u578b", "\u6388\u4fe1\u7c7b\u578b\u5fc5\u586b"));
        }
        if (StringUtils.isBlank((CharSequence)importEntity.getAdjustTypeName())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u7c7b\u578b", "\u8c03\u6574\u7c7b\u578b\u5fc5\u586b"));
        }
        if (StringUtils.isBlank((CharSequence)importEntity.getEffectiveTime())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u6548\u671f\u8d77", "\u6548\u671f\u8d77\u5fc5\u586b"));
        }
        if (StringUtils.isBlank((CharSequence)importEntity.getExpireTime())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u6548\u671f\u81f3", "\u6548\u671f\u81f3\u5fc5\u586b"));
        }
        if (StringUtils.isBlank((CharSequence)importEntity.getCreditAccountCode())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u7f16\u7801\u5fc5\u586b"));
        }
        if (StringUtils.isBlank((CharSequence)importEntity.getAdjustLimit())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u989d\u5ea6", "\u8c03\u6574\u989d\u5ea6\u5fc5\u586b"));
        }
        if (StringUtils.isBlank((CharSequence)importEntity.getAdjustReasonName())) {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8c03\u6574\u539f\u56e0", "\u8c03\u6574\u539f\u56e0\u5fc5\u586b"));
        }
    }

    public void saveData(List<LimitAdjustOrderParam> saveList) {
        List<LimitAdjustOrderDO> doList = LimitAdjustOrderConvert.INSTANCE.limitAdjustOrderParams2LimitAdjustOrderDOs(saveList);
        List adjustOrderDOS = this.limitAdjustOrderRepo.saveAll(doList);
        this.submit(adjustOrderDOS);
    }

    public void submit(List<LimitAdjustOrderDO> doList) {
        doList.stream().forEach(adjustOrderDO -> this.limitAdjustOrderService.submit(adjustOrderDO.getId()));
    }

    public CreditAdjustOrderImportServiceImpl(LimitAdjustOrderRepo limitAdjustOrderRepo, CreditAccountRepoProc creditAccountRepoProc, UdcProvider udcProvider, SysNumberGenerator sysNumberGenerator, LimitAdjustOrderService limitAdjustOrderService) {
        this.limitAdjustOrderRepo = limitAdjustOrderRepo;
        this.creditAccountRepoProc = creditAccountRepoProc;
        this.udcProvider = udcProvider;
        this.sysNumberGenerator = sysNumberGenerator;
        this.limitAdjustOrderService = limitAdjustOrderService;
    }
}

