/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.rpc.system;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.elitescloud.cloudt.system.service.SysSettingService;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.rpc.system.SystemRpcService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SystemRpcServiceImpl
implements SystemRpcService {
    private static final Logger log = LoggerFactory.getLogger(SystemRpcServiceImpl.class);
    private final SysUserRpcService sysUserRpcService;
    private final SeqNumProvider sysNumberRuleService;
    private final SysCurrencyRpcService sysCurrencyRpcService;
    private final SysSettingService sysSettingService;

    @Override
    public SysUserDTO getUserByName(String userName) {
        ApiResult user = this.sysUserRpcService.getUserByUsername(userName);
        if (user != null) {
            if (user.getData() != null) {
                return (SysUserDTO)user.getData();
            }
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7528\u6237\u540d\u79f0" + userName + "\u83b7\u53d6\u4fe1\u606f\u4e3a\u7a7a!");
        }
        throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7528\u6237\u540d\u79f0 " + userName + "\u83b7\u53d6\u4fe1\u606f\u4e3a\u7a7a!");
    }

    @Override
    public String sysNumberRuleGenerateCode(String appCode, String code, List<String> runtimeValues) {
        log.info("\u7cfb\u7edf\u57df\u53d1\u53f7\u5668\u8c03\u7528\uff1a\u65f6\u95f4\uff1a{}\uff0c\u53c2\u6570{},{}", new Object[]{LocalDateTime.now(), code, runtimeValues});
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(runtimeValues);
        try {
            return this.sysNumberRuleService.generateCode(appCode, code, list);
        }
        catch (Exception e) {
            log.error("sysNumberRuleGenerateCode error:", (Throwable)e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u53d1\u53f7\u5931\u8d25");
        }
    }

    @Override
    public SysCurrencyRespDTO findCurrByCode(String currCode) {
        ApiResult apiResult = this.sysCurrencyRpcService.getByCode(currCode);
        Assert.notNull((Object)apiResult, (String)"\u8fdc\u7a0b\u8c03\u7528\u67e5\u8be2\u5e01\u79cd\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        Assert.isTrue((boolean)apiResult.isSuccess(), (String)"\u67e5\u8be2\u5e01\u79cd\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        return (SysCurrencyRespDTO)apiResult.getData();
    }

    @Override
    public SysSettingVO findSysSettingByNo(String no) {
        return this.sysSettingService.oneByNo(no);
    }

    public SystemRpcServiceImpl(SysUserRpcService sysUserRpcService, SeqNumProvider sysNumberRuleService, SysCurrencyRpcService sysCurrencyRpcService, SysSettingService sysSettingService) {
        this.sysUserRpcService = sysUserRpcService;
        this.sysNumberRuleService = sysNumberRuleService;
        this.sysCurrencyRpcService = sysCurrencyRpcService;
        this.sysSettingService = sysSettingService;
    }
}

