/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.arorder;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.SecurityUtil;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.facade.param.arorder.ArOrderSaveParam;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderVO;
import com.elitesland.fin.application.service.arorder.ArOrderService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.arorder.ArOrderDtlDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeDomainService;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ArOrderServiceImpl
implements ArOrderService {
    private final ArOrderDomainService arOrderDomainService;
    private final ArOrderDtlDomainService arOrderDtlDomainService;
    private final ArTypeDomainService arTypeDomainService;
    private final SystemRpcService systemRpcService;
    private final WorkflowRpcService workflowRpcService;

    @Override
    @SysCodeProc
    public PagingVO<ArOrderVO> page(ArOrderPageParam arOrderPageParam) {
        PagingVO<ArOrderDTO> page = this.arOrderDomainService.page(arOrderPageParam);
        return ArOrderConvert.INSTANCE.convertPage(page);
    }

    @Override
    @SysCodeProc
    public ArOrderVO get(Long id) {
        ArOrderDTO arOrderDTO = this.arOrderDomainService.get(id);
        ArOrderVO res = ArOrderConvert.INSTANCE.convert(arOrderDTO);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> audit(Long id) {
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> refush(List<Long> ids, String content) {
        SysUserDTO user = SecurityUtil.getUser().getUser();
        Long res = this.arOrderDomainService.audit(ids, content, user);
        return ApiResult.ok((Object)res);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> del(List<Long> ids) {
        Long res = this.arOrderDomainService.del(ids);
        return ApiResult.ok((Object)res);
    }

    @Override
    @SysCodeProc
    public ArOrderVO getArOrderAndDtl(Long id) {
        ArOrderDTO arOrderAndDtl = this.arOrderDomainService.getArOrderAndDtl(id);
        ArOrderVO res = ArOrderConvert.INSTANCE.convert(arOrderAndDtl);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(ArOrderSaveParam apOrderSaveParam) {
        if (!apOrderSaveParam.getCreateMode().equals(UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            throw new BusinessException("\u65b0\u589e\u7684\u5355\u636e\u6765\u6e90\u9700\u4e3a\u624b\u5de5");
        }
        ArOrder apOrder = ArOrderConvert.INSTANCE.convert(apOrderSaveParam);
        Long res = this.arOrderDomainService.save(apOrder);
        return ApiResult.ok((Object)res);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public ApiResult<Long> commit(ArOrderSaveParam apOrderSaveParam) {
        ArOrder apOrder = ArOrderConvert.INSTANCE.convert(apOrderSaveParam);
        Boolean isAuto = this.arTypeDomainService.queryIsAuto(apOrderSaveParam.getArTypeId());
        if (isAuto.booleanValue()) {
            apOrder.setAuditDate(LocalDateTime.now());
            apOrder.setAuditUser("admin");
            SysUserDTO user = this.systemRpcService.getUserByName("admin");
            apOrder.setAuditUserId(user.getId());
        }
        Long resId = this.arOrderDomainService.commit(apOrder, isAuto);
        if (!isAuto.booleanValue()) {
            this.startWorkFlow(apOrder, resId);
        }
        return ApiResult.ok((Object)resId);
    }

    private void startWorkFlow(ArOrder apOrder, Long resId) {
        if (apOrder.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(apOrder.getProcInstStatus())) {
            String procInstName = "\u5e94\u6536\u5355\u5ba1\u6838-" + apOrder.getArOrderNo();
            String procKey = WorkFlowDefKey.FIN_AR_ORDER.name();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(procKey, procInstName, resId.toString(), new HashMap<String, Object>());
            this.arOrderDomainService.updateWorkInfo(processInfo, resId);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> update(ArOrderSaveParam apOrderSaveParam) {
        ArOrder apOrder = ArOrderConvert.INSTANCE.convert(apOrderSaveParam);
        apOrder.checkUpdate();
        Long res = this.arOrderDomainService.save(apOrder);
        return ApiResult.ok((Object)res);
    }

    public ArOrderServiceImpl(ArOrderDomainService arOrderDomainService, ArOrderDtlDomainService arOrderDtlDomainService, ArTypeDomainService arTypeDomainService, SystemRpcService systemRpcService, WorkflowRpcService workflowRpcService) {
        this.arOrderDomainService = arOrderDomainService;
        this.arOrderDtlDomainService = arOrderDtlDomainService;
        this.arTypeDomainService = arTypeDomainService;
        this.systemRpcService = systemRpcService;
        this.workflowRpcService = workflowRpcService;
    }
}

