/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.imp;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitesland.fin.application.convert.creditaccount.CreditAccountInitialLimitConvert;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountInitialLimitDTO;
import com.elitesland.fin.application.facade.excel.creditaccount.InitialLimitImportEntity;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountInitialLimitParam;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.creditaccount.CreditAccountInitialLimitDO;
import com.elitesland.fin.repo.creditaccount.CreditAccountInitialLimitRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountInitialLimitRepoProc;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InitialLimitImportServiceImpl
implements DataImport<InitialLimitImportEntity> {
    private static final Logger log = LoggerFactory.getLogger(InitialLimitImportServiceImpl.class);
    private static final String ERROR_TEMPLATE = "\u7b2c {0} \u884c: {1} \u89e3\u6790\u5f02\u5e38: {2}; ";
    private final CreditAccountRepoProc creditAccountRepoProc;
    private final CreditAccountInitialLimitRepo creditAccountInitialLimitRepo;
    private final CreditAccountInitialLimitRepoProc creditAccountInitialLimitRepoProc;

    public String getTmplCode() {
        return "yst_fin_initial_limit_import";
    }

    public List<String> executeImport(List<InitialLimitImportEntity> dataList, int rowId) {
        String userName = SecurityContextUtil.currentUserName();
        Long userId = SecurityContextUtil.currentUserId();
        if (CollectionUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        Set<String> creditAccountNameList = dataList.stream().map(InitialLimitImportEntity::getCreditAccountName).collect(Collectors.toSet());
        Set<String> creditAccountCodeList = dataList.stream().map(InitialLimitImportEntity::getCreditAccountCode).collect(Collectors.toSet());
        ArrayList<String> errorResult = new ArrayList<String>();
        this.beforeImportCheck(dataList, rowId, creditAccountNameList, creditAccountCodeList, errorResult);
        if (CollectionUtil.isNotEmpty(errorResult)) {
            return errorResult;
        }
        ArrayList<CreditAccountInitialLimitParam> params = new ArrayList<CreditAccountInitialLimitParam>();
        dataList.stream().forEach(item -> {
            CreditAccountInitialLimitParam param = new CreditAccountInitialLimitParam();
            param.setCreditAccountCode(item.getCreditAccountCode());
            param.setCreditAccountName(item.getCreditAccountName());
            params.add(param);
        });
        List<CreditAccountInitialLimitDTO> limitDTOList = this.creditAccountRepoProc.findByInitialParam(params);
        ArrayList<String> codeList = new ArrayList();
        ArrayList<String> nameList = new ArrayList();
        if (CollectionUtil.isNotEmpty(limitDTOList)) {
            codeList = limitDTOList.stream().map(CreditAccountInitialLimitDTO::getCreditAccountCode).collect(Collectors.toList());
            nameList = limitDTOList.stream().map(CreditAccountInitialLimitDTO::getCreditAccountName).collect(Collectors.toList());
        }
        List<String> finishedCodeList = List.of();
        List<String> finishedNameList = List.of();
        Map<Object, Object> draftMap = Map.of();
        List<CreditAccountInitialLimitDTO> dtoList = this.creditAccountInitialLimitRepoProc.findByParam(params);
        if (CollectionUtil.isNotEmpty(dtoList)) {
            finishedCodeList = dtoList.stream().filter(dto -> StrUtil.equals((CharSequence)dto.getStatus(), (CharSequence)UdcEnum.INITIAL_STATUS_FINISHED.getValueCode())).map(CreditAccountInitialLimitDTO::getCreditAccountCode).collect(Collectors.toList());
            finishedNameList = dtoList.stream().filter(dto -> StrUtil.equals((CharSequence)dto.getStatus(), (CharSequence)UdcEnum.INITIAL_STATUS_FINISHED.getValueCode())).map(CreditAccountInitialLimitDTO::getCreditAccountName).collect(Collectors.toList());
            draftMap = dtoList.stream().filter(dto -> StrUtil.equals((CharSequence)dto.getStatus(), (CharSequence)UdcEnum.INITIAL_STATUS_DRAFT.getValueCode())).collect(Collectors.toMap(item -> item.getCreditAccountCode() + "_" + item.getCreditAccountName(), t -> t, (t1, t2) -> t1));
        }
        ArrayList<InitialLimitImportEntity> saveList = new ArrayList<InitialLimitImportEntity>();
        ArrayList<String> codes = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        for (InitialLimitImportEntity importEntity : dataList) {
            ArrayList<String> errorList = new ArrayList<String>();
            this.checkAccount(rowId, errorList, codeList, nameList, finishedCodeList, finishedNameList, importEntity, codes, names);
            this.checkLimit(rowId, importEntity, errorList);
            if (CollectionUtil.isNotEmpty(draftMap) && draftMap.containsKey(importEntity.getCreditAccountCode() + "_" + importEntity.getCreditAccountName())) {
                importEntity.setId(((CreditAccountInitialLimitDTO)draftMap.get(importEntity.getCreditAccountCode() + "_" + importEntity.getCreditAccountName())).getId());
                importEntity.setCreator(userName);
                importEntity.setCreateUserId(userId);
                importEntity.setCreateTime(LocalDateTime.now());
            }
            if (CollectionUtils.isNotEmpty(errorList)) {
                errorResult.add(StringUtils.join(errorList, (String)"\n"));
            } else {
                errorResult.add(null);
                importEntity.setStatus(UdcEnum.INITIAL_STATUS_DRAFT.getValueCode());
                saveList.add(importEntity);
            }
            ++rowId;
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.saveData(saveList);
            return CollectionUtil.isNotEmpty(errorResult) ? errorResult : null;
        }
        return errorResult;
    }

    private void checkLimit(int rowId, InitialLimitImportEntity importEntity, List<String> errorList) {
        Pattern pattern = Pattern.compile("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$");
        if (NumberUtil.isNumber((CharSequence)importEntity.getInitialAccountLimit())) {
            if (!pattern.matcher(importEntity.getInitialAccountLimit()).matches()) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u989d\u5ea6", "\u8d26\u6237\u989d\u5ea6\uff0c\u6700\u591a\u4e24\u4f4d\u5c0f\u6570"));
            }
            if (NumberUtil.isLess((BigDecimal)new BigDecimal(importEntity.getInitialAccountLimit()), (BigDecimal)BigDecimal.ZERO)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u989d\u5ea6", "\u8d26\u6237\u989d\u5ea6\uff0c\u4e0d\u80fd\u5c0f\u4e8e0"));
            }
        } else {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u989d\u5ea6", "\u8d26\u6237\u989d\u5ea6\uff0c\u53ea\u80fd\u586b\u7eaf\u6570\u503c\u7c7b\u578b\u6570\u636e"));
        }
        if (NumberUtil.isNumber((CharSequence)importEntity.getInitialAccountUsedLimit())) {
            if (!pattern.matcher(importEntity.getInitialAccountUsedLimit()).matches()) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u4f7f\u7528\u989d\u5ea6", "\u8d26\u6237\u4f7f\u7528\u989d\u5ea6\uff0c\u6700\u591a\u4e24\u4f4d\u5c0f\u6570"));
            }
            if (NumberUtil.isLess((BigDecimal)new BigDecimal(importEntity.getInitialAccountUsedLimit()), (BigDecimal)BigDecimal.ZERO)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u4f7f\u7528\u989d\u5ea6", "\u8d26\u6237\u4f7f\u7528\u989d\u5ea6\uff0c\u4e0d\u80fd\u5c0f\u4e8e0"));
            }
        } else {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u4f7f\u7528\u989d\u5ea6", "\u8d26\u6237\u4f7f\u7528\u989d\u5ea6\uff0c\u53ea\u80fd\u586b\u7eaf\u6570\u503c\u7c7b\u578b\u6570\u636e"));
        }
        if (NumberUtil.isNumber((CharSequence)importEntity.getInitialAccountOccupancyLimit())) {
            if (!pattern.matcher(importEntity.getInitialAccountOccupancyLimit()).matches()) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u5360\u7528\u989d\u5ea6", "\u8d26\u6237\u5360\u7528\u989d\u5ea6\uff0c\u6700\u591a\u4e24\u4f4d\u5c0f\u6570"));
            }
            if (NumberUtil.isLess((BigDecimal)new BigDecimal(importEntity.getInitialAccountOccupancyLimit()), (BigDecimal)BigDecimal.ZERO)) {
                errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u5360\u7528\u989d\u5ea6", "\u8d26\u6237\u5360\u7528\u989d\u5ea6\uff0c\u4e0d\u80fd\u5c0f\u4e8e0"));
            }
        } else {
            errorList.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u5360\u7528\u989d\u5ea6", "\u8d26\u6237\u5360\u7528\u989d\u5ea6\uff0c\u53ea\u80fd\u586b\u7eaf\u6570\u503c\u7c7b\u578b\u6570\u636e"));
        }
    }

    private void checkAccount(int rowId, List<String> errorResult, List<String> codeList, List<String> nameList, List<String> finishedCodeList, List<String> finishedNameList, InitialLimitImportEntity importEntity, List<String> codes, List<String> names) {
        if (CollectionUtil.isNotEmpty(codes) && codes.contains(importEntity.getCreditAccountCode())) {
            errorResult.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u7f16\u7801\u91cd\u590d"));
        }
        if (CollectionUtil.isNotEmpty(names) && names.contains(importEntity.getCreditAccountName())) {
            errorResult.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u540d\u79f0", "\u8d26\u6237\u540d\u79f0\u91cd\u590d"));
        }
        if (StrUtil.isBlank((CharSequence)importEntity.getCreditAccountName())) {
            errorResult.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u540d\u79f0", "\u8d26\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
        } else {
            names.add(importEntity.getCreditAccountName());
        }
        if (StrUtil.isBlank((CharSequence)importEntity.getCreditAccountCode())) {
            errorResult.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        } else {
            codes.add(importEntity.getCreditAccountCode());
        }
        if (CollectionUtil.isEmpty(nameList) || !nameList.contains(importEntity.getCreditAccountName())) {
            errorResult.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "", "\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u8d26\u6237"));
        } else if (CollectionUtil.isEmpty(codeList) || !codeList.contains(importEntity.getCreditAccountCode())) {
            errorResult.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "", "\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u8d26\u6237"));
        }
        if (CollectionUtil.isNotEmpty(finishedNameList) && finishedNameList.contains(importEntity.getCreditAccountName())) {
            errorResult.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u540d\u79f0", "\u8d26\u6237\u5df2\u7ecf\u5bfc\u5165\u8fc7\u989d\u5ea6"));
        }
        if (CollectionUtil.isNotEmpty(finishedCodeList) && finishedCodeList.contains(importEntity.getCreditAccountCode())) {
            errorResult.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u5df2\u7ecf\u5bfc\u5165\u8fc7\u989d\u5ea6"));
        }
    }

    private void beforeImportCheck(List<InitialLimitImportEntity> dataList, int rowId, Set<String> creditAccountNameList, Set<String> creditAccountCodeList, List<String> errorResult) {
        int i;
        if (CollectionUtil.isEmpty(creditAccountNameList)) {
            for (i = 0; i < dataList.size(); ++i) {
                errorResult.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u540d\u79f0", "\u8d26\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
                ++rowId;
            }
        }
        if (CollectionUtil.isEmpty(creditAccountCodeList)) {
            for (i = 0; i < dataList.size(); ++i) {
                errorResult.add(MessageFormat.format(ERROR_TEMPLATE, rowId, "\u8d26\u6237\u7f16\u7801", "\u8d26\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                ++rowId;
            }
        }
    }

    public void saveData(List<InitialLimitImportEntity> saveList) {
        List<CreditAccountInitialLimitDO> doList = CreditAccountInitialLimitConvert.INSTANCE.importEntitys2Dos(saveList);
        this.creditAccountInitialLimitRepo.saveAll(doList);
    }

    public InitialLimitImportServiceImpl(CreditAccountRepoProc creditAccountRepoProc, CreditAccountInitialLimitRepo creditAccountInitialLimitRepo, CreditAccountInitialLimitRepoProc creditAccountInitialLimitRepoProc) {
        this.creditAccountRepoProc = creditAccountRepoProc;
        this.creditAccountInitialLimitRepo = creditAccountInitialLimitRepo;
        this.creditAccountInitialLimitRepoProc = creditAccountInitialLimitRepoProc;
    }
}

