/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.invoice.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitesland.fin.application.convert.invoice.InvoiceAwaitConvert;
import com.elitesland.fin.application.convert.invoice.InvoiceAwaitDConvert;
import com.elitesland.fin.application.convert.invoice.InvoiceConvert;
import com.elitesland.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.fin.application.facade.dto.invoice.InvoiceAwaitDDTO;
import com.elitesland.fin.application.facade.dto.invoice.InvoiceAwaitDTO;
import com.elitesland.fin.application.facade.dto.mq.DemoMqMessageDTO;
import com.elitesland.fin.application.facade.param.invoice.ApplyInvoiceParam;
import com.elitesland.fin.application.facade.param.invoice.ApplySaveParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceAwaitQueryParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvStatusParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitDVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitRespVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceCustVO;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.SysNumEnum;
import com.elitesland.fin.common.SysNumberGenerator;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.SaleInv;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtl;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDtlDO;
import com.elitesland.fin.domain.service.invoice.InvoiceRuleConfigDomainService;
import com.elitesland.fin.domain.service.saleinv.SaleInvDomainService;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDDO;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDO;
import com.elitesland.fin.infr.dto.invoice.InvoiceApplyDTO;
import com.elitesland.fin.infr.dto.invoice.InvoiceRuleConfigDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.param.saleinv.InvoiceDetailSaveParam;
import com.elitesland.fin.repo.invoice.InvoiceApplyRepoProc;
import com.elitesland.fin.repo.invoice.InvoiceAwaitDRepo;
import com.elitesland.fin.repo.invoice.InvoiceAwaitRepo;
import com.elitesland.fin.repo.invoice.InvoiceAwaitRepoProc;
import com.elitesland.fin.rpc.order.RmiOrderRpcService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.utils.FinIamUtil;
import com.elitesland.order.param.SalReconciliatInvDTO;
import com.elitesland.order.param.SalReconciliatQueryDTO;
import com.elitesland.order.param.SaleReconciliatDTO;
import com.elitesland.order.param.SaleReconciliatDtlDTO;
import com.elitesland.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import io.seata.common.util.CollectionUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class InvoiceAwaitServiceImpl
implements InvoiceAwaitService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceAwaitServiceImpl.class);
    private final InvoiceAwaitRepoProc invoiceAwaitRepoProc;
    private final InvoiceAwaitDRepo invoiceAwaitDRepo;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final RmiOrgOuRpcServiceService orgRpcService;
    private final WorkflowRpcService workflowRpcService;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvDtlRepoProc saleInvDtlRepoProc;
    private final SaleInvDtlRepo saleInvDtlRepo;
    private final TransactionTemplate transactionTemplate;
    private final InvoiceRuleConfigDomainService ruleConfigDomainService;
    private final SystemRpcService systemRpcService;
    private final InvoiceApplyRepoProc invoiceApplyRepoProc;
    private final RmiOrderRpcService rmiOrderRpcService;
    private final InvoiceAwaitRepo invoiceAwaitRepo;
    private final SysNumberGenerator sysNumberGenerator;
    private final SaleInvDomainService saleInvDomainService;
    private final MessageQueueTemplate messageQueueTemplate;
    private final UdcProvider udcProvider;

    @Override
    @SysCodeProc
    public PagingVO<InvoiceAwaitVO> queryInvoiceAwait(InvoiceAwaitQueryParam param) {
        PagingVO<InvoiceAwaitDTO> pagingDto = this.invoiceAwaitRepoProc.queryInvoiceAwait(param);
        if (CollectionUtil.isEmpty((Collection)pagingDto.getRecords())) {
            return PagingVO.builder();
        }
        List<Long> masIds = pagingDto.stream().map(item -> item.getId()).collect(Collectors.toList());
        List<InvoiceAwaitDDO> dtlDos = this.invoiceAwaitDRepo.findAllByMasIdIn(masIds);
        Map<Long, List<InvoiceAwaitDDO>> map = dtlDos.stream().collect(Collectors.groupingBy(InvoiceAwaitDDO::getMasId));
        ArrayList<InvoiceRuleConfigQueryParam> paramList = new ArrayList<InvoiceRuleConfigQueryParam>();
        ArrayList<ApplyInvoiceParam> custParamList = new ArrayList<ApplyInvoiceParam>();
        pagingDto.stream().forEach(dto -> {
            InvoiceRuleConfigQueryParam queryParam = new InvoiceRuleConfigQueryParam();
            queryParam.setOptDocCls(dto.getOptDocCls());
            queryParam.setOptDocType(dto.getOptDocType());
            queryParam.setOptDocStatus(dto.getOptDocStatus());
            paramList.add(queryParam);
            ApplyInvoiceParam custParam = new ApplyInvoiceParam();
            custParam.setCustCode(dto.getMainCustCode());
            custParamList.add(custParam);
        });
        List<InvoiceRuleConfigDTO> ruleConfigList = this.ruleConfigDomainService.getRuleConfigList(paramList);
        Map<String, InvoiceRuleConfigDTO> ruleMap = ruleConfigList.stream().collect(Collectors.toMap(rule -> rule.getOptDocCls() + "_" + rule.getOptDocType() + "_" + rule.getOptDocStatus(), t -> t, (t1, t2) -> t1));
        List<Object> invoiceCustVOS = new ArrayList();
        try {
            invoiceCustVOS = this.invQuery(custParamList);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4e3b\u5ba2\u6237\u4fe1\u606f\u5931\u8d25,\u9519\u8bef\u4fe1\u606f: {}", (Object)e.getMessage());
        }
        Map<String, InvoiceCustVO> custVOMap = invoiceCustVOS.stream().collect(Collectors.toMap(InvoiceCustVO::getCustCode, t -> t, (t1, t2) -> t1));
        pagingDto.stream().forEach(item -> {
            List ddos = (List)map.get(item.getId());
            item.setCustId(((InvoiceAwaitDDO)ddos.get(0)).getCustId());
            item.setCustCode(((InvoiceAwaitDDO)ddos.get(0)).getCustCode());
            String custName = ((InvoiceAwaitDDO)ddos.get(0)).getCustName();
            if (ddos.size() > 1) {
                item.setCustName(custName + "\u7b49");
            } else {
                item.setCustName(custName);
            }
            item.setEditInvTitle(0);
            if (ruleMap.containsKey(item.getOptDocCls() + "_" + item.getOptDocType() + "_" + item.getOptDocStatus())) {
                Integer editInvTitle = ((InvoiceRuleConfigDTO)((Object)((Object)ruleMap.get(item.getOptDocCls() + "_" + item.getOptDocType() + "_" + item.getOptDocStatus())))).getEditInvTitle();
                item.setEditInvTitle(editInvTitle == null ? 0 : editInvTitle);
            }
            if (custVOMap.containsKey(item.getMainCustCode())) {
                item.setEs3(StrUtil.equals((CharSequence)((InvoiceCustVO)custVOMap.get(item.getMainCustCode())).getEs3(), (CharSequence)"1") ? "1" : "0");
            }
            if (StrUtil.equals((CharSequence)item.getEs3(), (CharSequence)"1") && ObjectUtil.equals((Object)item.getEditInvTitle(), (Object)1)) {
                item.setEditInvTitle(1);
            } else {
                item.setEditInvTitle(0);
            }
        });
        return InvoiceAwaitConvert.INSTANCE.pagingDto2Vo(pagingDto);
    }

    @Override
    @SysCodeProc
    public List<InvoiceAwaitDVO> queryInvoiceAwaitDetail(Long masId) {
        List<InvoiceAwaitDDO> list = this.invoiceAwaitDRepo.findAllByMasId(masId);
        return InvoiceAwaitDConvert.INSTANCE.dos2Vos(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Object invoiceApply(InvoiceApplyParam param) {
        List<InvoiceAwaitRespVO> records = this.checkAndQueryInvoiceAwait(param);
        List<InvoiceRuleConfigDTO> configDTOList = this.getInvoiceRuleConfigDTOS(records);
        Map<String, List<InvoiceAwaitRespVO>> optDocClsMap = this.groupByDocCls(records, configDTOList);
        ArrayList saveParams = new ArrayList();
        optDocClsMap.forEach((key, invoiceAwaitRespVOList) -> {
            InvoiceApplySaveParam saveParam = this.getInvoiceApplySaveParam((List<InvoiceAwaitRespVO>)invoiceAwaitRespVOList);
            saveParams.add(saveParam);
        });
        ArrayList applyDtoList = new ArrayList();
        saveParams.stream().forEach(saveParam -> {
            saveParam.setInvType(param.getInvType());
            saveParam.setRemark(param.getRemark());
            saveParam.setInvCustCode(param.getInvCustCode());
            saveParam.setInvCustName(param.getInvCustName());
            saveParam.setInvCustId(param.getInvCustId());
            InvoiceApplyDTO apply = this.saveAndSubmitInvoice((InvoiceApplySaveParam)saveParam);
            Assert.notBlank((CharSequence)apply.getApplyNo(), (String)"\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]);
            saveParam.setApplyNo(apply.getApplyNo());
            applyDtoList.add(apply);
            this.invoiceAwaitRepoProc.updateApplyNoByIds(apply.getInvoiceAwaitIds(), apply.getApplyNo(), saveParam.getInvoiceAwaitStatus());
        });
        List<InvoiceAwaitRespVO> sacckList = records.stream().filter(record -> StrUtil.equals((CharSequence)record.getOptDocCls(), (CharSequence)UdcEnum.DOC_CLS_SACCK.getValueCode())).collect(Collectors.toList());
        this.updateInvingState(sacckList);
        return applyDtoList;
    }

    private void updateInvingState(List<InvoiceAwaitRespVO> records) {
        if (CollectionUtil.isEmpty(records)) {
            return;
        }
        ArrayList<SalReconciliatInvDTO> salInvDtoList = new ArrayList<SalReconciliatInvDTO>();
        Set optDocIds = records.stream().map(InvoiceAwaitRespVO::getOptDocId).filter(Objects::nonNull).collect(Collectors.toSet());
        Optional<String> optional = records.stream().map(InvoiceAwaitRespVO::getInvoiceApplyNo).filter(Objects::nonNull).findFirst();
        String applyNo = optional.get();
        optDocIds.stream().forEach(optDocId -> {
            SalReconciliatInvDTO invDTO = new SalReconciliatInvDTO();
            invDTO.setInvState(UdcEnum.INV_STATE_ING.getValueCode());
            invDTO.setId(optDocId);
            invDTO.setInvApplyNo(applyNo);
            salInvDtoList.add(invDTO);
        });
        try {
            Long result = this.rmiOrderRpcService.updateInvingState(salInvDtoList);
            log.info("\u56de\u5199\u5bf9\u8d26\u5355\u53d1\u7968\u4fe1\u606f: \u53c2\u6570: {},  \u8fd4\u56de\u503c: {}", salInvDtoList, (Object)result);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5bf9\u8d26\u5355\u53d1\u7968\u72b6\u6001\u5931\u8d25: \u53c2\u6570: {} \u5931\u8d25\u539f\u56e0: {}", salInvDtoList, (Object)e.getMessage());
            throw new BusinessException("\u66f4\u65b0\u5bf9\u8d26\u5355\u53d1\u7968\u72b6\u6001\u5931\u8d25\uff0c" + e.getMessage());
        }
    }

    @NotNull
    private Map<String, List<InvoiceAwaitRespVO>> groupByDocCls(List<InvoiceAwaitRespVO> records, List<InvoiceRuleConfigDTO> configDTOList) {
        Map<String, List<InvoiceAwaitRespVO>> optDocClsMap = records.stream().collect(Collectors.groupingBy(record -> record.getOptDocCls() + record.getOptDocType() + record.getOptDocStatus()));
        if (CollectionUtil.isEmpty(configDTOList)) {
            optDocClsMap.forEach((key, value) -> value.forEach(vo -> vo.setAutoReview(Boolean.FALSE)));
        } else {
            configDTOList.stream().forEach(config -> {
                String key = config.getOptDocCls() + config.getOptDocType() + config.getOptDocStatus();
                if (optDocClsMap.containsKey(key)) {
                    List voList = (List)optDocClsMap.get(key);
                    if (ObjectUtil.equals((Object)config.getAutoReview(), (Object)FinConstant.ZERO)) {
                        voList.stream().forEach(vo -> vo.setAutoReview(Boolean.FALSE));
                    } else {
                        voList.stream().forEach(vo -> vo.setAutoReview(Boolean.TRUE));
                    }
                }
            });
        }
        return optDocClsMap;
    }

    private List<InvoiceRuleConfigDTO> getInvoiceRuleConfigDTOS(Set<String> optDocClsSet) {
        ArrayList<InvoiceRuleConfigQueryParam> queryParamList = new ArrayList<InvoiceRuleConfigQueryParam>();
        optDocClsSet.stream().forEach(cls -> {
            InvoiceRuleConfigQueryParam configQueryParam = new InvoiceRuleConfigQueryParam();
            configQueryParam.setOptDocCls((String)cls);
            queryParamList.add(configQueryParam);
        });
        return this.ruleConfigDomainService.getRuleConfigList(queryParamList);
    }

    private List<InvoiceRuleConfigDTO> getInvoiceRuleConfigDTOS(List<InvoiceAwaitRespVO> records) {
        ArrayList<InvoiceRuleConfigQueryParam> queryParamList = new ArrayList<InvoiceRuleConfigQueryParam>();
        Map<String, InvoiceAwaitRespVO> collect = records.stream().collect(Collectors.toMap(record -> record.getOptDocCls() + record.getOptDocType() + record.getOptDocStatus(), t -> t, (t1, t2) -> t1));
        records.stream().forEach(record -> {
            if (collect.containsKey(record.getOptDocCls() + record.getOptDocType() + record.getOptDocStatus())) {
                InvoiceRuleConfigQueryParam configQueryParam = new InvoiceRuleConfigQueryParam();
                configQueryParam.setOptDocCls(record.getOptDocCls());
                configQueryParam.setOptDocType(record.getOptDocType());
                configQueryParam.setOptDocStatus(record.getOptDocStatus());
                queryParamList.add(configQueryParam);
            }
        });
        return this.ruleConfigDomainService.getRuleConfigList(queryParamList);
    }

    public List<InvoiceAwaitRespVO> checkAndQueryInvoiceAwait(InvoiceApplyParam param) {
        Assert.notNull((Object)param.getCustInvTitle(), (String)"\u5f00\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)param.getCustTaxNo(), (String)"\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty(param.getIds(), (String)"\u6ca1\u6709\u9009\u62e9\u5f85\u5f00\u53d1\u7968", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)param.getInvType(), (String)"\u6ca1\u6709\u9009\u62e9\u53d1\u7968\u7c7b\u578b", (Object[])new Object[0]);
        List<InvoiceAwaitRespVO> records = this.invoiceAwaitRepoProc.findByIds(param.getIds());
        Assert.notEmpty(records, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u5f85\u5f00\u7968\u4fe1\u606f", (Object[])new Object[0]);
        Set custCodeSet = records.stream().map(record -> record.getMainCustCode()).collect(Collectors.toSet());
        Assert.isTrue((custCodeSet.size() == 1 ? 1 : 0) != 0, (String)"\u6240\u9009\u5f85\u5f00\u53d1\u7968\u6240\u5c5e\u4e3b\u5ba2\u6237\u4fe1\u606f\u4e0d\u552f\u4e00", (Object[])new Object[0]);
        Set docType3 = records.stream().map(record -> record.getDocType3()).filter(Objects::nonNull).collect(Collectors.toSet());
        Assert.isTrue((docType3.size() <= 1 ? 1 : 0) != 0, (String)"\u6240\u9700\u5bf9\u8d26\u7c7b\u578b\u4e0d\u552f\u4e00\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (Object[])new Object[0]);
        if (StrUtil.equals((CharSequence)records.get(0).getDocType3(), (CharSequence)UdcEnum.ORDER_TYPE3_REDEMPTION.getValueCode())) {
            param.setInvType(UdcEnum.INV_TYPE_YYJ2303.getValueCode());
        }
        records.stream().forEach(await -> Assert.isTrue((boolean)StrUtil.equalsAny((CharSequence)await.getInvoiceAwaitStatus(), (CharSequence[])new CharSequence[]{UdcEnum.INVOICE_AWAIT_STATUS_WAIT.getValueCode(), UdcEnum.INVOICE_AWAIT_STATUS_RED_SUCCESS.getValueCode()}), (String)"\u53ea\u80fd\u9009\u62e9\u72b6\u6001\u4e3a\u5f85\u5f00\u7968\u6216\u8005\u7ea2\u51b2\u5b8c\u6210\u7684\u5355\u636e", (Object[])new Object[0]));
        return records;
    }

    public void setInvoice(InvoiceApplySaveParam saveParam, ApplySaveParam invoice) {
        saveParam.setCustTaxNo(invoice.getCustTaxNo());
        saveParam.setCustInvTitle(invoice.getCustInvTitle());
        saveParam.setCustAdd(invoice.getAddress());
        saveParam.setCustBank(invoice.getCustBank());
        saveParam.setCustBankAcc(invoice.getCustBankAcc());
        saveParam.setCustTel(invoice.getCustTel());
        saveParam.setInvType(invoice.getInvType());
    }

    private InvoiceApplySaveParam getInvoiceApplySaveParam(List<InvoiceAwaitRespVO> records) {
        InvoiceAwaitRespVO record = records.get(0);
        InvoiceApplySaveParam saveParam = new InvoiceApplySaveParam();
        saveParam.setInvoiceId(record.getMasId());
        saveParam.setSourceSysNo(record.getOptDocNo());
        saveParam.setOptDocId(record.getOptDocId());
        this.setSaleCompanyInfo(record, saveParam);
        this.setCustInfo(record, saveParam);
        saveParam.setExchangeRate(record.getCurrRate());
        saveParam.setInvUser(FinIamUtil.currentUserName());
        saveParam.setRecUser(FinIamUtil.currentUserName());
        saveParam.setRevUser(FinIamUtil.currentUserName());
        saveParam.setInvMerge("1");
        BigDecimal total = records.stream().map(item -> item.getInvAmt()).filter(item -> ObjectUtil.isNotNull((Object)item)).reduce(BigDecimal.ZERO, BigDecimal::add);
        saveParam.setTotalAmt(total);
        saveParam.setInvType(record.getInvoiceType());
        saveParam.setCreateMode(record.getOptDocCls());
        saveParam.setPkGroup(record.getPkGroup());
        saveParam.setSettlementType(record.getSettlementType());
        saveParam.setOpenInvType(record.getOpenInvType());
        String applyNo = this.systemRpcService.sysNumberRuleGenerateCode("yst-fin", "XXFP", new ArrayList<String>());
        saveParam.setApplyNo(applyNo);
        record.setInvoiceApplyNo(applyNo);
        saveParam.setDocType3(record.getDocType3());
        List<InvoiceDetailSaveParam> details = this.getInvoiceDetails(records);
        saveParam.setDetails(details);
        return saveParam;
    }

    @NotNull
    private List<InvoiceDetailSaveParam> getInvoiceDetails(List<InvoiceAwaitRespVO> records) {
        ArrayList<InvoiceDetailSaveParam> details = new ArrayList<InvoiceDetailSaveParam>();
        for (int i = 0; i < records.size(); ++i) {
            InvoiceAwaitRespVO row = records.get(i);
            InvoiceDetailSaveParam detail = InvoiceAwaitDConvert.INSTANCE.awaitVo2InvoiceParam(row);
            detail.setInvoiceAwaitId(row.getMasId());
            detail.setLineNo(Integer.valueOf(i + 1));
            detail.setSourceId(row.getRelateDocDid());
            detail.setSourceNo(row.getRelateDocNo());
            detail.setSourceLine(row.getLineNo());
            detail.setSourceLineId(row.getId());
            detail.setInvNature("\u9ed8\u8ba4\u901a\u7528\u5355");
            detail.setItemCode(row.getItemCode());
            detail.setItemName(row.getItemName());
            detail.setTaxCode(row.getTaxType());
            detail.setTaxName(row.getServiceName());
            detail.setItemType(row.getItemSpec());
            detail.setUom(row.getUom());
            detail.setUomName(row.getUomName());
            detail.setQty(row.getQty());
            detail.setPrice(row.getOriginAmt());
            detail.setTotalAmt(row.getAmt());
            detail.setTaxRate(row.getTaxRate());
            detail.setExclTaxAmt(row.getNetAmt());
            detail.setTaxAmt(row.getTax());
            detail.setSourceNo(row.getRelateDocNo());
            detail.setDocNo(row.getRelateDocNo());
            detail.setCustId(row.getDtlCustId());
            detail.setCustName(row.getDtlCustName());
            detail.setCustCode(row.getDtlCustCode());
            details.add(detail);
        }
        return details;
    }

    private void setCustInfo(InvoiceAwaitRespVO record, InvoiceApplySaveParam saveParam) {
        saveParam.setCustId(record.getCustId());
        saveParam.setCustCode(record.getCustCode());
        saveParam.setCustName(record.getCustName());
        ApplyInvoiceParam param = new ApplyInvoiceParam();
        param.setCustCode(record.getMainCustCode());
        List<InvoiceCustVO> custVOS = this.invQuery(List.of(param));
        if (CollectionUtil.isNotEmpty(custVOS)) {
            InvoiceCustVO invoiceCustVO = custVOS.get(0);
            saveParam.setCustInvTitle(invoiceCustVO.getInvTitle());
            saveParam.setCustTaxNo(invoiceCustVO.getTaxNo());
            saveParam.setCustAdd(invoiceCustVO.getInvAddress());
            saveParam.setCustTel(invoiceCustVO.getInvTel());
            saveParam.setCustBankAcc(invoiceCustVO.getInvBankAcc());
            saveParam.setCustBank(invoiceCustVO.getInvBankName());
            saveParam.setCustName(invoiceCustVO.getCustName());
        }
    }

    private void setSaleCompanyInfo(InvoiceAwaitRespVO record, InvoiceApplySaveParam saveParam) {
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuIds(List.of(record.getOuId()));
        orgOuRpcDtoParam.setOuCodes(List.of(record.getOuCode()));
        List<OrgOuRpcDTO> ouRpcDTOS = this.orgRpcService.findOuDtoByParam(orgOuRpcDtoParam);
        Assert.notEmpty(ouRpcDTOS, (String)"\u9500\u552e\u516c\u53f8\u4fe1\u606f\u4e3a\u7a7a,\u516c\u53f8\u7f16\u7801:{}", (Object[])new Object[]{record.getOuCode()});
        OrgOuRpcDTO ouRpcDTO = ouRpcDTOS.get(0);
        saveParam.setAutoReview(record.getAutoReview());
        saveParam.setOuId(record.getOuId());
        saveParam.setOuCode(record.getOuCode());
        saveParam.setOuName(record.getOuName());
        saveParam.setSourceSysNo(record.getOptDocNo());
        saveParam.setMainCustCode(record.getMainCustCode());
        saveParam.setMainCustId(record.getMainCustId());
        saveParam.setMainCustName(record.getMainCustName());
        saveParam.setSaleTaxNo(ouRpcDTO.getTaxerCode());
        saveParam.setSaleInvTitle(ouRpcDTO.getInvTitle());
        saveParam.setSaleAdd(ouRpcDTO.getInvAddress());
        saveParam.setSaleBank(ouRpcDTO.getInvBankName());
        saveParam.setSaleBankAcc(ouRpcDTO.getInvBankAcc());
        saveParam.setSaleTel(ouRpcDTO.getInvPicPhone());
        saveParam.setCurrCode(ouRpcDTO.getOuCurr());
        SysCurrencyRespDTO currByCode = this.systemRpcService.findCurrByCode(ouRpcDTO.getOuCurr());
        saveParam.setCurrName(currByCode.getCurrName());
        saveParam.setLocalCurrCode(ouRpcDTO.getOuCurr());
        saveParam.setLocalCurrName(currByCode.getCurrName());
    }

    public InvoiceApplyDTO saveAndSubmitInvoice(InvoiceApplySaveParam param) {
        SaleInv saleInv = InvoiceConvert.INSTANCE.toSaleInv(param);
        if (ObjUtil.notEqual((Object)param.getAutoReview(), (Object)Boolean.FALSE)) {
            saleInv.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        } else {
            saleInv.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        }
        param.setInvoiceAwaitStatus(UdcEnum.INVOICE_AWAIT_STATUS_ING.getValueCode());
        saleInv.check();
        saleInv.checkDtl();
        log.info("[YST-FIN] saleInv: {}", (Object)saleInv);
        this.transactionTemplate.setPropagationBehavior(3);
        SaleInvDO execute = (SaleInvDO)this.transactionTemplate.execute(transactionStatus -> {
            try {
                SaleInvDO convertDO = SaleInvConvert.INSTANCE.convert(saleInv);
                log.info("[YST-FIN] convertDO: {}", (Object)convertDO);
                SaleInvDO save = (SaleInvDO)this.saleInvRepo.save(convertDO);
                this.saleInvDtlRepoProc.delByMasId(List.of(save.getId()));
                List<SaleInvDtl> saleInvDtls = saleInv.getSaleInvDtls();
                List<SaleInvDtlDO> details = SaleInvConvert.INSTANCE.convertListDO(saleInvDtls);
                log.info("[YST-FIN] convert details: {}", details);
                details.forEach(row -> {
                    row.setMasId(save.getId());
                    this.saleInvDtlRepo.save(row);
                });
                return save;
            }
            catch (Exception e) {
                log.error("\u5f85\u5f00\u53d1\u7968\u751f\u6210\u9500\u552e\u53d1\u7968\u51fa\u9519:{}", (Throwable)e);
                transactionStatus.setRollbackOnly();
                throw new BusinessException(ApiCode.FAIL, "\u5f85\u5f00\u53d1\u7968\u751f\u6210\u9500\u552e\u53d1\u7968\u4fdd\u5b58\u65f6\u51fa\u9519");
            }
        });
        Set<Long> awaitId = param.getDetails().stream().map(item -> item.getInvoiceAwaitId()).filter(Objects::nonNull).collect(Collectors.toSet());
        if (ObjUtil.equals((Object)param.getAutoReview(), (Object)Boolean.FALSE)) {
            try {
                this.workFlow(execute);
            }
            catch (Exception e) {
                log.error("\u9500\u552e\u53d1\u7968\u53d1\u8d77\u5de5\u4f5c\u6d41\u5931\u8d25 \u5931\u8d25\u4fe1\u606f:", (Throwable)e);
                this.transactionTemplate.execute(transactionStatus -> {
                    log.info("\u5220\u9664\u5df2\u7ecf\u751f\u6210\u7684\u9500\u552e\u53d1\u7968");
                    this.saleInvRepo.deleteById(execute.getId());
                    this.saleInvDtlRepoProc.delByMasId(List.of(execute.getId()));
                    return 1;
                });
                throw new BusinessException((Throwable)e);
            }
        } else {
            this.sendMessage(execute);
        }
        InvoiceApplyDTO result = new InvoiceApplyDTO();
        result.setApplyId(execute.getId());
        result.setApplyNo(execute.getApplyNo());
        result.setInvoiceAwaitIds(awaitId);
        return result;
    }

    private void sendMessage(SaleInvDO saleInvDO) {
        DemoMqMessageDTO messageDTO = new DemoMqMessageDTO();
        messageDTO.setId(saleInvDO.getId());
        messageDTO.setCode(saleInvDO.getApplyNo());
        messageDTO.setInterfaceType("zt_to_nc_salinv");
        messageDTO.setDomainCode("yst-fin");
        try {
            this.messageQueueTemplate.publishMessage("yst-fin", "yst-fin", (Serializable)messageDTO);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001mq\u6d88\u606f\uff0c\u540c\u6b65\u9500\u552e\u5f00\u7968\u4fe1\u606f\u5230NC\u5931\u8d25,\u540c\u6b65\u5185\u5bb9{}, \u5931\u8d25\u539f\u56e0\uff1a{}", (Object)messageDTO, (Object)e.getMessage());
            throw new BusinessException("\u540c\u6b65\u9500\u552e\u5f00\u7968\u4fe1\u606f\u5230NC\u5931\u8d25");
        }
    }

    private void workFlow(SaleInvDO saleInvDO) {
        String applyNo = saleInvDO.getApplyNo();
        if (saleInvDO.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(saleInvDO.getProcInstStatus())) {
            String procInstName = "\u5f00\u7968\u7533\u8bf7(" + applyNo + ")\u5ba1\u6279";
            String businessKey = "" + saleInvDO.getId();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(WorkFlowDefKey.FIN_SALE_INV.name(), procInstName, businessKey, new HashMap<String, Object>());
            this.saleInvDomainService.updateWorkInfo(processInfo, saleInvDO.getId());
            log.info("\u5f85\u5f00\u53d1\u7968\u7533\u8bf7\u8d70\u5de5\u4f5c\u6d41,\u7533\u8bf7\u9500\u552e\u53d1\u7968\u5355\u53f7 {}, \u5de5\u4f5c\u6d41\u8fd4\u56de {}", (Object)applyNo, (Object)processInfo);
        }
    }

    @Override
    public List<InvoiceCustVO> invQuery(List<ApplyInvoiceParam> applyInvoiceParam) {
        Assert.notEmpty(applyInvoiceParam, (String)"\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a!", (Object[])new Object[0]);
        List<String> collect = applyInvoiceParam.stream().map(param -> param.getCustCode()).collect(Collectors.toList());
        List<LmSaveCustRespVO> invCust = this.rmiSaleRpcService.findInvCust(collect);
        return InvoiceAwaitConvert.INSTANCE.custVos2Dtos(invCust);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<InvoiceAwaitDTO> invoiceAwaitOrder(String param) {
        List<SaleReconciliatDTO> saleReconciliatDTOS;
        SalReconciliatQueryDTO dto = this.buildSaleRecParam(param);
        try {
            log.info("\u767b\u5f55\u4eba\u4fe1\u606f\uff1a{}", (Object)SecurityContextUtil.currentUser());
            saleReconciliatDTOS = this.rmiOrderRpcService.querySalReconciliat(dto);
            log.info("\u67e5\u8be2\u5bf9\u8d26\u5355\u53c2\u6570\uff1a{} \n \u5bf9\u8d26\u5355\u67e5\u8be2\u5230\u7684\u6570\u636e {} ", (Object)dto, saleReconciliatDTOS);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5bf9\u8d26\u5355\u63a5\u53e3\u51fa\u9519,\u8bf7\u6c42\u53c2\u6570:{}, \u62a5\u9519\u4fe1\u606f\uff1a{}  ", (Object)dto, (Object)e.getMessage());
            return null;
        }
        if (CollectionUtil.isEmpty(saleReconciliatDTOS)) {
            return null;
        }
        List<SaleReconciliatDTO> collect = saleReconciliatDTOS.stream().filter(item -> CollectionUtil.isNotEmpty((Collection)item.getSaleReconciliatDtlDTOList())).collect(Collectors.toList());
        List<InvoiceAwaitDTO> dtos = this.buildSalRecToInvoiceAwaitOrder(collect);
        ArrayList<Long> list = new ArrayList<Long>();
        dtos.stream().forEach(item -> {
            String docNo = this.sysNumberGenerator.generate(SysNumEnum.FIN_DKFP_NO.getCode());
            InvoiceAwaitDO awaitDO = InvoiceConvert.INSTANCE.dto2Do((InvoiceAwaitDTO)item);
            awaitDO.setDocNo(docNo);
            InvoiceAwaitDO save = (InvoiceAwaitDO)this.invoiceAwaitRepo.save(awaitDO);
            List<InvoiceAwaitDDTO> dtlList = item.getInvoiceAwaitDDTOList();
            dtlList.stream().forEach(dtl -> {
                InvoiceAwaitDDO dtlDo = InvoiceAwaitDConvert.INSTANCE.dto2Do((InvoiceAwaitDDTO)dtl);
                dtlDo.setMasId(save.getId());
                this.invoiceAwaitDRepo.save(dtlDo);
                list.add(dtl.getOptDocDtlId());
            });
        });
        this.updateTransState(list);
        return dtos;
    }

    private void updateTransState(List<Long> list) {
        List collect = list.stream().filter(item -> ObjectUtil.isNotNull((Object)item)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            SalReconciliatQueryDTO updateDto = new SalReconciliatQueryDTO();
            updateDto.setDtlIds(list);
            try {
                this.rmiOrderRpcService.updateTransState(updateDto);
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u5bf9\u8d26\u5355\u660e\u7ec6\u4f20\u8f93\u72b6\u6001\u5931\u8d25\uff0c\u53c2\u6570: {}\uff0c\u5931\u8d25\u4fe1\u606f: {}\uff0c", (Object)updateDto, (Object)e.getMessage());
            }
        }
    }

    private List<InvoiceAwaitDTO> buildSalRecToInvoiceAwaitOrder(List<SaleReconciliatDTO> saleReconciliatDTOS) {
        ArrayList<InvoiceAwaitDTO> invoiceAwaitDTOS = new ArrayList<InvoiceAwaitDTO>();
        saleReconciliatDTOS.stream().forEach(saleRec -> {
            if (!this.invoiceAwaitRepo.existsByOptDocId(saleRec.getId())) {
                InvoiceAwaitDTO invoiceAwaitDTO = InvoiceAwaitConvert.INSTANCE.sale2AwaitDto((SaleReconciliatDTO)saleRec);
                List<InvoiceAwaitDDTO> dtlList = this.buildSalRecDtl2InvoiceAwaitDtl(saleRec.getSaleReconciliatDtlDTOList());
                invoiceAwaitDTO.setInvoiceAwaitDDTOList(dtlList);
                BigDecimal totalInvAmt = dtlList.stream().filter(item -> ObjectUtil.isNotNull((Object)item.getInvAmt())).map(item -> item.getInvAmt()).reduce(BigDecimal.ZERO, BigDecimal::add);
                invoiceAwaitDTO.setAmt(totalInvAmt);
                invoiceAwaitDTO.setId(null);
                invoiceAwaitDTO.setOptDocId(saleRec.getId());
                invoiceAwaitDTO.setOptDocNo(saleRec.getDocNo());
                invoiceAwaitDTO.setOptDocCls(UdcEnum.DOC_CLS_SACCK.getValueCode());
                if (StrUtil.equals((CharSequence)saleRec.getDocType3(), (CharSequence)UdcEnum.ORDER_TYPE3_NORMAL.getValueCode())) {
                    invoiceAwaitDTO.setOptDocType(UdcEnum.DOC_TYPE_SACCK.getValueCode());
                } else if (StrUtil.equals((CharSequence)UdcEnum.ORDER_TYPE3_CARD.getValueCode(), (CharSequence)saleRec.getDocType3())) {
                    invoiceAwaitDTO.setOptDocType(UdcEnum.DOC_TYPE_CARD.getValueCode());
                } else if (StrUtil.equals((CharSequence)UdcEnum.ORDER_TYPE3_REDEMPTION.getValueCode(), (CharSequence)saleRec.getDocType3())) {
                    invoiceAwaitDTO.setOptDocType(UdcEnum.DOC_TYPE_REDEMPTION.getValueCode());
                }
                invoiceAwaitDTO.setOptDocStatus(UdcEnum.DOC_STATUS_SACCK_CONFIRM.getValueCode());
                invoiceAwaitDTO.setInvoiceAwaitStatus(UdcEnum.INVOICE_AWAIT_STATUS_WAIT.getValueCode());
                invoiceAwaitDTO.setCustCode(dtlList.get(0).getCustCode());
                invoiceAwaitDTO.setCustId(dtlList.get(0).getCustId());
                invoiceAwaitDTO.setCustName(dtlList.get(0).getCustName());
                invoiceAwaitDTOS.add(invoiceAwaitDTO);
            }
        });
        return invoiceAwaitDTOS;
    }

    private List<InvoiceAwaitDDTO> buildSalRecDtl2InvoiceAwaitDtl(List<SaleReconciliatDtlDTO> saleRecList) {
        ArrayList<InvoiceAwaitDDTO> ddtos = new ArrayList<InvoiceAwaitDDTO>();
        saleRecList.stream().forEach(dtl -> {
            InvoiceAwaitDDTO invoiceAwaitDDTO = InvoiceAwaitDConvert.INSTANCE.sale2awaitDo((SaleReconciliatDtlDTO)dtl);
            invoiceAwaitDDTO.setId(null);
            invoiceAwaitDDTO.setMasId(null);
            if (dtl.getLineNo() != null) {
                invoiceAwaitDDTO.setLineNo(new BigDecimal(dtl.getLineNo()));
            }
            invoiceAwaitDDTO.setTaxType(dtl.getTaxCategoryCode());
            invoiceAwaitDDTO.setQty(dtl.getSoaQty());
            invoiceAwaitDDTO.setDiscountAmt(dtl.getInvDiscountAmt());
            invoiceAwaitDDTO.setNetAmt(dtl.getSoaNetAmt());
            invoiceAwaitDDTO.setTax(dtl.getSoaTaxAmt());
            invoiceAwaitDDTO.setAmt(dtl.getSoaAmt());
            invoiceAwaitDDTO.setOriginAmt(dtl.getDiscountPrice());
            invoiceAwaitDDTO.setOptDocDtlId(dtl.getId());
            if (ObjectUtil.isNotNull((Object)dtl.getMainPrice()) && !ObjUtil.equals((Object)dtl.getMainPrice(), (Object)BigDecimal.ZERO)) {
                invoiceAwaitDDTO.setItemDiscount(NumberUtil.div((Number)dtl.getDiscountPrice(), (Number)dtl.getMainPrice()));
            }
            ddtos.add(invoiceAwaitDDTO);
        });
        return ddtos;
    }

    private SalReconciliatQueryDTO buildSaleRecParam(String param) {
        SalReconciliatQueryDTO dto = new SalReconciliatQueryDTO();
        dto.setInvState(UdcEnum.INV_STATE_WAIT.getValueCode());
        dto.setState("CONFIRM");
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateInvedState(SaleInvStatusParam param) {
        List<SaleInvDtlDTO> saleInvDtlDTOS;
        List<InvoiceAwaitDTO> awaitDTOList = this.invoiceAwaitRepoProc.findByApplyNo(param.getApplyNo());
        List optDcoIdList = awaitDTOList.stream().map(InvoiceAwaitDTO::getOptDocId).distinct().collect(Collectors.toList());
        this.invoiceAwaitRepoProc.updateInvState(param);
        ArrayList salDoDDTOList = new ArrayList();
        if (StrUtil.equals((CharSequence)param.getInvState(), (CharSequence)UdcEnum.INV_STATE_SUCCESS.getValueCode())) {
            saleInvDtlDTOS = this.saleInvDtlRepoProc.queryByApplyNo(param.getApplyNo());
            saleInvDtlDTOS.stream().forEach(item -> {
                SaleReconciliatDTO.SalDoDDTO salDoDDTO = new SaleReconciliatDTO.SalDoDDTO();
                salDoDDTO.setId(item.getSourceId());
                salDoDDTO.setInvedAmt(ObjectUtil.isNotNull((Object)item.getInvAmt()) ? item.getInvAmt().abs() : BigDecimal.ZERO);
                salDoDDTOList.add(salDoDDTO);
            });
        }
        if (StrUtil.equals((CharSequence)param.getInvState(), (CharSequence)UdcEnum.INV_STATE_RED_SUCCESS.getValueCode())) {
            saleInvDtlDTOS = this.saleInvDtlRepoProc.queryByApplyNo(param.getApplyNo());
            saleInvDtlDTOS.stream().forEach(item -> {
                SaleReconciliatDTO.SalDoDDTO salDoDDTO = new SaleReconciliatDTO.SalDoDDTO();
                salDoDDTO.setId(item.getSourceId());
                salDoDDTO.setInvedAmt(ObjectUtil.isNotNull((Object)item.getInvAmt()) ? item.getInvAmt().abs().negate() : BigDecimal.ZERO);
                salDoDDTOList.add(salDoDDTO);
            });
        }
        SaleReconciliatDTO dto = new SaleReconciliatDTO();
        dto.setIds(optDcoIdList);
        dto.setState(param.getInvState());
        dto.setSalDoDDTOList(salDoDDTOList);
        log.info("\u66f4\u65b0\u5bf9\u8d26\u5355\u5f00\u7968\u72b6\u6001,\u4f20\u53c2: {}", (Object)dto);
        this.rmiOrderRpcService.updateInvedState(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateRedState(SaleInvStatusParam param) {
        if (StrUtil.equals((CharSequence)param.getInvState(), (CharSequence)UdcEnum.RED_STATE_SUCCESS.getValueCode())) {
            param.setInvState(UdcEnum.INVOICE_AWAIT_STATUS_RED_SUCCESS.getValueCode());
        }
        this.updateInvedState(param);
    }

    public InvoiceAwaitServiceImpl(InvoiceAwaitRepoProc invoiceAwaitRepoProc, InvoiceAwaitDRepo invoiceAwaitDRepo, RmiSaleRpcService rmiSaleRpcService, RmiOrgOuRpcServiceService orgRpcService, WorkflowRpcService workflowRpcService, SaleInvRepo saleInvRepo, SaleInvDtlRepoProc saleInvDtlRepoProc, SaleInvDtlRepo saleInvDtlRepo, TransactionTemplate transactionTemplate, InvoiceRuleConfigDomainService ruleConfigDomainService, SystemRpcService systemRpcService, InvoiceApplyRepoProc invoiceApplyRepoProc, RmiOrderRpcService rmiOrderRpcService, InvoiceAwaitRepo invoiceAwaitRepo, SysNumberGenerator sysNumberGenerator, SaleInvDomainService saleInvDomainService, MessageQueueTemplate messageQueueTemplate, UdcProvider udcProvider) {
        this.invoiceAwaitRepoProc = invoiceAwaitRepoProc;
        this.invoiceAwaitDRepo = invoiceAwaitDRepo;
        this.rmiSaleRpcService = rmiSaleRpcService;
        this.orgRpcService = orgRpcService;
        this.workflowRpcService = workflowRpcService;
        this.saleInvRepo = saleInvRepo;
        this.saleInvDtlRepoProc = saleInvDtlRepoProc;
        this.saleInvDtlRepo = saleInvDtlRepo;
        this.transactionTemplate = transactionTemplate;
        this.ruleConfigDomainService = ruleConfigDomainService;
        this.systemRpcService = systemRpcService;
        this.invoiceApplyRepoProc = invoiceApplyRepoProc;
        this.rmiOrderRpcService = rmiOrderRpcService;
        this.invoiceAwaitRepo = invoiceAwaitRepo;
        this.sysNumberGenerator = sysNumberGenerator;
        this.saleInvDomainService = saleInvDomainService;
        this.messageQueueTemplate = messageQueueTemplate;
        this.udcProvider = udcProvider;
    }
}

