/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinEventTableConditionConvert;
import com.elitesland.fin.application.convert.accountingengine.FinEventTableConvert;
import com.elitesland.fin.application.convert.accountingengine.FinEventTableLineConvert;
import com.elitesland.fin.application.facade.param.accountingengine.FinEventTableConditionParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinEventTableLineParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinEventTableParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinEventTableLineVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinEventTableVO;
import com.elitesland.fin.application.service.accountingengine.FinEventTableService;
import com.elitesland.fin.domain.entity.accountingengine.FinEventTableDO;
import com.elitesland.fin.repo.accountingengine.FinEventTableConditionRepo;
import com.elitesland.fin.repo.accountingengine.FinEventTableLineRepo;
import com.elitesland.fin.repo.accountingengine.FinEventTableRepo;
import com.elitesland.fin.repo.accountingengine.FinEventTableRepoProc;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FinEventTableServiceImpl
implements FinEventTableService {
    private static final Logger log = LoggerFactory.getLogger(FinEventTableServiceImpl.class);
    private final FinEventTableRepo finEventTableRepo;
    private final FinEventTableRepoProc finEventTableRepoProc;
    private final FinEventTableConditionRepo finEventTableConditionRepo;
    private final FinEventTableLineRepo finEventTableLineRepo;

    @Override
    @SysCodeProc
    public PagingVO<FinEventTableVO> page(FinEventTableParam finEventTableParam) {
        return FinEventTableConvert.INSTANCE.DTOToVO(this.finEventTableRepoProc.page(finEventTableParam));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableOrDisable(FinEventTableParam finEventTableParam) {
        this.checkEnableOrDisableParam(finEventTableParam);
        List finEventTableDOList = this.finEventTableRepo.findAllById(finEventTableParam.getIds());
        finEventTableDOList.stream().forEach(item -> Assert.isFalse((boolean)finEventTableParam.getStatus().equals(item.getStatus()), (String)"\u6570\u636e\u5df2\u7ecf\u542f\u7528/\u7981\u7528", (Object[])new Object[0]));
        finEventTableDOList.stream().forEach(item -> item.setStatus(finEventTableParam.getStatus()));
    }

    @Override
    public List<FinEventTableLineVO> loadDataTemplate(FinEventTableParam finEventTableParam) {
        this.checkLoadDataTemplateParam(finEventTableParam);
        List<FinEventTableLineVO> finEventTableLineVOList = this.queryTableField(finEventTableParam, finEventTableParam.getMasTable());
        if (StringUtils.isNotEmpty((String)finEventTableParam.getTableName())) {
            finEventTableLineVOList.addAll(this.queryTableField(finEventTableParam, finEventTableParam.getTableName()));
        }
        return finEventTableLineVOList;
    }

    private List<FinEventTableLineVO> queryTableField(FinEventTableParam finEventTableParam, String tableName) {
        Connection connection = null;
        ResultSet columnResultSet = null;
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            connection = DriverManager.getConnection(String.format("jdbc:mysql://%s:%s/%s", finEventTableParam.getHost(), finEventTableParam.getPort(), finEventTableParam.getDatabaseName()), finEventTableParam.getUserName(), finEventTableParam.getPassword());
            DatabaseMetaData metaData = connection.getMetaData();
            columnResultSet = metaData.getColumns(finEventTableParam.getDatabaseName(), finEventTableParam.getDatabaseName(), tableName, null);
            ArrayList<FinEventTableLineVO> finEventTableLineVOList = new ArrayList<FinEventTableLineVO>();
            while (columnResultSet.next()) {
                FinEventTableLineVO finEventTableLineVO = new FinEventTableLineVO();
                finEventTableLineVO.setTableName(tableName);
                finEventTableLineVO.setColumnName(columnResultSet.getString("COLUMN_NAME"));
                finEventTableLineVO.setColumnType(columnResultSet.getString("TYPE_NAME"));
                finEventTableLineVO.setColumnComment(columnResultSet.getString("REMARKS"));
                finEventTableLineVOList.add(finEventTableLineVO);
            }
            ArrayList<FinEventTableLineVO> arrayList = finEventTableLineVOList;
            return arrayList;
        }
        catch (Exception e) {
            throw new BusinessException("\u67e5\u8be2\u8868\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (columnResultSet != null) {
                try {
                    columnResultSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void checkLoadDataTemplateParam(FinEventTableParam finEventTableParam) {
        Assert.notEmpty((CharSequence)finEventTableParam.getHost(), (String)"\u4e3b\u673a\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finEventTableParam.getPort(), (String)"\u7aef\u53e3\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finEventTableParam.getUserName(), (String)"\u7528\u6237\u540d\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finEventTableParam.getPassword(), (String)"\u5bc6\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finEventTableParam.getDatabaseName(), (String)"\u6570\u636e\u5e93\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finEventTableParam.getMasTable(), (String)"\u4e3b\u8868\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finEventTableParam.getMasTableColumn(), (String)"\u4e3b\u8868\u6761\u4ef6\u5b57\u6bb5\u5fc5\u586b", (Object[])new Object[0]);
    }

    private void checkEnableOrDisableParam(FinEventTableParam finEventTableParam) {
        Assert.notEmpty(finEventTableParam.getIds(), (String)"id\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finEventTableParam.getStatus(), (String)"\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdate(FinEventTableParam finEventTableParam) {
        finEventTableParam.setFinEventTableLineDetailList(Optional.ofNullable(finEventTableParam.getFinEventTableLineDetailList()).orElse(Collections.emptyList()));
        finEventTableParam.setFinEventTableConditionDetailList(Optional.ofNullable(finEventTableParam.getFinEventTableConditionDetailList()).orElse(Collections.emptyList()));
        this.checkSaveOrUpdateParam(finEventTableParam);
        this.checkIdempotent(finEventTableParam);
        FinEventTableDO finEventTableDO = (FinEventTableDO)this.finEventTableRepo.save(FinEventTableConvert.INSTANCE.paramToDO(finEventTableParam));
        List<FinEventTableLineParam> finEventTableLineDetailList = finEventTableParam.getFinEventTableLineDetailList();
        List<FinEventTableConditionParam> finEventTableConditionDetailList = finEventTableParam.getFinEventTableConditionDetailList();
        if (CollectionUtils.isNotEmpty(finEventTableLineDetailList)) {
            this.finEventTableLineRepo.deleteAllByMasId(finEventTableDO.getId());
            finEventTableLineDetailList.stream().forEach(item -> item.setMasId(finEventTableDO.getId()));
            this.finEventTableLineRepo.saveAll(FinEventTableLineConvert.INSTANCE.paramToDO(finEventTableLineDetailList));
        }
        if (CollectionUtils.isNotEmpty(finEventTableConditionDetailList)) {
            this.finEventTableConditionRepo.deleteAllByMasId(finEventTableDO.getId());
            finEventTableConditionDetailList.stream().forEach(item -> item.setMasId(finEventTableDO.getId()));
            this.finEventTableConditionRepo.saveAll(FinEventTableConditionConvert.INSTANCE.paramToDO(finEventTableConditionDetailList));
        }
        return finEventTableDO.getId();
    }

    private void checkSaveOrUpdateParam(FinEventTableParam finEventTableParam) {
        Assert.notEmpty((CharSequence)finEventTableParam.getEventTable(), (String)"\u4e8b\u4ef6\u8868\u5355\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finEventTableParam.getHost(), (String)"\u4e3b\u673a\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finEventTableParam.getPort(), (String)"\u7aef\u53e3\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finEventTableParam.getUserName(), (String)"\u7528\u6237\u540d\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finEventTableParam.getPassword(), (String)"\u5bc6\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finEventTableParam.getDatabaseName(), (String)"\u6570\u636e\u5e93\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finEventTableParam.getMasTable(), (String)"\u4e3b\u8868\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finEventTableParam.getMasTableColumn(), (String)"\u4e3b\u8868\u6761\u4ef6\u5b57\u6bb5\u5fc5\u586b", (Object[])new Object[0]);
        List<FinEventTableLineParam> finEventTableLineDetailList = finEventTableParam.getFinEventTableLineDetailList();
        List<FinEventTableConditionParam> finEventTableConditionDetailList = finEventTableParam.getFinEventTableConditionDetailList();
        Assert.isTrue((CollectionUtils.isNotEmpty(finEventTableLineDetailList) || CollectionUtils.isNotEmpty(finEventTableConditionDetailList) ? 1 : 0) != 0, (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        finEventTableLineDetailList.stream().forEach(item -> {
            Assert.notEmpty((CharSequence)item.getTableName(), (String)"\u8868\u5355\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getColumnName(), (String)"\u5b57\u6bb5\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getColumnType(), (String)"\u5b57\u6bb5\u7c7b\u578b\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getColumnComment(), (String)"\u5b57\u6bb5\u542b\u4e49\u5fc5\u586b", (Object[])new Object[0]);
        });
        finEventTableConditionDetailList.stream().forEach(item -> {
            Assert.notEmpty((CharSequence)item.getTableName(), (String)"\u8868\u5355\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getColumnName(), (String)"\u5b57\u6bb5\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getConditionType(), (String)"\u6761\u4ef6\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notNull((Object)item.getValueFrom(), (String)"\u4ece\u503c\u5185\u5bb9\u5fc5\u586b", (Object[])new Object[0]);
        });
    }

    private void checkIdempotent(FinEventTableParam finEventTableParam) {
        FinEventTableDO finEventTableDO = this.finEventTableRepoProc.findByEventTable(finEventTableParam.getEventTable());
        if (finEventTableDO != null) {
            Assert.equals((Object)finEventTableParam.getId(), (Object)finEventTableDO.getId(), (String)"\u4e8b\u4ef6\u8868\u5355\u540d\u79f0\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        }
    }

    public FinEventTableServiceImpl(FinEventTableRepo finEventTableRepo, FinEventTableRepoProc finEventTableRepoProc, FinEventTableConditionRepo finEventTableConditionRepo, FinEventTableLineRepo finEventTableLineRepo) {
        this.finEventTableRepo = finEventTableRepo;
        this.finEventTableRepoProc = finEventTableRepoProc;
        this.finEventTableConditionRepo = finEventTableConditionRepo;
        this.finEventTableLineRepo = finEventTableLineRepo;
    }
}

