/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.arverconfig;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.convert.arverconfig.ArVerConfigConvert;
import com.elitesland.fin.application.convert.arverconfig.ArVerConfigDtlConvert;
import com.elitesland.fin.application.convert.recorder.RecOrderConvert;
import com.elitesland.fin.application.facade.param.arverconfig.ArVerConfigDtlSaveParam;
import com.elitesland.fin.application.facade.param.arverconfig.ArVerConfigSaveParam;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderVO;
import com.elitesland.fin.application.facade.vo.arverconfig.ArVerConfigDtlVO;
import com.elitesland.fin.application.facade.vo.arverconfig.ArVerConfigVO;
import com.elitesland.fin.application.facade.vo.arverconfig.RecAndArOrderVO;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderVO;
import com.elitesland.fin.application.service.arverconfig.ArVerConfigService;
import com.elitesland.fin.domain.entity.arverconfig.ArVerConfig;
import com.elitesland.fin.domain.param.arorder.ArOrderParam;
import com.elitesland.fin.domain.param.arverconfig.ArVerConfigPageParam;
import com.elitesland.fin.domain.param.arverconfig.OrderParam;
import com.elitesland.fin.domain.param.recorder.RecOrderParam;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.arverconfig.ArVerConfigDomainService;
import com.elitesland.fin.domain.service.arverrec.ArVerRecDomainService;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.arverconfig.ArVerConfigDTO;
import com.elitesland.fin.infr.dto.arverconfig.ArVerConfigDtlDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ArVerConfigServiceImpl
implements ArVerConfigService {
    private final ArVerConfigDomainService arVerConfigDomainService;
    private final ArOrderDomainService arOrderDomainService;
    private final RecOrderDomainService recOrderDomainService;
    private final ArVerRecDomainService arVerRecDomainService;

    @Override
    @SysCodeProc
    public RecAndArOrderVO queryOrderByParam(OrderParam param) {
        if (param.getOuId() == null && StrUtil.isBlank((CharSequence)param.getOuCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u516c\u53f8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (param.getCustId() == null && StrUtil.isBlank((CharSequence)param.getCustCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5ba2\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (param.getBuDateStart() == null || param.getBuDateEnd() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        RecAndArOrderVO recAndArOrderVO = new RecAndArOrderVO();
        recAndArOrderVO.setRecOrderVOS(this.getRecOrderList(param));
        recAndArOrderVO.setArOrderVOS(this.getArOrderList(param));
        return recAndArOrderVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> save(ArVerConfigSaveParam param) {
        if (param.getId() != null) {
            Map<String, ArVerConfigDtlDTO> dtlMap = this.arVerConfigDomainService.queryByMasId(param.getId()).stream().collect(Collectors.toMap(ArVerConfigDtlDTO::getFieldNo, t -> t));
            Boolean aBoolean = this.arVerRecDomainService.queryByScId(param.getId());
            param.getArVerConfigDtlSaveParams().forEach(params -> {
                if (dtlMap.get(params.getFieldNo()) != null) {
                    ArVerConfigServiceImpl.checkMatchFlag(dtlMap, aBoolean, params);
                }
            });
        }
        ArVerConfig arVerConfig = ArVerConfigConvert.INSTANCE.paramConvert(param);
        String id = this.arVerConfigDomainService.save(arVerConfig);
        return ApiResult.ok((Object)id);
    }

    private static void checkMatchFlag(Map<String, ArVerConfigDtlDTO> dtlMap, Boolean aBoolean, ArVerConfigDtlSaveParam params) {
        if (!dtlMap.get(params.getFieldNo()).getMatchFlag().equals(params.getMatchFlag()) && aBoolean.booleanValue()) {
            throw new BusinessException("\u5df2\u88ab\u6838\u9500\u8bb0\u5f55\u5173\u8054,\u4e0d\u5141\u8bb8\u4fee\u6539\u5339\u914d\u5b57\u6bb5!");
        }
    }

    @Override
    public ApiResult<ArVerConfigVO> queryById(Long id) {
        ArVerConfigDTO arVerConfigDTO = this.arVerConfigDomainService.queryById(id);
        ArVerConfigVO arVerConfigVO = ArVerConfigConvert.INSTANCE.convertVo(arVerConfigDTO);
        Boolean aBoolean = this.arVerRecDomainService.queryByScId(id);
        arVerConfigVO.setFlag(aBoolean);
        return ApiResult.ok((Object)arVerConfigVO);
    }

    @Override
    public ApiResult<ArVerConfigVO> getDef() {
        ArVerConfigDTO arVerConfigDTO = this.arVerConfigDomainService.queryDef();
        ArVerConfigVO arVerConfigVO = ArVerConfigConvert.INSTANCE.convertVo(arVerConfigDTO);
        if (arVerConfigVO == null) {
            return ApiResult.ok((Object)new ArVerConfigVO());
        }
        return ApiResult.ok((Object)arVerConfigVO);
    }

    @Override
    public ApiResult<PagingVO<ArVerConfigVO>> page(ArVerConfigPageParam param) {
        PagingVO<ArVerConfigDTO> page = this.arVerConfigDomainService.page(param);
        PagingVO<ArVerConfigVO> arVerConfigVOPagingVO = ArVerConfigConvert.INSTANCE.convertPage(page);
        return ApiResult.ok(arVerConfigVOPagingVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> stop(List<Long> ids) {
        this.arVerConfigDomainService.updateEnable(ids);
        return ApiResult.ok(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateDef(Long id) {
        Long count = this.arVerConfigDomainService.updateDef(id);
        return ApiResult.ok((Object)count);
    }

    @Override
    public ApiResult<List<ArVerConfigDtlVO>> queryDtl() {
        List<ArVerConfigDtlDTO> arVerConfigDtlDTOS = this.arVerConfigDomainService.queryDtl();
        List<ArVerConfigDtlVO> arVerConfigDtlVOS = ArVerConfigDtlConvert.INSTANCE.convertVo(arVerConfigDtlDTOS);
        return ApiResult.ok(arVerConfigDtlVOS);
    }

    @Override
    public ApiResult<List<ArVerConfigVO>> queryAllConfig() {
        List<ArVerConfigDTO> arVerConfigDTOS = this.arVerConfigDomainService.queryAll();
        List<ArVerConfigVO> arVerConfigVOS = ArVerConfigConvert.INSTANCE.dtoToVo(arVerConfigDTOS);
        return ApiResult.ok(arVerConfigVOS);
    }

    private List<ArOrderVO> getArOrderList(OrderParam param) {
        ArOrderParam arOrderParam = new ArOrderParam();
        arOrderParam.setOuId(param.getOuId());
        arOrderParam.setCustId(param.getCustId());
        arOrderParam.setCurrCode(param.getCurrCode());
        arOrderParam.setBuDateStart(param.getBuDateStart());
        arOrderParam.setBuDateEnd(param.getBuDateEnd());
        arOrderParam.setOuCode(param.getOuCode());
        arOrderParam.setCustCode(param.getCustCode());
        List<ArOrderDTO> arOrderList = this.arOrderDomainService.getArOrderList(arOrderParam);
        List<ArOrderVO> arOrderVOS = ArOrderConvert.INSTANCE.convertList(arOrderList);
        List<ArOrderVO> res = arOrderVOS.stream().filter(x -> {
            x.setUnVerAmt(x.getTotalAmt().subtract(x.getVerAmt()));
            return x.getUnVerAmt().compareTo(BigDecimal.ZERO) != 0;
        }).collect(Collectors.toList());
        return res;
    }

    private List<RecOrderVO> getRecOrderList(OrderParam param) {
        RecOrderParam recOrderParam = new RecOrderParam();
        recOrderParam.setOuId(param.getOuId());
        recOrderParam.setCustId(param.getCustId());
        recOrderParam.setCurrCode(param.getCurrCode());
        recOrderParam.setBuDateStart(param.getBuDateStart());
        recOrderParam.setBuDateEnd(param.getBuDateEnd());
        recOrderParam.setOuCode(param.getOuCode());
        recOrderParam.setCustCode(param.getCustCode());
        List<RecOrderDTO> recOrderDTOS = this.recOrderDomainService.queryByParam(recOrderParam);
        List<RecOrderVO> recOrderVOS = RecOrderConvert.INSTANCE.convertList(recOrderDTOS);
        return recOrderVOS.stream().filter(vo -> {
            vo.setUnVerAmt(vo.getTotalAmt().subtract(vo.getVerAmt()));
            return vo.getUnVerAmt().compareTo(BigDecimal.ZERO) != 0;
        }).collect(Collectors.toList());
    }

    public ArVerConfigServiceImpl(ArVerConfigDomainService arVerConfigDomainService, ArOrderDomainService arOrderDomainService, RecOrderDomainService recOrderDomainService, ArVerRecDomainService arVerRecDomainService) {
        this.arVerConfigDomainService = arVerConfigDomainService;
        this.arOrderDomainService = arOrderDomainService;
        this.recOrderDomainService = recOrderDomainService;
        this.arVerRecDomainService = arVerRecDomainService;
    }
}

