/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.recorder;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.cloudt.apm.common.exception.BusinessException;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.recorder.RecOrderConvert;
import com.elitesland.fin.application.convert.recorder.RecOrderDtlConvert;
import com.elitesland.fin.application.convert.recorder.RecOrderRpcFiledConvert;
import com.elitesland.fin.application.service.recorder.RecOrderRpcDetailService;
import com.elitesland.fin.application.service.recorder.RecOrderRpcTwoService;
import com.elitesland.fin.application.service.unionpay.entity.enums.ProcDefKey;
import com.elitesland.fin.application.service.unionpay.entity.enums.ReceiptStatusEnum;
import com.elitesland.fin.application.service.unionpay.entity.req.SendPayReq;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.recorder.QRecOrderDO;
import com.elitesland.fin.domain.entity.recorder.RecOrder;
import com.elitesland.fin.domain.entity.recorder.RecOrderDO;
import com.elitesland.fin.domain.entity.recorder.RecOrderDtlDO;
import com.elitesland.fin.domain.entity.recorder.RecOrderRpcFiledDO;
import com.elitesland.fin.domain.param.recorder.RecOrderDetailSaveParam;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcExcelVO;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcPageRespVo;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcSaveParam;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcTimsParam;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcTwoParam;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcUpdateParam;
import com.elitesland.fin.infr.repo.recorder.RecOrderDtlRepo;
import com.elitesland.fin.infr.repo.recorder.RecOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepo;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRpcFiledRepo;
import com.elitesland.fin.infr.repo.recorder.RecOrderRpcFiledRepoProc;
import com.elitesland.fin.param.recorder.RecOrderRpcParam;
import com.elitesland.fin.repo.account.AccountStorageRepoProc;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.fin.service.recorder.RecOrderRpcService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecOrderRpcTwoServiceImpl
implements RecOrderRpcTwoService {
    private static final Logger log = LoggerFactory.getLogger(RecOrderRpcTwoServiceImpl.class);
    private final RecOrderRpcService recOrderRpcServiceImpl;
    @Autowired
    private RecOrderRpcFiledRepo recOrderRpcFiledRepo;
    @Autowired
    private RecOrderRpcFiledRepoProc recOrderRpcFiledRepoProc;
    @Autowired
    private AccountStorageRepoProc accountStorageRepoProc;
    @Autowired
    private RecOrderRepoProc recOrderRepoProc;
    @Autowired
    private RecOrderRepo recOrderRepo;
    @Autowired
    private RecOrderDtlRepo recOrderDtlRepo;
    @Autowired
    private RecOrderDtlRepoProc recOrderDtlRepoProc;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    private final RecOrderRpcDetailService recOrderRpcDetailService;
    private final WorkflowService workflowService;
    private final SeqNumProvider sysNumberRuleService;
    private final TaskExecutor taskExecutor;
    private final UdcProvider udcProvider;
    private final WorkflowRpcService workflowRpcService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(RecOrderRpcSaveParam recOrderRpcSaveParam) {
        RecOrderRpcParam recOrder = new RecOrderRpcParam();
        BeanUtils.copyProperties((Object)recOrderRpcSaveParam, (Object)recOrder);
        Long id = this.recOrderRpcServiceImpl.save(recOrder);
        if (null != recOrderRpcSaveParam.getRecOrderRpcTimsParam() && id != null & id != 0L) {
            RecOrderRpcFiledDO recOrderRpcFiledDO = (RecOrderRpcFiledDO)this.recOrderRpcFiledRepo.save(RecOrderRpcFiledConvert.INSTANCE.convertParam(recOrderRpcSaveParam.getRecOrderRpcTimsParam()));
        }
        return id;
    }

    @Override
    @SysCodeProc
    public PagingVO<RecOrderRpcPageRespVo> queryRecOrderRpcPageList(RecOrderRpcTwoParam recOrderRpcTwoParam) {
        long count = this.recOrderRpcFiledRepoProc.countRecOrderRpc(recOrderRpcTwoParam);
        if (count > 0L) {
            List<RecOrderRpcPageRespVo> queryList = this.recOrderRpcFiledRepoProc.queryRecOrderPrc(recOrderRpcTwoParam);
            return new PagingVO(count, queryList);
        }
        return new PagingVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> update(RecOrderRpcUpdateParam recOrderRpcUpdateParam) {
        Long result;
        if (recOrderRpcUpdateParam != null) {
            throw new BusinessException("\u66f4\u65b0\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        RecOrder recOrder = new RecOrder();
        BeanUtils.copyProperties((Object)recOrderRpcUpdateParam, (Object)recOrder);
        RecOrderDO rec = this.updateOrSave(recOrder);
        recOrderRpcUpdateParam.getRecOrderRpcTimsParam().setMasId(rec.getId());
        if (recOrderRpcUpdateParam.getRecOrderRpcTimsParam() != null && recOrderRpcUpdateParam.getRecOrderRpcTimsParam().getId() != null && (result = this.recOrderRpcFiledRepoProc.masIdUpdateFiled(RecOrderRpcFiledConvert.INSTANCE.convertParam(recOrderRpcUpdateParam.getRecOrderRpcTimsParam()))) != null && result != 0L) {
            return ApiResult.ok();
        }
        return new ApiResult().errorMsg("\u6536\u6b3e\u5355\u4fe1\u606f\u4fee\u6539\u5931\u8d25");
    }

    @Override
    @SysCodeProc
    public Optional<RecOrderRpcPageRespVo> queryRecOrderDetail(Long id) {
        RecOrderRpcPageRespVo recOrderRpcPageRespVos = this.recOrderRpcFiledRepoProc.queryRecOrderPrcDetail(id);
        String file = recOrderRpcPageRespVos.getApplyFile();
        if (StringUtils.isNotEmpty((CharSequence)file)) {
            String[] fileList = file.split(",");
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < fileList.length; ++i) {
                if (fileList[i].isEmpty()) continue;
                list.add(fileList[i]);
            }
            recOrderRpcPageRespVos.setApplyFileList(list);
        }
        if (recOrderRpcPageRespVos != null) {
            List<RecOrderDetailSaveParam> detailSaveParamList = this.recOrderRpcDetailService.getDetail(id);
            recOrderRpcPageRespVos.setDtlList(detailSaveParamList);
            return Optional.of(recOrderRpcPageRespVos);
        }
        return Optional.empty();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult enableRecOrderState(Long id, String state) {
        this.jpaQueryFactory.update((EntityPath)QRecOrderDO.recOrderDO).set((Path)QRecOrderDO.recOrderDO.orderState, (Object)state).where(new Predicate[]{QRecOrderDO.recOrderDO.id.eq((Object)id)});
        return ApiResult.ok();
    }

    @Override
    public Long saveRecOrder(RecOrderRpcSaveParam recOrderRpcSaveParam) {
        RecOrderRpcParam recOrder = new RecOrderRpcParam();
        BeanUtils.copyProperties((Object)recOrderRpcSaveParam, (Object)recOrder);
        Long id = this.saveAssignStatus(recOrder, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        RecOrderRpcTimsParam recOrderRpcTimsParam = recOrderRpcSaveParam.getRecOrderRpcTimsParam();
        if (null != recOrderRpcTimsParam && id != null && id != 0L) {
            recOrderRpcTimsParam.setMasId(id);
            RecOrderRpcFiledDO recOrderRpcFiledDO = (RecOrderRpcFiledDO)this.recOrderRpcFiledRepo.save(RecOrderRpcFiledConvert.INSTANCE.convertParam(recOrderRpcTimsParam));
        }
        return id;
    }

    @Override
    @SysCodeProc
    public void exportExcel(RecOrderRpcTwoParam param, HttpServletResponse response) {
        CompletableFuture<List> recThread = CompletableFuture.supplyAsync(() -> {
            List<RecOrderRpcExcelVO> result = this.recOrderRpcFiledRepoProc.queryRecOrderExport(param);
            return result;
        }, (Executor)this.taskExecutor);
        List recList = recThread.join();
        Map recTypeUdcMap = this.udcProvider.getValueMapByUdcCode("yst-fin", "REC_TYPE");
        Map recStatusUdcMap = this.udcProvider.getValueMapByUdcCode("yst-fin", "RECORDER_STATE");
        Map payMethodUdcMap = this.udcProvider.getValueMapByUdcCode("yst-fin", "PAY_METHOD");
        Map docClsUdcMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "DOC_CLS");
        log.info("recList:{}", (Object)recList);
        recList.forEach(rec -> {
            rec.setRecTypeName((String)recTypeUdcMap.get(rec.getRecType()));
            rec.setOrderStateName((String)recStatusUdcMap.get(rec.getOrderState()));
            rec.setPayMethodName((String)payMethodUdcMap.get(rec.getPayMethod()));
            rec.setCreateModeName((String)docClsUdcMap.get(rec.getCreateMode()));
        });
        WriteSheet empSheet = ((ExcelWriterSheetBuilder)EasyExcelFactory.writerSheet((Integer)0, (String)"\u6536\u6b3e\u5355\u5bfc\u51fa").head(RecOrderRpcExcelVO.class)).build();
        ServletOutputStream outputStream = null;
        ExcelWriter excelWriter = null;
        IOException exception = null;
        try {
            response.setHeader("Content-disposition", "attachment;filename=\u5e94\u6536\u5355\u5bfc\u51fa.xlsx");
            response.setContentType("multipart/form-data");
            response.setCharacterEncoding("utf-8");
            outputStream = response.getOutputStream();
            excelWriter = EasyExcelFactory.write((OutputStream)outputStream).build();
            log.info("\u53cd\u5c04\u5f00\u59cb**********************************************");
            log.info("recList:{},empSheet:{}", (Object)recList, (Object)empSheet);
            excelWriter.write(recList, empSheet);
            log.info("\u53cd\u5c04\u7ed3\u675f**********************************************");
            outputStream.flush();
            excelWriter.finish();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BusinessException("\u4e0b\u8f7dexcel\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    exception = e;
                }
            }
        }
        if (null != exception) {
            throw new BusinessException("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25", (Throwable)exception);
        }
    }

    @Override
    @Transactional
    public void submit(Long id) {
        RecOrderRpcPageRespVo recOrderRpcPageRespVo = this.checkAndGetRecOrder(id);
        if (this.workflowRpcService.checkIsEnableWorkFlow(ProcDefKey.SVO_OFFLINEPAY.name()).booleanValue()) {
            WorkflowResult workflowResult = this.workflowService.startProcess(StartProcessPayload.of((String)ProcDefKey.SVO_OFFLINEPAY.name(), (String)("\u50a8\u503c\u5355\u7ebf\u4e0b\u652f\u4ed8(" + recOrderRpcPageRespVo.getSourceNo() + ")\u5ba1\u6279"), (String)(recOrderRpcPageRespVo.getSourceNo() + "#" + id), null));
            Assert.notNull((Object)workflowResult, (String)"\u542f\u52a8\u6d41\u7a0b\u5931\u8d25", (Object[])new Object[0]);
            Assert.isTrue((boolean)workflowResult.isSuccess(), (String)workflowResult.getMsg(), (Object[])new Object[0]);
            ProcessInfo processInfo = (ProcessInfo)workflowResult.getData();
            SendPayReq recOrder = new SendPayReq();
            if (ObjectUtil.notEqual((Object)processInfo.getProcInstStatus(), (Object)ProcInstStatus.APPROVED)) {
                recOrder.setReceiptStatus(ReceiptStatusEnum.SVO_APPROVING.getCode());
                recOrder.setReceiptStatus(UdcEnum.APPLY_STATUS_DOING.getValueCode());
                recOrder.setWorkflowProcInstStatus(processInfo.getProcInstStatus());
                SendPayReq storage = new SendPayReq();
                storage.setPayOrderId(recOrderRpcPageRespVo.getSourceNo());
                storage.setReceiptStatus(ReceiptStatusEnum.SVO_APPROVING.getCode());
                this.accountStorageRepoProc.updateAccountStorage(storage);
            }
            recOrder.setWorkflowProcInstId(processInfo.getProcInstId());
            recOrder.setWorkflowSubmitTime(LocalDateTime.now());
            recOrder.setId(id);
            this.recOrderRpcFiledRepoProc.updateRecOrder(recOrder);
        }
    }

    private RecOrderRpcPageRespVo checkAndGetRecOrder(Long id) {
        RecOrderRpcTwoParam recOrderRpcTwoParam = new RecOrderRpcTwoParam();
        recOrderRpcTwoParam.setId(id);
        List<RecOrderRpcPageRespVo> recOrderRpcPageRespVoList = this.recOrderRpcFiledRepoProc.queryRecOrderPrc(recOrderRpcTwoParam);
        Assert.notEmpty(recOrderRpcPageRespVoList, (String)"\u67e5\u4e0d\u5230\u6536\u6b3e\u5355\u4fe1\u606f", (Object[])new Object[0]);
        Assert.equals((Object)recOrderRpcPageRespVoList.size(), (Object)1, (String)"\u67e5\u4e0d\u591a\u6761\u6536\u6b3e\u5355\u4fe1\u606f", (Object[])new Object[0]);
        RecOrderRpcPageRespVo recOrderRpcPageRespVo = recOrderRpcPageRespVoList.get(0);
        Assert.isNull((Object)recOrderRpcPageRespVo.getWorkflowProcInstId(), (String)"\u5df2\u7ecf\u53d1\u8d77\u4e86\u5de5\u4f5c\u6d41\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u8d77", (Object[])new Object[0]);
        return recOrderRpcPageRespVo;
    }

    public Long saveAssignStatus(RecOrderRpcParam recOrderRpcParam, String orderState) {
        if (CharSequenceUtil.isBlank((CharSequence)recOrderRpcParam.getCreateMode())) {
            throw new BusinessException("\u6765\u6e90\u5355\u636e createMode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RecOrder recOrder = RecOrderConvert.INSTANCE.convertRpc(recOrderRpcParam);
        Long resId = this.save(recOrder, orderState);
        return resId;
    }

    public Long save(RecOrder recOrder, String orderState) {
        if (recOrder.getId() != null) {
            recOrder.checkOrderState();
        } else {
            String recOrderNo = this.sysNumberRuleService.generateCode("yst-fin", "SKD", null);
            recOrder.setRecOrderNo(recOrderNo);
        }
        if (recOrder.getVerAmt() == null) {
            recOrder.defaultVer();
        }
        if (!recOrder.getCreateMode().equals(UdcEnum.FIN_REC_DOC_CLS_MANU.getValueCode())) {
            if (recOrder.getId() == null) {
                recOrder.setSoDef();
                recOrder.checkDtl(false);
            }
        } else {
            recOrder.checkTotalMoney();
        }
        recOrder.setOrderState(orderState);
        return this.updateOrSave(recOrder).getId();
    }

    private RecOrderDO updateOrSave(RecOrder recOrder) {
        RecOrderDO recOrderDO = RecOrderConvert.INSTANCE.convertToDo(recOrder);
        if (recOrder.getId() != null) {
            this.recOrderDtlRepoProc.deleteByMasIds(List.of(recOrder.getId()));
        } else {
            recOrderDO.setAuditDataVersion(0);
        }
        RecOrderDO save = (RecOrderDO)this.recOrderRepo.save(recOrderDO);
        List<RecOrderDtlDO> recOrderDtlDOS = RecOrderDtlConvert.INSTANCE.convertToDO(recOrder.getDtlList());
        recOrderDtlDOS.forEach(dtl -> dtl.setMasId(save.getId()));
        this.recOrderDtlRepo.saveAll(recOrderDtlDOS);
        return save;
    }

    public RecOrderRpcTwoServiceImpl(RecOrderRpcService recOrderRpcServiceImpl, RecOrderRpcDetailService recOrderRpcDetailService, WorkflowService workflowService, SeqNumProvider sysNumberRuleService, TaskExecutor taskExecutor, UdcProvider udcProvider, WorkflowRpcService workflowRpcService) {
        this.recOrderRpcServiceImpl = recOrderRpcServiceImpl;
        this.recOrderRpcDetailService = recOrderRpcDetailService;
        this.workflowService = workflowService;
        this.sysNumberRuleService = sysNumberRuleService;
        this.taskExecutor = taskExecutor;
        this.udcProvider = udcProvider;
        this.workflowRpcService = workflowRpcService;
    }
}

