/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.saleinv;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.saleinv.SaleInvConvert;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvDtlParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvParam;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDtlVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvdDtlVO;
import com.elitesland.fin.application.service.saleinv.SaleInvService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.domain.entity.saleinv.SaleInv;
import com.elitesland.fin.domain.param.saleinv.SaleInvDtlPageParam;
import com.elitesland.fin.domain.param.saleinv.SaleInvPageParam;
import com.elitesland.fin.domain.service.saleinv.SaleInvDomainService;
import com.elitesland.fin.domain.service.saleinv.SaleInvDtlDomainService;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvdDtlDTO;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleInvServiceImpl
implements SaleInvService {
    public final SaleInvDomainService saleInvDomainService;
    public final SaleInvDtlDomainService saleInvDtlDomainService;
    public final WorkflowRpcService workflowRpcService;

    @Override
    @SysCodeProc
    public PagingVO<SaleInvVO> page(SaleInvPageParam param) {
        PagingVO<SaleInvDTO> page = this.saleInvDomainService.page(param);
        PagingVO<SaleInvVO> res = SaleInvConvert.INSTANCE.convertPage(page);
        return res;
    }

    @Override
    @SysCodeProc
    public List<SaleInvDtlVO> getList(Long masId) {
        List<SaleInvDtlDTO> list = this.saleInvDtlDomainService.getList(masId);
        List<SaleInvDtlVO> res = SaleInvConvert.INSTANCE.convertListVO(list);
        return res;
    }

    @Override
    public List<SaleInvDtlVO> getSummaryList(List<SaleInvDtlParam> saleInvDtlParamList) {
        return this.saleInvDtlDomainService.getSummaryList(saleInvDtlParamList);
    }

    @Override
    @SysCodeProc
    public SaleInvVO get(Long id) {
        SaleInvDTO saleInvDTO = this.saleInvDomainService.get(id);
        SaleInvVO res = SaleInvConvert.INSTANCE.convert(saleInvDTO);
        return res;
    }

    @Override
    public Long save(SaleInvParam saleInvParam) {
        SaleInv saleInv = SaleInvConvert.INSTANCE.convert(saleInvParam);
        Long res = this.saleInvDomainService.save(saleInv);
        return res;
    }

    @Override
    public Long del(List<Long> ids) {
        Long res = this.saleInvDomainService.del(ids);
        return res;
    }

    @Override
    public Long update(SaleInvParam saleInvParam) {
        SaleInv saleInv = SaleInvConvert.INSTANCE.convert(saleInvParam);
        Long res = this.saleInvDomainService.update(saleInv);
        return res;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public Long submit(SaleInvParam saleInvParam) {
        SaleInv saleInv = SaleInvConvert.INSTANCE.convert(saleInvParam);
        Long resId = this.saleInvDomainService.submit(saleInv);
        if (saleInv.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(saleInv.getProcInstStatus())) {
            String procInstName = "\u9500\u552e\u53d1\u7968\u5ba1\u6838-" + saleInv.getInvRegNo();
            String procKey = WorkFlowDefKey.FIN_SALE_INV.name();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(procKey, procInstName, resId.toString(), new HashMap<String, Object>());
            this.saleInvDomainService.updateWorkInfo(processInfo, resId);
        }
        return resId;
    }

    @Override
    @SysCodeProc
    public List<SaleInvdDtlVO> getInvdLists(Long masId) {
        List<SaleInvdDtlDTO> list = this.saleInvDomainService.getInvdLists(masId);
        List<SaleInvdDtlVO> res = SaleInvConvert.INSTANCE.convertInvdListVO(list);
        return res;
    }

    @Override
    public Long updateInvInfo(SaleInvParam saleInvParam) {
        Long res = this.saleInvDomainService.updateInvInfo(saleInvParam);
        return res;
    }

    @Override
    public PagingVO<SaleInvDtlVO> dtlPage(SaleInvDtlPageParam saleInvDtlPageParam) {
        PagingVO<SaleInvDtlDTO> res = this.saleInvDtlDomainService.dtlPage(saleInvDtlPageParam);
        return SaleInvConvert.INSTANCE.convertDtlPage(res);
    }

    public SaleInvServiceImpl(SaleInvDomainService saleInvDomainService, SaleInvDtlDomainService saleInvDtlDomainService, WorkflowRpcService workflowRpcService) {
        this.saleInvDomainService = saleInvDomainService;
        this.saleInvDtlDomainService = saleInvDtlDomainService;
        this.workflowRpcService = workflowRpcService;
    }
}

