/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.invperiod;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.facade.dto.accountingengine.InvSobAccountPeriodDTO;
import com.elitesland.fin.application.facade.param.accountingengine.InvSobAccountPeriodParam;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.param.invperiod.InvPeriodControlRpcParam;
import com.elitesland.fin.repo.accountingengine.InvSobAccountPeriodRepoProc;
import com.elitesland.fin.service.invperiod.InvPeriodRpcService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/inv/periodControl"})
public class InvPeriodRpcServiceImpl
implements InvPeriodRpcService {
    private static final Logger log = LoggerFactory.getLogger(InvPeriodRpcServiceImpl.class);
    private final InvSobAccountPeriodRepoProc invSobAccountPeriodRepoProc;

    public ApiResult<LocalDateTime> queryInvPeriodControl(InvPeriodControlRpcParam param) {
        Assert.notNull((Object)param, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getOuCode(), (String)"\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)param.getTransactionDate(), (String)"\u4ea4\u6613\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        InvSobAccountPeriodParam queryParam = new InvSobAccountPeriodParam();
        queryParam.setOuCode(param.getOuCode());
        List<InvSobAccountPeriodDTO> periodDTOList = this.invSobAccountPeriodRepoProc.query(queryParam);
        Assert.notEmpty(periodDTOList, (String)"\u8be5\u516c\u53f8{}\u8fd8\u672a\u8bbe\u7f6e\u5e93\u5b58\u4f1a\u8ba1\u671f\u95f4\u63a7\u5236", (Object[])new Object[]{param.getOuCode()});
        List openList = periodDTOList.stream().filter(item -> UdcEnum.ACCOUNT_PERIOD_CONTROL_STATUS_OPEN.getValueCode().equals(item.getStatus())).collect(Collectors.toList());
        List closedList = periodDTOList.stream().filter(item -> UdcEnum.ACCOUNT_PERIOD_CONTROL_STATUS_CLOSED.getValueCode().equals(item.getStatus())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(openList)) {
            return ApiResult.ok((Object)param.getTransactionDate());
        }
        return ApiResult.ok((Object)this.beginDayOfNextMonth(LocalDateTime.now()));
    }

    private LocalDateTime beginDayOfNextMonth(LocalDateTime dateTime) {
        int nextMonth;
        int nextYear;
        int currentYear = dateTime.getYear();
        int currentMonth = dateTime.getMonthValue();
        if (currentMonth == 12) {
            nextYear = currentYear + 1;
            nextMonth = 1;
        } else {
            nextYear = currentYear;
            nextMonth = currentMonth + 1;
        }
        LocalDate nextMonthFirstDay = LocalDate.of(nextYear, nextMonth, 1);
        LocalDateTime beginDayOfNextMonth = LocalDateTime.of(nextMonthFirstDay, dateTime.toLocalTime());
        return beginDayOfNextMonth;
    }

    public InvPeriodRpcServiceImpl(InvSobAccountPeriodRepoProc invSobAccountPeriodRepoProc) {
        this.invSobAccountPeriodRepoProc = invSobAccountPeriodRepoProc;
    }
}

