/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinAccEngDetConditionConvert;
import com.elitesland.fin.application.convert.accountingengine.FinAccEngDetDataConvert;
import com.elitesland.fin.application.convert.accountingengine.FinAccEngDetDataLineConvert;
import com.elitesland.fin.application.convert.accountingengine.FinAccountEngineConvert;
import com.elitesland.fin.application.convert.accountingengine.FinAccountEngineDetailsConvert;
import com.elitesland.fin.application.facade.base.BaseModelParam;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccEngDetConditionParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccEngDetDataLineParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccEngDetDataParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccountEngineDetailsParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccountEngineParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccEngDetConditionVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccEngDetDataLineVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccEngDetDataVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccountEngineDetailsVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccountEngineVO;
import com.elitesland.fin.application.service.accountingengine.FinAccountEngineService;
import com.elitesland.fin.application.service.accountingengine.FinJournalLogService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.accountingengine.FinAccEngDetConditionDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccEngDetDataDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccEngDetDataLineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountEngineCustomDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountEngineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountEngineDetailsDO;
import com.elitesland.fin.domain.entity.accountingengine.FinEventTableConditionDO;
import com.elitesland.fin.domain.entity.accountingengine.FinEventTableDO;
import com.elitesland.fin.domain.entity.accountingengine.FinEventTableLineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFastCodeDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFastCodeLineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleValueDO;
import com.elitesland.fin.domain.entity.accountingengine.FinJournalLogDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookLineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookOuDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSobAccountPeriodDO;
import com.elitesland.fin.repo.accountingengine.FinAccEngDetConditionRepo;
import com.elitesland.fin.repo.accountingengine.FinAccEngDetDataLineRepo;
import com.elitesland.fin.repo.accountingengine.FinAccEngDetDataRepo;
import com.elitesland.fin.repo.accountingengine.FinAccountEngineDetailsRepo;
import com.elitesland.fin.repo.accountingengine.FinAccountEngineRepo;
import com.elitesland.fin.repo.accountingengine.FinAccountEngineRepoProc;
import com.elitesland.fin.repo.accountingengine.FinEventTableConditionRepo;
import com.elitesland.fin.repo.accountingengine.FinEventTableLineRepo;
import com.elitesland.fin.repo.accountingengine.FinEventTableRepo;
import com.elitesland.fin.repo.accountingengine.FinFastCodeLineRepo;
import com.elitesland.fin.repo.accountingengine.FinFastCodeLineRepoProc;
import com.elitesland.fin.repo.accountingengine.FinFastCodeRepo;
import com.elitesland.fin.repo.accountingengine.FinFastCodeRepoProc;
import com.elitesland.fin.repo.accountingengine.FinFlexibleRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleRepoProc;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepoProc;
import com.elitesland.fin.repo.accountingengine.FinJournalLogRepo;
import com.elitesland.fin.repo.accountingengine.FinJournalRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookLineRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookOuRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookRepoProc;
import com.elitesland.fin.repo.accountingengine.FinSobAccountPeriodRepo;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FinAccountEngineServiceImpl
implements FinAccountEngineService {
    private static final Logger log = LoggerFactory.getLogger(FinAccountEngineServiceImpl.class);
    private final FinAccountEngineRepo finAccountEngineRepo;
    private final FinAccountEngineRepoProc finAccountEngineRepoProc;
    private final FinAccountEngineDetailsRepo finAccountEngineDetailsRepo;
    private final FinAccEngDetConditionRepo finAccEngDetConditionRepo;
    private final FinAccEngDetDataRepo finAccEngDetDataRepo;
    private final FinAccEngDetDataLineRepo finAccEngDetDataLineRepo;
    private final FinEventTableRepo finEventTableRepo;
    private final FinEventTableLineRepo finEventTableLineRepo;
    private final FinEventTableConditionRepo finEventTableConditionRepo;
    private final FinJournalLogService finJournalLogService;
    private final FinJournalLogRepo finJournalLogRepo;
    private final FinSetOfBookOuRepo finSetOfBookOuRepo;
    private final FinSetOfBookRepo finSetOfBookRepo;
    private final FinSetOfBookRepoProc finSetOfBookRepoProc;
    private final FinSetOfBookLineRepo finSetOfBookLineRepo;
    private final FinFastCodeRepo finFastCodeRepo;
    private final FinFastCodeLineRepo finFastCodeLineRepo;
    private final FinFastCodeLineRepoProc finFastCodeLineRepoProc;
    private final FinFastCodeRepoProc finFastCodeRepoProc;
    private final FinFlexibleRepo finFlexibleRepo;
    private final FinFlexibleRepoProc finFlexibleRepoProc;
    private final FinFlexibleValueRepo finFlexibleValueRepo;
    private final FinFlexibleValueRepoProc finFlexibleValueRepoProc;
    private final FinSobAccountPeriodRepo finSobAccountPeriodRepo;
    private final FinJournalRepo finJournalRepo;
    private final UdcProvider udcProvider;
    private final TenantClientProvider tenantClientProvider;

    @Override
    @SysCodeProc
    public PagingVO<FinAccountEngineVO> page(FinAccountEngineParam finAccountEngineParam) {
        return FinAccountEngineConvert.INSTANCE.DTOToVO(this.finAccountEngineRepoProc.page(finAccountEngineParam));
    }

    @Override
    @SysCodeProc
    public FinAccountEngineVO queryFinAccountEngineDetails(FinAccountEngineDetailsParam param) {
        Assert.notNull((Object)param.getId(), (String)"\u4e3b\u8868id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Optional optional = this.finAccountEngineRepo.findById(param.getId());
        Assert.isTrue((boolean)optional.isPresent(), (String)"\u67e5\u8be2\u7684\u4f1a\u8ba1\u5f15\u64ce\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        FinAccountEngineVO engineVO = FinAccountEngineConvert.INSTANCE.DOToVo((FinAccountEngineDO)optional.get());
        List<FinAccountEngineDetailsDO> detailsDOList = this.finAccountEngineDetailsRepo.findAllByMasIdIn(List.of(param.getId()));
        List<FinAccountEngineDetailsVO> detailsVOList = FinAccountEngineDetailsConvert.INSTANCE.DOsToVOs(detailsDOList);
        engineVO.setFinAccountEngineDetails(detailsVOList);
        return engineVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableOrDisable(FinAccountEngineParam finAccountEngineParam) {
        this.checkEnableOrDisableParam(finAccountEngineParam);
        List finAccountEngineDOList = this.finAccountEngineRepo.findAllById(finAccountEngineParam.getIds());
        finAccountEngineDOList.stream().forEach(item -> Assert.isFalse((boolean)finAccountEngineParam.getStatus().equals(item.getStatus()), (String)"\u6570\u636e\u5df2\u7ecf\u542f\u7528/\u7981\u7528", (Object[])new Object[0]));
        finAccountEngineDOList.stream().forEach(item -> item.setStatus(finAccountEngineParam.getStatus()));
    }

    private void checkEnableOrDisableParam(FinAccountEngineParam finAccountEngineParam) {
        Assert.notEmpty(finAccountEngineParam.getIds(), (String)"id\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getStatus(), (String)"\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdateFinAccEngDetCondition(FinAccountEngineDetailsParam param) {
        this.checkSaveOrUpdateFinAccEngDetConditionParam(param);
        FinAccountEngineDetailsDO finAccountEngineDetailsDO = (FinAccountEngineDetailsDO)this.finAccountEngineDetailsRepo.save(FinAccountEngineDetailsConvert.INSTANCE.paramToDO(param));
        this.finAccEngDetConditionRepo.deleteAllByMasId(finAccountEngineDetailsDO.getId());
        List<FinAccEngDetConditionParam> finAccEngDetConditionParamList = param.getFinAccEngDetConditionDetailList();
        finAccEngDetConditionParamList.stream().forEach(item -> item.setMasId(finAccountEngineDetailsDO.getId()));
        this.finAccEngDetConditionRepo.saveAll(FinAccEngDetConditionConvert.INSTANCE.paramToDO(finAccEngDetConditionParamList));
        return finAccountEngineDetailsDO.getId();
    }

    @Override
    public Long saveOrUpdateFinAccEngDetDataLine(FinAccEngDetDataParam finAccEngDetDataParam) {
        this.finAccEngDetDataLineRepo.deleteAllByMasId(finAccEngDetDataParam.getId());
        List<FinAccEngDetDataLineParam> finAccEngDetDataLineList = finAccEngDetDataParam.getFinAccEngDetDataLineList();
        finAccEngDetDataLineList.stream().forEach(item -> item.setMasId(finAccEngDetDataParam.getId()));
        this.finAccEngDetDataLineRepo.saveAll(FinAccEngDetDataLineConvert.INSTANCE.param2DO(finAccEngDetDataLineList));
        return finAccEngDetDataParam.getId();
    }

    @Override
    public Long saveOrUpdateFinAccEngDetData(FinAccountEngineDetailsParam finAccountEngineDetailsParam) {
        this.checkSaveOrUpdateFinAccEngDetDataParam(finAccountEngineDetailsParam);
        List<FinAccEngDetDataDO> finAccEngDetDataDOList = this.finAccEngDetDataRepo.findAllByMasId(finAccountEngineDetailsParam.getId());
        List<FinAccEngDetDataParam> finAccEngDetDataParamList = finAccountEngineDetailsParam.getFinAccEngDetDataDetailList();
        List ids = finAccEngDetDataDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List<Long> deleteIds = finAccEngDetDataParamList.stream().filter(item -> item.getId() != null && !ids.contains(item.getId())).map(BaseModelParam::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deleteIds)) {
            this.finAccEngDetDataRepo.deleteByIdIn(deleteIds);
        }
        finAccEngDetDataParamList.stream().forEach(item -> item.setMasId(finAccountEngineDetailsParam.getId()));
        this.finAccEngDetDataRepo.saveAll(FinAccEngDetDataConvert.INSTANCE.param2DO(finAccEngDetDataParamList));
        return finAccountEngineDetailsParam.getId();
    }

    private void checkSaveOrUpdateFinAccEngDetDataParam(FinAccountEngineDetailsParam finAccountEngineDetailsParam) {
        Assert.notNull((Object)finAccountEngineDetailsParam.getId(), (String)"\u4e3b\u8868id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<FinAccEngDetDataParam> finAccEngDetDataDetailList = finAccountEngineDetailsParam.getFinAccEngDetDataDetailList();
        Assert.notEmpty(finAccEngDetDataDetailList, (String)"\u6570\u636e\u884c\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        finAccEngDetDataDetailList.stream().forEach(item -> {});
    }

    private void checkSaveOrUpdateFinAccEngDetConditionParam(FinAccountEngineDetailsParam param) {
        Assert.notNull((Object)param.getId(), (String)"\u4e3b\u8868id\u5fc5\u586b", (Object[])new Object[0]);
        List<FinAccEngDetConditionParam> finAccEngDetConditionParamList = param.getFinAccEngDetConditionDetailList();
        Assert.notEmpty(finAccEngDetConditionParamList, (String)"\u4f1a\u8ba1\u5f15\u64ce\u6761\u4ef6\u5fc5\u586b", (Object[])new Object[0]);
        HashSet serialNums = new HashSet();
        finAccEngDetConditionParamList.stream().forEach(item -> {
            Assert.notNull((Object)item.getSerialNum(), (String)"\u5e8f\u53f7\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getColumnName(), (String)"\u5b57\u6bb5\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getConditionType(), (String)"\u6761\u4ef6\u5fc5\u586b", (Object[])new Object[0]);
            Assert.isFalse((boolean)serialNums.contains(item.getSerialNum()), (String)"\u5e8f\u53f7\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
            serialNums.add(item.getSerialNum());
        });
    }

    private void checkFinAccountEngineDetailsParam(FinAccountEngineDetailsParam param) {
        Assert.notNull((Object)param.getSerialNum(), (String)"\u5e8f\u53f7\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getAccountEngine(), (String)"\u4f1a\u8ba1\u5f15\u64ce\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)param.getActiveFlag(), (String)"\u662f\u5426\u542f\u7528\u5fc5\u586b", (Object[])new Object[0]);
    }

    @Override
    @SysCodeProc
    public FinAccountEngineVO queryFinAccountEngine(FinAccountEngineParam finAccountEngineParam) {
        FinAccountEngineDO finAccountEngineDO = this.finAccountEngineRepoProc.findById(finAccountEngineParam.getId());
        FinAccountEngineVO finAccountEngineVO = FinAccountEngineConvert.INSTANCE.DOToVo(finAccountEngineDO);
        List<FinAccountEngineDetailsDO> finAccountEngineDetailsDOList = this.finAccountEngineDetailsRepo.findAllByMasId(finAccountEngineVO.getId());
        List<FinAccountEngineDetailsVO> finAccountEngineDetailsVOList = FinAccountEngineDetailsConvert.INSTANCE.DOsToVOs(finAccountEngineDetailsDOList);
        finAccountEngineVO.setFinAccountEngineDetails(finAccountEngineDetailsVOList);
        List<Long> finAccountEngineDetailsIds = finAccountEngineDetailsVOList.stream().map(BaseModelVO::getId).collect(Collectors.toList());
        List<FinAccEngDetConditionDO> finAccEngDetConditionDOList = this.finAccEngDetConditionRepo.findAllByMasIdIn(finAccountEngineDetailsIds);
        List<FinAccEngDetConditionVO> finAccEngDetConditionVOList = FinAccEngDetConditionConvert.INSTANCE.DOsToVos(finAccEngDetConditionDOList);
        List<FinAccEngDetDataDO> finAccEngDetDataDOList = this.finAccEngDetDataRepo.findAllByMasIdIn(finAccountEngineDetailsIds);
        List<FinAccEngDetDataVO> finAccEngDetDataVOList = FinAccEngDetDataConvert.INSTANCE.DOsToVOs(finAccEngDetDataDOList);
        finAccountEngineDetailsVOList.stream().forEach(item -> {
            item.setFinAccEngDetConditionDetailList(finAccEngDetConditionVOList.stream().filter(e -> item.getId().equals(e.getMasId())).collect(Collectors.toList()));
            item.setFinAccEngDetDataDetailList(finAccEngDetDataVOList.stream().filter(e -> item.getId().equals(e.getMasId())).collect(Collectors.toList()));
        });
        List<Long> finAccEngDetDataVOIds = finAccountEngineDetailsVOList.stream().flatMap(item -> item.getFinAccEngDetDataDetailList().stream().map(BaseModelVO::getId)).collect(Collectors.toList());
        List<FinAccEngDetDataLineDO> finAccEngDetDataLineDOList = this.finAccEngDetDataLineRepo.findAllByMasIdIn(finAccEngDetDataVOIds);
        List<FinAccEngDetDataLineVO> finAccEngDetDataLineVOList = FinAccEngDetDataLineConvert.INSTANCE.DOsToVOS(finAccEngDetDataLineDOList);
        finAccountEngineDetailsVOList.stream().forEach(item -> item.getFinAccEngDetDataDetailList().stream().forEach(e -> e.setFinAccEngDetDataLineList(finAccEngDetDataLineVOList.stream().filter(v -> e.getId().equals(v.getMasId())).collect(Collectors.toList()))));
        Map eventTableConditionUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.EVENT_TABLE_CONDITION_EQUAL.getModel(), UdcEnum.EVENT_TABLE_CONDITION_EQUAL.getCode());
        Map sourceTypeUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.SOURCE_TYPE_ACCOUNT_PERIOD.getModel(), UdcEnum.SOURCE_TYPE_ACCOUNT_PERIOD.getCode());
        List<FinAccountEngineDetailsVO> finAccountEngineDetails = finAccountEngineVO.getFinAccountEngineDetails();
        if (CollectionUtils.isNotEmpty(finAccountEngineDetails)) {
            finAccountEngineDetails.stream().forEach(item -> {
                List<FinAccEngDetDataVO> finAccEngDetDataDetailList;
                List<FinAccEngDetConditionVO> finAccEngDetConditionDetailList = item.getFinAccEngDetConditionDetailList();
                if (CollectionUtils.isNotEmpty(finAccEngDetConditionDetailList)) {
                    finAccEngDetConditionDetailList.stream().forEach(e -> e.setConditionTypeName((String)eventTableConditionUdc.get(e.getConditionType())));
                }
                if (CollectionUtils.isNotEmpty(finAccEngDetDataDetailList = item.getFinAccEngDetDataDetailList())) {
                    finAccEngDetDataDetailList.stream().forEach(e -> {
                        List<FinAccEngDetDataLineVO> finAccEngDetDataLineList = e.getFinAccEngDetDataLineList();
                        if (CollectionUtils.isNotEmpty(finAccEngDetDataLineList)) {
                            finAccEngDetDataLineList.stream().forEach(v -> v.setSourceTypeName((String)sourceTypeUdc.get(v.getSourceType())));
                        }
                    });
                }
            });
        }
        return finAccountEngineVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdate(FinAccountEngineParam finAccountEngineParam) {
        List<FinAccountEngineDetailsDO> finAccountEngineDetailsDOList;
        List<Long> finAccountEngineDetailIds;
        this.checkSaveOrUpdateParam(finAccountEngineParam);
        boolean add = finAccountEngineParam.getId() == null;
        FinAccountEngineDO finAccountEngineDO = (FinAccountEngineDO)this.finAccountEngineRepo.save(FinAccountEngineConvert.INSTANCE.paramToDO(finAccountEngineParam));
        if (!add && CollectionUtils.isNotEmpty(finAccountEngineDetailIds = (finAccountEngineDetailsDOList = this.finAccountEngineDetailsRepo.findAllByMasId(finAccountEngineParam.getId())).stream().map(BaseModel::getId).collect(Collectors.toList()))) {
            this.finAccEngDetConditionRepo.deleteByMasIdIn(finAccountEngineDetailIds);
            List<FinAccEngDetDataDO> finAccEngDetDataIds = this.finAccEngDetDataRepo.findAllByMasIdIn(finAccountEngineDetailIds);
            List<Long> collect = finAccEngDetDataIds.stream().map(BaseModel::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                this.finAccEngDetDataLineRepo.deleteByMasIdIn(collect);
            }
            this.finAccEngDetDataRepo.deleteByMasIdIn(finAccountEngineDetailIds);
            this.finAccountEngineDetailsRepo.deleteByIdIn(finAccountEngineDetailIds);
        }
        List<FinAccountEngineDetailsParam> finAccountEngineDetailsParamList = finAccountEngineParam.getFinAccountEngineDetails();
        finAccountEngineDetailsParamList.stream().forEach(item -> item.setMasId(finAccountEngineDO.getId()));
        List finAccountEngineDetailsDOList2 = this.finAccountEngineDetailsRepo.saveAll(FinAccountEngineDetailsConvert.INSTANCE.paramToDO(finAccountEngineDetailsParamList));
        finAccountEngineDetailsParamList.stream().forEach(item -> {
            FinAccountEngineDetailsDO result = finAccountEngineDetailsDOList2.stream().filter(e -> e.getSerialNum().equals(item.getSerialNum())).findFirst().orElse(null);
            List<FinAccEngDetConditionParam> finAccEngDetConditionDetailList = item.getFinAccEngDetConditionDetailList();
            finAccEngDetConditionDetailList.stream().forEach(e -> e.setMasId(result.getId()));
            List<FinAccEngDetDataParam> finAccEngDetDataDetailList = item.getFinAccEngDetDataDetailList();
            finAccEngDetDataDetailList.stream().forEach(e -> e.setMasId(result.getId()));
        });
        List<FinAccEngDetConditionParam> finAccEngDetConditionParamList = finAccountEngineDetailsParamList.stream().flatMap(item -> item.getFinAccEngDetConditionDetailList().stream()).collect(Collectors.toList());
        this.finAccEngDetConditionRepo.saveAll(FinAccEngDetConditionConvert.INSTANCE.paramToDO(finAccEngDetConditionParamList));
        List<FinAccEngDetDataParam> finAccEngDetDataParamList = finAccountEngineDetailsParamList.stream().flatMap(item -> item.getFinAccEngDetDataDetailList().stream()).collect(Collectors.toList());
        List finAccEngDetDataDOS = this.finAccEngDetDataRepo.saveAll(FinAccEngDetDataConvert.INSTANCE.param2DO(finAccEngDetDataParamList));
        finAccEngDetDataParamList.stream().forEach(item -> {
            FinAccEngDetDataDO result = finAccEngDetDataDOS.stream().filter(e -> e.getSerialNum().equals(item.getSerialNum())).findFirst().orElse(null);
            List<FinAccEngDetDataLineParam> finAccEngDetDataLineList = item.getFinAccEngDetDataLineList();
            finAccEngDetDataLineList.stream().forEach(e -> e.setMasId(result.getId()));
        });
        List<FinAccEngDetDataLineParam> finAccEngDetDataLineList = finAccEngDetDataParamList.stream().flatMap(item -> item.getFinAccEngDetDataLineList().stream()).collect(Collectors.toList());
        this.finAccEngDetDataLineRepo.saveAll(FinAccEngDetDataLineConvert.INSTANCE.param2DO(finAccEngDetDataLineList));
        return finAccountEngineDO.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdateFinAccountEngineDetail(FinAccountEngineParam finAccountEngineParam) {
        this.checkSaveOrUpdateFinAccountEngineDetailParam(finAccountEngineParam);
        this.checkIdempotent(finAccountEngineParam);
        List<FinAccountEngineDetailsDO> finAccountEngineDetailsDOList = this.finAccountEngineDetailsRepo.findAllByMasId(finAccountEngineParam.getId());
        List<FinAccountEngineDetailsParam> finAccountEngineDetailsParamList = finAccountEngineParam.getFinAccountEngineDetails();
        List ids = finAccountEngineDetailsDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List<Long> deleteIds = finAccountEngineDetailsParamList.stream().filter(item -> item.getId() != null && !ids.contains(item.getId())).map(BaseModelParam::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deleteIds)) {
            this.finAccountEngineDetailsRepo.deleteByIdIn(deleteIds);
        }
        finAccountEngineDetailsParamList.stream().forEach(item -> item.setMasId(finAccountEngineParam.getId()));
        this.finAccountEngineDetailsRepo.saveAll(FinAccountEngineDetailsConvert.INSTANCE.paramToDO(finAccountEngineDetailsParamList));
        return finAccountEngineParam.getId();
    }

    private void checkSaveOrUpdateFinAccountEngineDetailParam(FinAccountEngineParam finAccountEngineParam) {
        Assert.notNull((Object)finAccountEngineParam.getId(), (String)"\u4e3b\u8868id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<FinAccountEngineDetailsParam> finAccountEngineDetailsParamList = finAccountEngineParam.getFinAccountEngineDetails();
        Assert.notEmpty(finAccountEngineDetailsParamList, (String)"\u4f1a\u8ba1\u5f15\u64ce\u660e\u7ec6\u5fc5\u586b", (Object[])new Object[0]);
        HashSet serialNums = new HashSet();
        finAccountEngineDetailsParamList.stream().forEach(item -> {
            this.checkFinAccountEngineDetailsParam((FinAccountEngineDetailsParam)((Object)item));
            Assert.isFalse((boolean)serialNums.contains(item.getSerialNum()), (String)"\u5e8f\u53f7\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
            serialNums.add(item.getSerialNum());
        });
    }

    private void checkSaveOrUpdateParam(FinAccountEngineParam finAccountEngineParam) {
        Assert.notEmpty((CharSequence)finAccountEngineParam.getEventTable(), (String)"\u4e8b\u4ef6\u8868\u5355\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getColumnCompany(), (String)"\u516c\u53f8\u5b57\u6bb5\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getJournalHost(), (String)"\u4e3b\u673a\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getJournalPort(), (String)"\u7aef\u53e3\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getJournalUser(), (String)"\u7528\u6237\u540d\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getJournalPassword(), (String)"\u5bc6\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getJournalDatabase(), (String)"\u6570\u636e\u5e93\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getJournalTable(), (String)"\u4e3b\u8868\u5fc5\u586b", (Object[])new Object[0]);
    }

    private void checkIdempotent(FinAccountEngineParam finAccountEngineParam) {
        FinAccountEngineDO finAccountEngineDO = this.finAccountEngineRepoProc.findByEventTable(finAccountEngineParam.getEventTable());
        if (finAccountEngineDO != null) {
            Assert.equals((Object)finAccountEngineParam.getId(), (Object)finAccountEngineDO.getId(), (String)"\u4e8b\u4ef6\u8868\u5355\u540d\u79f0\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        }
    }

    @Override
    public List<FinAccEngDetDataLineVO> queryFinAccDetDataLine(FinAccEngDetDataParam param) {
        Assert.notNull((Object)param.getId(), (String)"\u4e3b\u8868id\u5fc5\u586b", (Object[])new Object[0]);
        List<FinAccEngDetDataLineDO> dataLineDOList = this.finAccEngDetDataLineRepo.findAllByMasIdIn(List.of(param.getMasId()));
        List<FinAccEngDetDataLineVO> dataLineVOList = FinAccEngDetDataLineConvert.INSTANCE.DOsToVOS(dataLineDOList);
        return dataLineVOList;
    }

    @Override
    public FinAccountEngineDetailsVO queryFinAccEngDetCondition(FinAccountEngineDetailsParam param) {
        Assert.notNull((Object)param.getId(), (String)"masId is not null", (Object[])new Object[0]);
        Optional optional = this.finAccountEngineDetailsRepo.findById(param.getId());
        Assert.isTrue((boolean)optional.isPresent(), (String)"\u8be6\u60c5\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        FinAccountEngineDetailsVO detailsVO = FinAccountEngineDetailsConvert.INSTANCE.DOToVO((FinAccountEngineDetailsDO)optional.get());
        List<FinAccEngDetDataDO> detDataDOList = this.finAccEngDetDataRepo.findAllByMasIdIn(List.of(param.getId()));
        List<FinAccEngDetDataVO> detDataVOList = FinAccEngDetDataConvert.INSTANCE.DOsToVOs(detDataDOList);
        detailsVO.setFinAccEngDetDataDetailList(detDataVOList);
        List<FinAccEngDetConditionDO> conditionDOList = this.finAccEngDetConditionRepo.findAllByMasIdIn(List.of(param.getId()));
        List<FinAccEngDetConditionVO> conditionVOList = FinAccEngDetConditionConvert.INSTANCE.DOsToVos(conditionDOList);
        detailsVO.setFinAccEngDetConditionDetailList(conditionVOList);
        return detailsVO;
    }

    @Override
    public List<FinAccEngDetDataVO> queryFinAccEngDetData(FinAccountEngineDetailsParam finAccountEngineDetailsParam) {
        Assert.notNull((Object)finAccountEngineDetailsParam.getId(), (String)"\u4e3b\u8868id\u5fc5\u586b", (Object[])new Object[0]);
        List<FinAccEngDetDataDO> finAccEngDetDataDOList = this.finAccEngDetDataRepo.findAllByMasId(finAccountEngineDetailsParam.getId());
        return FinAccEngDetDataConvert.INSTANCE.DOsToVOs(finAccEngDetDataDOList);
    }

    private String buildWhere(List<FinEventTableConditionDO> finEventTableConditionDOList, List<FinAccEngDetConditionDO> finAccEngDetConditionDOList) {
        if (CollectionUtils.isEmpty(finEventTableConditionDOList) && CollectionUtils.isEmpty(finAccEngDetConditionDOList)) {
            return "1=1";
        }
        List wheres = finEventTableConditionDOList.stream().map(item -> this.buildWhere(item.getConditionType(), item.getTableName(), item.getColumnName(), item.getValueFrom(), item.getValueTo())).collect(Collectors.toList());
        wheres.addAll(finAccEngDetConditionDOList.stream().map(item -> this.buildWhere(item.getConditionType(), item.getTableName(), item.getColumnName(), item.getValueFrom(), item.getValueTo())).collect(Collectors.toList()));
        return StringUtils.join(wheres, (String)" ".concat("and").concat(" "));
    }

    private String addTenantCondition(String sql, String mainTableName, String detailTableName) {
        if (StringUtils.isBlank((CharSequence)sql)) {
            return sql;
        }
        long tenantId = -1L;
        if (this.tenantClientProvider.getCurrentTenant() != null) {
            tenantId = this.tenantClientProvider.getCurrentTenant().getId();
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mainTableName})) {
            sql = (String)sql + " and " + mainTableName + ".tenant_id=" + tenantId;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{detailTableName})) {
                sql = (String)sql + " and " + detailTableName + ".tenant_id=" + tenantId;
            }
        }
        return sql;
    }

    private String buildWhere(String conditionType, String tableName, String columnName, String valueFrom, String valueTo) {
        Map eventTableConditionUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.EVENT_TABLE_CONDITION_EQUAL.getModel(), UdcEnum.EVENT_TABLE_CONDITION_EQUAL.getCode());
        conditionType = (String)eventTableConditionUdc.get(conditionType);
        String concat = tableName.concat(".").concat(columnName).concat(" ");
        if (UdcEnum.EVENT_TABLE_CONDITION_BETWEEN_AND.getValueCode().equals(conditionType)) {
            return concat.concat("between").concat(" ").concat("'").concat(valueFrom).concat("'").concat(" ").concat("and").concat(" ").concat("'").concat(valueTo).concat("'");
        }
        concat = concat.concat(conditionType).concat(" ");
        if (valueFrom != null) {
            concat = concat.concat("'" + valueFrom + "'");
        }
        return concat;
    }

    private String buildFields(List<FinEventTableLineDO> finEventTableLineDOList) {
        List fieldList = finEventTableLineDOList.stream().map(item -> item.getTableName().concat(".").concat(item.getColumnName())).collect(Collectors.toList());
        return StringUtils.join(fieldList, (String)",");
    }

    private String buildSql(FinAccountEngineCustomDO finAccountEngineCustomDO, List<FinAccEngDetConditionDO> finAccEngDetConditionDOList) {
        if (StringUtils.isNotEmpty((CharSequence)finAccountEngineCustomDO.getFinEventTableDO().getTableName())) {
            return "select".concat(" ").concat(this.buildFields(finAccountEngineCustomDO.getFinEventTableLineDOList())).concat(" ").concat("from").concat(" ").concat(finAccountEngineCustomDO.getFinEventTableDO().getMasTable()).concat(" ").concat("inner").concat(" ").concat("join").concat(" ").concat(finAccountEngineCustomDO.getFinEventTableDO().getTableName()).concat(" ").concat("where").concat(" ").concat(finAccountEngineCustomDO.getFinEventTableDO().getMasTable()).concat(".").concat("id").concat(" ").concat("=").concat(" ").concat(finAccountEngineCustomDO.getFinEventTableDO().getTableName()).concat(".").concat("mas").concat("_").concat("id").concat(" ").concat("and").concat(" ").concat(this.buildWhere(finAccountEngineCustomDO.getFinEventTableConditionDOList(), finAccEngDetConditionDOList));
        }
        return "select".concat(" ").concat(this.buildFields(finAccountEngineCustomDO.getFinEventTableLineDOList())).concat(" ").concat("from").concat(" ").concat(finAccountEngineCustomDO.getFinEventTableDO().getMasTable()).concat(" ").concat("where").concat(" ").concat("1").concat("=").concat("1").concat(" ").concat("and").concat(" ").concat(this.buildWhere(finAccountEngineCustomDO.getFinEventTableConditionDOList(), finAccEngDetConditionDOList));
    }

    @Override
    public void generateJournal(FinAccountEngineParam finAccountEngineParam) {
        this.checkGenerateJournalParam(finAccountEngineParam);
        ArrayList<Map> saveMapList = new ArrayList<Map>();
        this.buildSaveMapList(finAccountEngineParam, saveMapList);
        this.saveFinJournal(finAccountEngineParam, saveMapList);
    }

    @Override
    public List<FinAccEngDetDataLineVO> loadTemplate(FinAccEngDetDataParam finAccEngDetDataParam) {
        this.checkLoadTemplateParam(finAccEngDetDataParam);
        return this.loadTemplateFromDB(finAccEngDetDataParam);
    }

    private List<FinAccEngDetDataLineVO> loadTemplateFromDB(FinAccEngDetDataParam finAccEngDetDataParam) {
        ResultSet resultSet = null;
        Connection connection = null;
        Statement preparedStatement = null;
        ArrayList<FinAccEngDetDataLineVO> finAccEngDetDataLineVOList = new ArrayList<FinAccEngDetDataLineVO>();
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            connection = DriverManager.getConnection(String.format("jdbc:mysql://%s:%s/%s", finAccEngDetDataParam.getJournalHost(), finAccEngDetDataParam.getJournalPort(), finAccEngDetDataParam.getJournalDatabase()), finAccEngDetDataParam.getJournalUser(), finAccEngDetDataParam.getJournalPassword());
            String sql = "select column_name, data_type, column_key,column_comment,character_maximum_length from information_schema.columns where table_name = '" + finAccEngDetDataParam.getJournalTable() + "'";
            preparedStatement = connection.prepareStatement(sql);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                FinAccEngDetDataLineVO finAccEngDetDataLineVO = new FinAccEngDetDataLineVO();
                int columnCount = resultSet.getMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    if ("column_name".equals(resultSet.getMetaData().getColumnName(i)) || "COLUMN_NAME".equals(resultSet.getMetaData().getColumnName(i))) {
                        Object columnName = resultSet.getObject(resultSet.getMetaData().getColumnName(i));
                        finAccEngDetDataLineVO.setColumnName(Optional.ofNullable(columnName).map(item -> item.toString()).orElse(null));
                    }
                    if ("data_type".equals(resultSet.getMetaData().getColumnName(i)) || "DATA_TYPE".equals(resultSet.getMetaData().getColumnName(i))) {
                        Object columnType = resultSet.getObject(resultSet.getMetaData().getColumnName(i));
                        finAccEngDetDataLineVO.setColumnType(Optional.ofNullable(columnType).map(item -> item.toString()).orElse(null));
                    }
                    if ("column_comment".equals(resultSet.getMetaData().getColumnName(i)) || "COLUMN_COMMENT".equals(resultSet.getMetaData().getColumnName(i))) {
                        Object columnComment = resultSet.getObject(resultSet.getMetaData().getColumnName(i));
                        finAccEngDetDataLineVO.setColumnComment(Optional.ofNullable(columnComment).map(item -> item.toString()).orElse(null));
                    }
                    if (!"character_maximum_length".equals(resultSet.getMetaData().getColumnName(i)) && !"CHARACTER_MAXIMUM_LENGTH".equals(resultSet.getMetaData().getColumnName(i))) continue;
                    Object columnLength = resultSet.getObject(resultSet.getMetaData().getColumnName(i));
                    finAccEngDetDataLineVO.setColumnLength(Optional.ofNullable(columnLength).map(item -> Integer.valueOf(item.toString())).orElse(null));
                }
                finAccEngDetDataLineVOList.add(finAccEngDetDataLineVO);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u67e5\u8be2\u6570\u636e\u5e93\u5b57\u6bb5\u5f02\u5e38");
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        FinSetOfBookDO finSetOfBookDO = this.finSetOfBookRepoProc.findBySobCodeAndStatus(finAccEngDetDataParam.getSobCode(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        Assert.notNull((Object)finSetOfBookDO, (String)"\u8d26\u5957\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        List<FinSetOfBookLineDO> finSetOfBookLineDOList = this.finSetOfBookLineRepo.findAllByMasId(finSetOfBookDO.getId());
        Assert.notEmpty(finSetOfBookLineDOList, (String)"\u8d26\u5957\u660e\u7ec6\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        finSetOfBookLineDOList.stream().forEach(item -> {
            FinAccEngDetDataLineVO finAccEngDetDataLineVO = new FinAccEngDetDataLineVO();
            finAccEngDetDataLineVO.setColumnName(item.getColumnName());
            finAccEngDetDataLineVO.setColumnType("varchar");
            finAccEngDetDataLineVO.setColumnComment(null);
            finAccEngDetDataLineVO.setColumnLength(32);
            finAccEngDetDataLineVOList.add(finAccEngDetDataLineVO);
        });
        return finAccEngDetDataLineVOList;
    }

    private void checkLoadTemplateParam(FinAccEngDetDataParam finAccEngDetDataParam) {
        Assert.notEmpty((CharSequence)finAccEngDetDataParam.getJournalHost(), (String)"\u4e3b\u673a\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccEngDetDataParam.getJournalPort(), (String)"\u7aef\u53e3\u53f7\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccEngDetDataParam.getJournalDatabase(), (String)"\u6570\u636e\u5e93\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccEngDetDataParam.getJournalUser(), (String)"\u7528\u6237\u540d\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccEngDetDataParam.getJournalPassword(), (String)"\u5bc6\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccEngDetDataParam.getJournalTable(), (String)"\u4e3b\u8868\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccEngDetDataParam.getSobCode(), (String)"\u8d26\u5957\u7f16\u7801\u5fc5\u586b", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildSaveMapList(FinAccountEngineParam finAccountEngineParam, List<Map> saveMapList) {
        ResultSet resultSet = null;
        Connection connection = null;
        Statement preparedStatement = null;
        FinAccountEngineCustomDO finAccountEngineCustomDO = this.queryData(finAccountEngineParam);
        FinEventTableDO finEventTableDO = finAccountEngineCustomDO.getFinEventTableDO();
        FinAccountEngineDO finAccountEngineDO = finAccountEngineCustomDO.getFinAccountEngineDO();
        String docNum = null;
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            connection = DriverManager.getConnection(String.format("jdbc:mysql://%s:%s/%s", finEventTableDO.getHost(), finEventTableDO.getPort(), finEventTableDO.getDatabaseName()), finEventTableDO.getUserName(), finEventTableDO.getPassword());
            block30: for (FinAccountEngineDetailsDO finAccountEngineDetailsDO : finAccountEngineCustomDO.getFinAccountEngineDetailsDOList()) {
                List finAccEngDetDataDOListItem = finAccountEngineCustomDO.getFinAccEngDetDataDOList().stream().filter(finAccEngDetDataDO -> finAccountEngineDetailsDO.getId().equals(finAccEngDetDataDO.getMasId())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(finAccEngDetDataDOListItem)) {
                    this.saveFinJournalLog(null, "\u4f1a\u8ba1\u5f15\u64ce\u6570\u636e\u884c\u672a\u914d\u7f6e\uff0c\u4f1a\u8ba1\u5f15\u64ce\u3010" + finAccountEngineDetailsDO.getAccountEngine() + "\u3011");
                    continue;
                }
                List<FinAccEngDetConditionDO> finAccEngDetConditionDOListItem = finAccountEngineCustomDO.getFinAccEngDetConditionDOList().stream().filter(finAccEngDetDataDO -> finAccountEngineDetailsDO.getId().equals(finAccEngDetDataDO.getMasId())).collect(Collectors.toList());
                String sql = this.buildSql(finAccountEngineCustomDO, finAccEngDetConditionDOListItem);
                sql = this.addTenantCondition(sql, finEventTableDO.getMasTable(), finEventTableDO.getTableName());
                log.info("\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1,\u4f1a\u8ba1\u5f15\u64ce\u8be6\u60c5\uff1a{},\u4e1a\u52a1\u5355\u636e\u67e5\u8be2sql:{}", (Object)finAccountEngineDetailsDO.getAccountEngine(), (Object)sql);
                preparedStatement = connection.prepareStatement(sql);
                resultSet = preparedStatement.executeQuery();
                ArrayList resultList = new ArrayList();
                while (resultSet.next()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    int n = resultSet.getMetaData().getColumnCount();
                    for (int i = 1; i <= n; ++i) {
                        map.put(resultSet.getMetaData().getColumnName(i), resultSet.getObject(resultSet.getMetaData().getColumnName(i)));
                    }
                    resultList.add(map);
                }
                if (CollectionUtils.isEmpty(resultList)) {
                    this.saveFinJournalLog(null, String.format("{},{}\u7684\u6761\u4ef6\u672a\u547d\u4e2d", finAccountEngineCustomDO.getFinAccountEngineDO().getEventTable(), finAccountEngineDetailsDO.getAccountEngine()));
                    return;
                }
                log.info("\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0c\u67e5\u8be2\u6570\u636e\u5e93\u5b57\u6bb5\u5217\u8868\uff1a" + JSON.toJSONString(resultList));
                for (Map map : resultList) {
                    docNum = (String)map.get(finAccountEngineCustomDO.getFinAccountEngineDO().getColumnDocNum());
                    JournalLogInfo journalLogInfo = new JournalLogInfo(docNum, finAccountEngineCustomDO.getFinAccountEngineDO().getEventTable(), finAccountEngineDetailsDO.getAccountEngine());
                    if (docNum == null) {
                        journalLogInfo.setErrMsg("\u5355\u636e\u7f16\u7801\u4e3a\u7a7a");
                        this.saveFinJournalLogNew(journalLogInfo);
                        continue;
                    }
                    String ouCode = (String)map.get(finAccountEngineCustomDO.getFinAccountEngineDO().getColumnCompany());
                    if (ouCode == null) {
                        journalLogInfo.setErrMsg("\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
                        this.saveFinJournalLogNew(journalLogInfo);
                        continue;
                    }
                    ArrayList<Map> detDataList = new ArrayList<Map>();
                    boolean checkResult = true;
                    for (FinAccEngDetDataDO finAccEngDetDataDO2 : finAccEngDetDataDOListItem) {
                        journalLogInfo.setDetDataName(finAccEngDetDataDO2.getName());
                        if (!this.checkFinSetOfBookOu(finAccountEngineCustomDO, ouCode, docNum, finAccountEngineCustomDO.getFinAccountEngineDO(), finAccountEngineDetailsDO, finAccEngDetDataDO2)) continue;
                        List finAccEngDetDataLineDOListItem = finAccountEngineCustomDO.getFinAccEngDetDataLineDOList().stream().filter(finAccEngDetDataLineDO -> finAccEngDetDataDO2.getId().equals(finAccEngDetDataLineDO.getMasId())).collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(finAccEngDetDataLineDOListItem)) {
                            journalLogInfo.setErrMsg("\u67e5\u4e0d\u5230\u6570\u636e\u6620\u5c04");
                            this.saveFinJournalLogNew(journalLogInfo);
                            checkResult = false;
                            break;
                        }
                        HashMap<String, Long> saveMap = new HashMap<String, Long>();
                        saveMap.put("detDataId", finAccEngDetDataDO2.getId());
                        for (FinAccEngDetDataLineDO finAccEngDetDataLineDO2 : finAccEngDetDataLineDOListItem) {
                            if (!this.checkConstant(finAccEngDetDataLineDO2, docNum, finAccountEngineCustomDO.getFinAccountEngineDO(), finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap)) {
                                checkResult = false;
                                break;
                            }
                            if (!this.checkColumn(finAccEngDetDataLineDO2, map, docNum, finAccountEngineCustomDO.getFinAccountEngineDO(), finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap)) {
                                checkResult = false;
                                break;
                            }
                            if (!this.checkFastCode(finAccEngDetDataLineDO2, finAccountEngineCustomDO, map, docNum, finAccountEngineCustomDO.getFinAccountEngineDO(), finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap)) {
                                checkResult = false;
                                break;
                            }
                            if (!this.checkFlexible(finAccEngDetDataLineDO2, finAccountEngineCustomDO, docNum, finAccountEngineCustomDO.getFinAccountEngineDO(), finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap)) {
                                checkResult = false;
                                break;
                            }
                            if (this.checkAccountPeriod(finAccEngDetDataLineDO2, map, finAccountEngineCustomDO, ouCode, docNum, finAccountEngineCustomDO.getFinAccountEngineDO(), finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap)) continue;
                            checkResult = false;
                            break;
                        }
                        if (!checkResult) break;
                        detDataList.add(saveMap);
                    }
                    if (!checkResult) continue block30;
                    if (CollectionUtils.isEmpty(detDataList)) continue;
                    if (!this.checkDebtAndCreditSumEqual(detDataList, journalLogInfo)) continue block30;
                    saveMapList.addAll(detDataList);
                }
            }
        }
        catch (Exception e) {
            log.error("\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0c\u6267\u884c\u5f02\u5e38", (Throwable)e);
            this.saveFinJournalLog(docNum, e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean checkFinSetOfBookOu(FinAccountEngineCustomDO finAccountEngineCustomDO, String ouCode, String docNum, FinAccountEngineDO finAccountEngineDO, FinAccountEngineDetailsDO finAccountEngineDetailsDO, FinAccEngDetDataDO finAccEngDetDataDO) {
        String sobCode = finAccEngDetDataDO.getSobCode();
        FinSetOfBookDO finSetOfBookDOResult = finAccountEngineCustomDO.getFinSetOfBookDOList().stream().filter(finSetOfBookDO -> finSetOfBookDO.getSobCode().equals(sobCode)).findFirst().orElse(null);
        if (finSetOfBookDOResult == null) {
            this.saveFinJournalLog(docNum, String.format("\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u8d26\u5957,\u4e8b\u4ef6\u8868\u5355\u3010%s\u3011,\u4f1a\u8ba1\u5f15\u64ce\u3010%s\u3011,\u6570\u636e\u884c\u3010%s\u3011,\u5355\u636e\u516c\u53f8\u7f16\u7801\u3010%s\u3011", finAccountEngineDO.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), ouCode));
            return false;
        }
        List finSetOfBookOuDOListItem = finAccountEngineCustomDO.getFinSetOfBookOuDOList().stream().filter(finSetOfBookOuDO -> finSetOfBookDOResult.getId().equals(finSetOfBookOuDO.getMasId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(finSetOfBookOuDOListItem)) {
            this.saveFinJournalLog(docNum, String.format("\u67e5\u4e0d\u5230\u8d26\u5957\u516c\u53f8,\u4e8b\u4ef6\u8868\u5355\u3010%s\u3011,\u4f1a\u8ba1\u5f15\u64ce\u3010%s\u3011,\u6570\u636e\u884c\u3010%s\u3011,\u5355\u636e\u516c\u53f8\u7f16\u7801\u3010%s\u3011", finAccountEngineDO.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), ouCode));
            return false;
        }
        FinSetOfBookOuDO finSetOfBookOuDOResult = finSetOfBookOuDOListItem.stream().filter(finSetOfBookOuDO -> ouCode.equals(finSetOfBookOuDO.getOuCode())).findFirst().orElse(null);
        if (finSetOfBookOuDOResult == null) {
            this.saveFinJournalLog(docNum, String.format("\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u516c\u53f8\u8d26\u5957\uff0c\u4e8b\u4ef6\u8868\u5355\u3010%s\u3011,\u4f1a\u8ba1\u5f15\u64ce\u3010%s\u3011,\u6570\u636e\u884c\u3010%s\u3011,\u5355\u636e\u516c\u53f8\u7f16\u7801\u3010%s\u3011", finAccountEngineDO.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), ouCode));
            return false;
        }
        return true;
    }

    private FinAccountEngineCustomDO queryData(FinAccountEngineParam finAccountEngineParam) {
        FinAccountEngineDO finAccountEngineDO = this.finAccountEngineRepo.findByIdAndStatus(finAccountEngineParam.getId(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        Assert.notNull((Object)finAccountEngineDO, (String)"\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u4f1a\u8ba1\u5f15\u64ce", (Object[])new Object[0]);
        FinEventTableDO finEventTableDO = this.finEventTableRepo.findByEventTableAndStatus(finAccountEngineDO.getEventTable(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        Assert.notNull((Object)finEventTableDO, (String)"\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u4e8b\u4ef6\u8868\u5355", (Object[])new Object[0]);
        List<FinEventTableLineDO> finEventTableLineDOList = this.finEventTableLineRepo.findAllByMasId(finEventTableDO.getId());
        Assert.notEmpty(finEventTableLineDOList, (String)"\u67e5\u4e0d\u5230\u4e8b\u4ef6\u8868\u5355\u660e\u7ec6", (Object[])new Object[0]);
        List<FinEventTableConditionDO> finEventTableConditionDOList = this.finEventTableConditionRepo.findAllByMasId(finEventTableDO.getId());
        List<FinAccountEngineDetailsDO> finAccountEngineDetailsDOList = this.finAccountEngineDetailsRepo.findAllByMasIdAndActiveFlag(finAccountEngineParam.getId(), Boolean.TRUE).stream().sorted(Comparator.comparing(FinAccountEngineDetailsDO::getSerialNum).reversed()).collect(Collectors.toList());
        Assert.notEmpty(finAccountEngineDetailsDOList, (String)"\u67e5\u4e0d\u5230\u542f\u7528\u7684\u4f1a\u8ba1\u5f15\u64ce\u660e\u7ec6", (Object[])new Object[0]);
        List<Long> finAccountEngineDetailsDOIds = finAccountEngineDetailsDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List<FinAccEngDetConditionDO> finAccEngDetConditionDOList = this.finAccEngDetConditionRepo.findAllByMasIdIn(finAccountEngineDetailsDOIds);
        List<FinAccEngDetDataDO> finAccEngDetDataDOList = this.finAccEngDetDataRepo.findAllByMasIdIn(finAccountEngineDetailsDOIds).stream().sorted(Comparator.comparing(FinAccEngDetDataDO::getSerialNum).reversed()).collect(Collectors.toList());
        Assert.notEmpty(finAccEngDetDataDOList, (String)"\u67e5\u4e0d\u5230\u6570\u636e\u884c\u8be6\u60c5", (Object[])new Object[0]);
        List<Long> finAccEngDetDataDOIds = finAccEngDetDataDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List<FinAccEngDetDataLineDO> finAccEngDetDataLineDOList = this.finAccEngDetDataLineRepo.findAllByMasIdIn(finAccEngDetDataDOIds);
        Assert.notEmpty(finAccEngDetDataLineDOList, (String)"\u67e5\u4e0d\u5230\u6570\u636e\u6620\u5c04", (Object[])new Object[0]);
        List<String> fastCodes = finAccEngDetDataLineDOList.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getFastCode())).map(FinAccEngDetDataLineDO::getFastCode).collect(Collectors.toList());
        List<FinFastCodeDO> finFastCodeDOList = this.finFastCodeRepoProc.findAllByFastCodeInAndStatus(fastCodes, UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<Long> finFastCodeDOIds = finFastCodeDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List<FinFastCodeLineDO> finFastCodeLineDOList = this.finFastCodeLineRepoProc.findByMasIdIn(finFastCodeDOIds);
        List<String> sobCodes = finAccEngDetDataDOList.stream().map(FinAccEngDetDataDO::getSobCode).collect(Collectors.toList());
        List<FinSetOfBookDO> finSetOfBookDOList = this.finSetOfBookRepo.findAllBySobCodeInAndStatus(sobCodes, UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        Assert.notEmpty(finSetOfBookDOList, (String)"\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u5e10\u5957", (Object[])new Object[0]);
        List<Long> finSetOfBookDOIds = finSetOfBookDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List<FinSetOfBookOuDO> finSetOfBookOuDOList = this.finSetOfBookOuRepo.findAllByMasIdIn(finSetOfBookDOIds);
        Assert.notEmpty(finSetOfBookOuDOList, (String)"\u67e5\u4e0d\u5230\u5e10\u5957\u5e10\u5957\u516c\u53f8", (Object[])new Object[0]);
        List<FinSetOfBookLineDO> finSetOfBookLineDOList = this.finSetOfBookLineRepo.findAllByMasIdIn(finSetOfBookDOIds);
        Assert.notEmpty(finSetOfBookLineDOList, (String)"\u67e5\u4e0d\u5230\u5e10\u5957\u660e\u7ec6", (Object[])new Object[0]);
        List<FinSobAccountPeriodDO> finSobAccountPeriodDOList = this.finSobAccountPeriodRepo.findAllByStatus(UdcEnum.ACCOUNT_PERIOD_CONTROL_STATUS_OPEN.getValueCode());
        List<String> flexibleCodes = finSetOfBookLineDOList.stream().filter(finSetOfBookLineDO -> StringUtils.isNotEmpty((CharSequence)finSetOfBookLineDO.getFlexibleCode())).map(FinSetOfBookLineDO::getFlexibleCode).collect(Collectors.toList());
        List<FinFlexibleDO> finFlexibleDOList = this.finFlexibleRepoProc.findAllByFlexibleCodeInAndStatus(flexibleCodes, UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<Long> finSetOfBookLineDOIds = finFlexibleDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List<FinFlexibleValueDO> finFlexibleValueDOList = this.finFlexibleValueRepoProc.findByMasIdInAndValidTime(finSetOfBookLineDOIds, LocalDateTime.now());
        FinAccountEngineCustomDO finAccountEngineCustomDO = new FinAccountEngineCustomDO();
        finAccountEngineCustomDO.setFinAccountEngineDO(finAccountEngineDO);
        finAccountEngineCustomDO.setFinEventTableDO(finEventTableDO);
        finAccountEngineCustomDO.setFinEventTableLineDOList(finEventTableLineDOList);
        finAccountEngineCustomDO.setFinEventTableConditionDOList(finEventTableConditionDOList);
        finAccountEngineCustomDO.setFinAccountEngineDetailsDOList(finAccountEngineDetailsDOList);
        finAccountEngineCustomDO.setFinAccEngDetConditionDOList(finAccEngDetConditionDOList);
        finAccountEngineCustomDO.setFinAccEngDetDataDOList(finAccEngDetDataDOList);
        finAccountEngineCustomDO.setFinAccEngDetDataLineDOList(finAccEngDetDataLineDOList);
        finAccountEngineCustomDO.setFinFastCodeDOList(finFastCodeDOList);
        finAccountEngineCustomDO.setFinFastCodeLineDOList(finFastCodeLineDOList);
        finAccountEngineCustomDO.setFinSetOfBookDOList(finSetOfBookDOList);
        finAccountEngineCustomDO.setFinSetOfBookOuDOList(finSetOfBookOuDOList);
        finAccountEngineCustomDO.setFinSetOfBookLineDOList(finSetOfBookLineDOList);
        finAccountEngineCustomDO.setFinSobAccountPeriodDOList(finSobAccountPeriodDOList);
        finAccountEngineCustomDO.setFinFlexibleDOList(finFlexibleDOList);
        finAccountEngineCustomDO.setFinFlexibleValueDOList(finFlexibleValueDOList);
        return finAccountEngineCustomDO;
    }

    private boolean checkConstant(FinAccEngDetDataLineDO finAccEngDetDataLineDO, String docNum, FinAccountEngineDO finAccountEngineDO, FinAccountEngineDetailsDO finAccountEngineDetailsDO, FinAccEngDetDataDO finAccEngDetDataDO, Map saveMap) {
        if (UdcEnum.SOURCE_TYPE_CONSTANT.getValueCode().equals(finAccEngDetDataLineDO.getSourceType())) {
            if (StringUtils.isEmpty((CharSequence)finAccEngDetDataLineDO.getConstant())) {
                log.info("\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0c\u5904\u7406\u6570\u636e\u6620\u5c04\u5b57\u6bb5\uff0c\u5e38\u6570\u5b57\u6bb5\u9519\u8bef\uff0c\u6620\u5c04\u5b57\u6bb5\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)finAccEngDetDataLineDO));
                this.saveFinJournalLog(docNum, String.format("\u5e38\u6570\u5217\u51fa\u9519\uff0c\u4e8b\u4ef6\u8868\u5355\u3010%s\u3011,\u4f1a\u8ba1\u5f15\u64ce\u3010%s\u3011,\u6570\u636e\u884c\u3010%s\u3011,\u5217\u540d\u79f0\u3010%s\u3011", finAccountEngineDO.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), finAccEngDetDataLineDO.getColumnName()));
                return false;
            }
            this.put(saveMap, finAccEngDetDataLineDO.getColumnName(), finAccEngDetDataLineDO.getConstant(), finAccEngDetDataLineDO);
        }
        return true;
    }

    private boolean checkColumn(FinAccEngDetDataLineDO finAccEngDetDataLineDO, Map result, String docNum, FinAccountEngineDO finAccountEngineDO, FinAccountEngineDetailsDO finAccountEngineDetailsDO, FinAccEngDetDataDO finAccEngDetDataDO, Map saveMap) {
        if (UdcEnum.SOURCE_TYPE_COLUMN.getValueCode().equals(finAccEngDetDataLineDO.getSourceType())) {
            if (!result.containsKey(finAccEngDetDataLineDO.getColumnSource())) {
                log.info("\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0c\u5904\u7406\u6570\u636e\u6620\u5c04\u5b57\u6bb5\uff0c\u5217\u6765\u6e90\u5b57\u6bb5\u9519\u8bef\uff0c\u6620\u5c04\u5b57\u6bb5\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)finAccEngDetDataLineDO));
                this.saveFinJournalLog(docNum, String.format("\u5217\u6765\u6e90\u5b57\u6bb5\u51fa\u9519\uff0c\u4e8b\u4ef6\u8868\u5355\u3010%s\u3011,\u4f1a\u8ba1\u5f15\u64ce\u3010%s\u3011,\u6570\u636e\u884c\u3010%s\u3011,\u5217\u540d\u79f0\u3010%s\u3011", finAccountEngineDO.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), finAccEngDetDataLineDO.getColumnName()));
                return false;
            }
            this.put(saveMap, finAccEngDetDataLineDO.getColumnName(), result.get(finAccEngDetDataLineDO.getColumnSource()) == null ? null : "" + result.get(finAccEngDetDataLineDO.getColumnSource()), finAccEngDetDataLineDO);
        }
        return true;
    }

    private boolean checkFastCode(FinAccEngDetDataLineDO finAccEngDetDataLineDO, FinAccountEngineCustomDO finAccountEngineCustomDO, Map result, String docNum, FinAccountEngineDO finAccountEngineDO, FinAccountEngineDetailsDO finAccountEngineDetailsDO, FinAccEngDetDataDO finAccEngDetDataDO, Map saveMap) {
        if (UdcEnum.SOURCE_TYPE_FAST_CODE.getValueCode().equals(finAccEngDetDataLineDO.getSourceType())) {
            FinFastCodeDO finFastCodeDOResult = finAccountEngineCustomDO.getFinFastCodeDOList().stream().filter(finFastCodeDO -> finFastCodeDO.getFastCode().equals(finAccEngDetDataLineDO.getFastCode())).findFirst().orElse(null);
            if (finFastCodeDOResult == null) {
                this.saveFinJournalLog(docNum, String.format("\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u5feb\u7801\uff0c\u4e8b\u4ef6\u8868\u5355\u3010%s\u3011,\u4f1a\u8ba1\u5f15\u64ce\u3010%s\u3011,\u6570\u636e\u884c\u3010%s\u3011,\u5217\u540d\u79f0\u3010%s\u3011", finAccountEngineDO.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), finAccEngDetDataLineDO.getColumnName()));
                return false;
            }
            List finFastCodeLineDOListItem = finAccountEngineCustomDO.getFinFastCodeLineDOList().stream().filter(finFastCodeLineDO -> finFastCodeDOResult.getId().equals(finFastCodeLineDO.getMasId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(finFastCodeLineDOListItem)) {
                this.saveFinJournalLog(docNum, String.format("\u672a\u67e5\u5230\u5feb\u7801\u660e\u7ec6\uff0c\u4e8b\u4ef6\u8868\u5355\u3010%s\u3011,\u4f1a\u8ba1\u5f15\u64ce\u3010%s\u3011,\u6570\u636e\u884c\u3010%s\u3011,\u5217\u540d\u79f0\u3010%s\u3011", finAccountEngineDO.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), finAccEngDetDataLineDO.getColumnName()));
                return false;
            }
            FinFastCodeLineDO finFastCodeLineDOResult = finFastCodeLineDOListItem.stream().filter(finFastCodeLineDO -> {
                if (StringUtils.isNotEmpty((CharSequence)finFastCodeLineDO.getConditionOne()) && !finFastCodeLineDO.getConditionOneValue().equals(result.get(finFastCodeLineDO.getConditionOne()))) {
                    return false;
                }
                if (StringUtils.isNotEmpty((CharSequence)finFastCodeLineDO.getConditionTwo()) && !finFastCodeLineDO.getConditionTwoValue().equals(result.get(finFastCodeLineDO.getConditionTwo()))) {
                    return false;
                }
                return !StringUtils.isNotEmpty((CharSequence)finFastCodeLineDO.getConditionThree()) || finFastCodeLineDO.getConditionThreeValue().equals(result.get(finFastCodeLineDO.getConditionThree()));
            }).findFirst().orElse(null);
            if (finFastCodeLineDOResult == null) {
                log.info("\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0c\u5904\u7406\u6570\u636e\u6620\u5c04\u5b57\u6bb5\uff0c\u5feb\u7801\u5b57\u6bb5\u9519\u8bef\uff0c\u6620\u5c04\u5b57\u6bb5\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)finAccEngDetDataLineDO));
                this.saveFinJournalLog(docNum, String.format("\u5feb\u7801\u51fa\u9519\uff0c\u4e8b\u4ef6\u8868\u5355\u3010%s\u3011,\u4f1a\u8ba1\u5f15\u64ce\u3010%s\u3011,\u6570\u636e\u884c\u3010%s\u3011,\u5217\u540d\u79f0\u3010%s\u3011", finAccountEngineDO.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), finAccEngDetDataLineDO.getColumnName()));
                return false;
            }
            if ("\u8f93\u51fa1".equals(finAccEngDetDataLineDO.getOutputColumn())) {
                saveMap.put(finAccEngDetDataLineDO.getColumnName(), "'" + finFastCodeLineDOResult.getOutputOne() + "'");
            }
            if ("\u8f93\u51fa2".equals(finAccEngDetDataLineDO.getOutputColumn())) {
                saveMap.put(finAccEngDetDataLineDO.getColumnName(), "'" + finFastCodeLineDOResult.getOutputTwo() + "'");
            }
            if ("\u8f93\u51fa3".equals(finAccEngDetDataLineDO.getOutputColumn())) {
                saveMap.put(finAccEngDetDataLineDO.getColumnName(), "'" + finFastCodeLineDOResult.getOutputThree() + "'");
            }
        }
        return true;
    }

    private boolean checkFlexible(FinAccEngDetDataLineDO finAccEngDetDataLineDO, FinAccountEngineCustomDO finAccountEngineCustomDO, String docNum, FinAccountEngineDO finAccountEngineDO, FinAccountEngineDetailsDO finAccountEngineDetailsDO, FinAccEngDetDataDO finAccEngDetDataDO, Map saveMap) {
        if (UdcEnum.SOURCE_TYPE_FLEXIBLE.getValueCode().equals(finAccEngDetDataLineDO.getSourceType())) {
            FinFlexibleValueDO finFlexibleValueDOResult = finAccountEngineCustomDO.getFinFlexibleValueDOList().stream().filter(finFlexibleValueDO -> finFlexibleValueDO.getFlexibleValueCode().equals(finAccEngDetDataLineDO.getFlexibleCode())).findFirst().orElse(null);
            if (finFlexibleValueDOResult == null) {
                log.info("\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0c\u5904\u7406\u6570\u636e\u6620\u5c04\u5b57\u6bb5\uff0c\u503c\u96c6\u5b57\u6bb5\u9519\u8bef\uff0c\u6620\u5c04\u5b57\u6bb5\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)finAccEngDetDataLineDO));
                this.saveFinJournalLog(docNum, String.format("\u67e5\u4e0d\u5230\u6709\u6548\u7684\u503c\u96c6\u660e\u7ec6,\u4e8b\u4ef6\u8868\u5355\u3010%s\u3011,\u4f1a\u8ba1\u5f15\u64ce\u3010%s\u3011,\u6570\u636e\u884c\u3010%s\u3011,\u5217\u540d\u79f0\u3010%s\u3011", finAccountEngineDO.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), finAccEngDetDataLineDO.getColumnName()));
                return false;
            }
            this.put(saveMap, finAccEngDetDataLineDO.getColumnName(), finFlexibleValueDOResult.getFlexibleValueName(), finAccEngDetDataLineDO);
        }
        return true;
    }

    private boolean checkAccountPeriod(FinAccEngDetDataLineDO finAccEngDetDataLineDO, Map result, FinAccountEngineCustomDO finAccountEngineCustomDO, String ouCode, String docNum, FinAccountEngineDO finAccountEngineDO, FinAccountEngineDetailsDO finAccountEngineDetailsDO, FinAccEngDetDataDO finAccEngDetDataDO, Map saveMap) {
        if (UdcEnum.SOURCE_TYPE_ACCOUNT_PERIOD.getValueCode().equals(finAccEngDetDataLineDO.getSourceType())) {
            if (result.get(finAccEngDetDataLineDO.getColumnSource()) == null) {
                this.saveFinJournalLog(docNum, String.format("\u4f1a\u8ba1\u671f\u95f4\u4e3a\u7a7a,\u4e8b\u4ef6\u8868\u5355\u3010%s\u3011,\u4f1a\u8ba1\u5f15\u64ce\u3010%s\u3011,\u6570\u636e\u884c\u3010%s\u3011,\u5217\u540d\u79f0\u3010%s\u3011", finAccountEngineDO.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), finAccEngDetDataLineDO.getColumnName()));
                return false;
            }
            LocalDateTime localDateTime = (LocalDateTime)result.get(finAccEngDetDataLineDO.getColumnSource());
            String sobCode = finAccEngDetDataDO.getSobCode();
            FinSetOfBookDO finSetOfBookDOResult = finAccountEngineCustomDO.getFinSetOfBookDOList().stream().filter(finSetOfBookDO -> finSetOfBookDO.getSobCode().equals(sobCode)).findFirst().orElse(null);
            if (finSetOfBookDOResult == null) {
                this.saveFinJournalLog(docNum, String.format("\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u8d26\u5957,\u4e8b\u4ef6\u8868\u5355\u3010%s\u3011,\u4f1a\u8ba1\u5f15\u64ce\u3010%s\u3011,\u6570\u636e\u884c\u3010%s\u3011,\u5217\u540d\u79f0\u3010%s\u3011", finAccountEngineDO.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), finAccEngDetDataLineDO.getColumnName()));
                return false;
            }
            FinSobAccountPeriodDO finSobAccountPeriodDOResult = finAccountEngineCustomDO.getFinSobAccountPeriodDOList().stream().filter(finSobAccountPeriodDO -> finSetOfBookDOResult.getSobCode().equals(finSobAccountPeriodDO.getSobCode()) && ouCode.equals(finSobAccountPeriodDO.getOuCode()) && UdcEnum.ACCOUNT_PERIOD_CONTROL_STATUS_OPEN.getValueCode().equals(finSobAccountPeriodDO.getStatus()) && localDateTime.compareTo(finSobAccountPeriodDO.getActiveStartTime()) >= 0 && localDateTime.compareTo(finSobAccountPeriodDO.getActiveEndTime()) <= 0).findFirst().orElse(null);
            if (finSobAccountPeriodDOResult == null) {
                log.info("\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0c\u5904\u7406\u6570\u636e\u6620\u5c04\u5b57\u6bb5\uff0c\u4f1a\u8ba1\u671f\u95f4\u5b57\u6bb5\u9519\u8bef\uff0c\u6620\u5c04\u5b57\u6bb5\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)finAccEngDetDataLineDO));
                this.saveFinJournalLog(docNum, String.format("\u4f1a\u8ba1\u671f\u95f4\u51fa\u9519,\u4e8b\u4ef6\u8868\u5355\u3010%s\u3011,\u4f1a\u8ba1\u5f15\u64ce\u3010%s\u3011,\u6570\u636e\u884c\u3010%s\u3011,\u5217\u540d\u79f0\u3010%s\u3011", finAccountEngineDO.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), finAccEngDetDataLineDO.getColumnName()));
                return false;
            }
            this.put(saveMap, finAccEngDetDataLineDO.getColumnName(), finSobAccountPeriodDOResult.getPeriodStyle(), finAccEngDetDataLineDO);
        }
        return true;
    }

    private boolean checkDebtAndCreditSumEqual(List<Map> dataList, JournalLogInfo journalLogInfo) {
        if (CollectionUtils.isEmpty(dataList)) {
            return true;
        }
        BigDecimal debit_amt = BigDecimal.ZERO;
        BigDecimal credit_amt = BigDecimal.ZERO;
        BigDecimal debit_cur_amt = BigDecimal.ZERO;
        BigDecimal credit_cur_amt = BigDecimal.ZERO;
        for (Map data : dataList) {
            if (data.get("debit_amt") == null || data.get("credit_amt") == null || data.get("debit_cur_amt") == null || data.get("credit_cur_amt") == null) {
                log.info("\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0c\u6821\u9a8c\u501f\u65b9\u3001\u8d37\u65b9\u91d1\u989d\u662f\u5426\u76f8\u7b49\u5931\u8d25\uff0c\u5b58\u5728\u503c\u4e3a\u7a7a\u7684\u91d1\u989d\u5b57\u6bb5\uff0c\u6570\u636e\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)data));
                this.saveFinJournalLog(journalLogInfo.getDocNum(), String.format("{},{},{}\u4f1a\u8ba1\u671f\u95f4\u51fa\u9519", journalLogInfo.getEventTable(), journalLogInfo.getAccountEngine(), journalLogInfo.getDetDataName()));
                return false;
            }
            debit_amt.add((BigDecimal)data.get("debit_amt"));
            credit_amt.add((BigDecimal)data.get("credit_amt"));
            debit_cur_amt.add((BigDecimal)data.get("debit_cur_amt"));
            credit_cur_amt.add((BigDecimal)data.get("credit_cur_amt"));
        }
        if (debit_amt.compareTo(credit_amt) != 0 || debit_cur_amt.compareTo(credit_cur_amt) != 0) {
            log.info("\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0c\u6821\u9a8c\u501f\u65b9\u3001\u8d37\u65b9\u91d1\u989d\u662f\u5426\u76f8\u7b49\u5931\u8d25\uff0c\u501f\u65b9\u548c\u8d37\u65b9\u91d1\u989d\u4e0d\u76f8\u7b49");
            this.saveFinJournalLog(journalLogInfo.getDocNum(), String.format("{},{},{}\u4f1a\u8ba1\u671f\u95f4\u51fa\u9519", journalLogInfo.getEventTable(), journalLogInfo.getAccountEngine(), journalLogInfo.getDetDataName()));
            return false;
        }
        return true;
    }

    private void checkGenerateJournalParam(FinAccountEngineParam finAccountEngineParam) {
        Assert.notNull((Object)finAccountEngineParam.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void put(Map map, String key, String value, FinAccEngDetDataLineDO finAccEngDetDataLineDO) {
        if (StringUtils.isBlank((CharSequence)finAccEngDetDataLineDO.getColumnType())) {
            map.put(key, "'" + value + "'");
        } else if (finAccEngDetDataLineDO.getColumnType().trim().equals("varchar")) {
            map.put(key, "'" + value + "'");
        } else if (finAccEngDetDataLineDO.getColumnType().trim().equals("decimal")) {
            map.put(key, BigDecimal.valueOf(Double.valueOf(value)));
        } else if (finAccEngDetDataLineDO.getColumnType().trim().equals("datetime")) {
            map.put(key, "'" + value + "'");
        } else if (finAccEngDetDataLineDO.getColumnType().trim().equals("bigint")) {
            map.put(key, Long.valueOf(value));
        } else if (finAccEngDetDataLineDO.getColumnType().trim().equals("int")) {
            map.put(key, Integer.valueOf(value));
        }
    }

    private void saveFinJournal(FinAccountEngineParam finAccountEngineParam, List<Map> saveMapList) {
        if (CollectionUtils.isEmpty(saveMapList)) {
            return;
        }
        FinAccountEngineDO finAccountEngineDO = this.finAccountEngineRepo.findAllById(finAccountEngineParam.getId());
        Assert.notNull((Object)finAccountEngineDO, (String)"\u67e5\u4e0d\u5230\u4f1a\u8ba1\u5f15\u64ce", (Object[])new Object[0]);
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            connection = DriverManager.getConnection(String.format("jdbc:mysql://%s:%s/%s", finAccountEngineDO.getJournalHost(), finAccountEngineDO.getJournalPort(), finAccountEngineDO.getJournalDatabase()), finAccountEngineDO.getJournalUser(), finAccountEngineDO.getJournalPassword());
            long tenantId = -1L;
            if (this.tenantClientProvider.getCurrentTenant() != null) {
                tenantId = this.tenantClientProvider.getCurrentTenant().getId();
            }
            long finalTenantId = tenantId;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (CollectionUtils.isNotEmpty(saveMapList)) {
                saveMapList.stream().forEach(v -> v.put("tenant_id", finalTenantId));
                saveMapList.stream().forEach(v -> v.put("create_user_id", -1));
                saveMapList.stream().forEach(v -> v.put("create_time", "'" + df.format(new Date()) + "'"));
                saveMapList.stream().forEach(v -> v.put("creator", "'\u7cfb\u7edf\u81ea\u52a8'"));
            }
            Map<Object, List<Map>> detDataIdMap = saveMapList.stream().collect(Collectors.groupingBy(v -> v.get("detDataId")));
            for (Object key : detDataIdMap.keySet()) {
                List<Map> maps = detDataIdMap.get(key);
                maps.stream().forEach(v -> v.remove("detDataId"));
                String sql = this.buildSql(finAccountEngineDO, maps);
                log.info("\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1,\u63d2\u5165\u4f1a\u8ba1\u5206\u5f55sql: " + sql);
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.execute();
            }
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String buildSql(FinAccountEngineDO finAccountEngineDO, List<Map> saveMapList) {
        List values = saveMapList.stream().map(map -> "(".concat(StringUtils.join(map.values(), (String)",")).concat(")")).collect(Collectors.toList());
        String sql = "insert".concat(" ").concat("into").concat(" ").concat(finAccountEngineDO.getJournalTable()).concat(" ").concat("(").concat(StringUtils.join(saveMapList.get(0).keySet(), (String)",")).concat(")").concat(" ").concat("values").concat(StringUtils.join(values, (String)","));
        return sql;
    }

    private void saveFinJournalLog(String docNum, String log) {
        FinJournalLogDO finJournalLogDo = new FinJournalLogDO();
        finJournalLogDo.setDocNum(docNum);
        finJournalLogDo.setLog(log);
        this.finJournalLogRepo.save(finJournalLogDo);
    }

    private void saveFinJournalLogNew(JournalLogInfo journalLogInfo) {
        String docNum = journalLogInfo.getDocNum();
        String formatMsg = String.format("{},\u4e8b\u4ef6\u8868\u5355\u3010%s\u3011,\u4f1a\u8ba1\u5f15\u64ce\u3010%s\u3011,\u6570\u636e\u884c\u3010%s\u3011,\u5217\u540d\u79f0\u3010%s\u3011", journalLogInfo.getErrMsg(), journalLogInfo.getEventTable(), journalLogInfo.getAccountEngine(), journalLogInfo.getDetDataName(), journalLogInfo.getColumnName());
        FinJournalLogDO finJournalLogDo = new FinJournalLogDO();
        finJournalLogDo.setDocNum(docNum);
        finJournalLogDo.setLog(formatMsg);
        this.finJournalLogRepo.save(finJournalLogDo);
    }

    public FinAccountEngineServiceImpl(FinAccountEngineRepo finAccountEngineRepo, FinAccountEngineRepoProc finAccountEngineRepoProc, FinAccountEngineDetailsRepo finAccountEngineDetailsRepo, FinAccEngDetConditionRepo finAccEngDetConditionRepo, FinAccEngDetDataRepo finAccEngDetDataRepo, FinAccEngDetDataLineRepo finAccEngDetDataLineRepo, FinEventTableRepo finEventTableRepo, FinEventTableLineRepo finEventTableLineRepo, FinEventTableConditionRepo finEventTableConditionRepo, FinJournalLogService finJournalLogService, FinJournalLogRepo finJournalLogRepo, FinSetOfBookOuRepo finSetOfBookOuRepo, FinSetOfBookRepo finSetOfBookRepo, FinSetOfBookRepoProc finSetOfBookRepoProc, FinSetOfBookLineRepo finSetOfBookLineRepo, FinFastCodeRepo finFastCodeRepo, FinFastCodeLineRepo finFastCodeLineRepo, FinFastCodeLineRepoProc finFastCodeLineRepoProc, FinFastCodeRepoProc finFastCodeRepoProc, FinFlexibleRepo finFlexibleRepo, FinFlexibleRepoProc finFlexibleRepoProc, FinFlexibleValueRepo finFlexibleValueRepo, FinFlexibleValueRepoProc finFlexibleValueRepoProc, FinSobAccountPeriodRepo finSobAccountPeriodRepo, FinJournalRepo finJournalRepo, UdcProvider udcProvider, TenantClientProvider tenantClientProvider) {
        this.finAccountEngineRepo = finAccountEngineRepo;
        this.finAccountEngineRepoProc = finAccountEngineRepoProc;
        this.finAccountEngineDetailsRepo = finAccountEngineDetailsRepo;
        this.finAccEngDetConditionRepo = finAccEngDetConditionRepo;
        this.finAccEngDetDataRepo = finAccEngDetDataRepo;
        this.finAccEngDetDataLineRepo = finAccEngDetDataLineRepo;
        this.finEventTableRepo = finEventTableRepo;
        this.finEventTableLineRepo = finEventTableLineRepo;
        this.finEventTableConditionRepo = finEventTableConditionRepo;
        this.finJournalLogService = finJournalLogService;
        this.finJournalLogRepo = finJournalLogRepo;
        this.finSetOfBookOuRepo = finSetOfBookOuRepo;
        this.finSetOfBookRepo = finSetOfBookRepo;
        this.finSetOfBookRepoProc = finSetOfBookRepoProc;
        this.finSetOfBookLineRepo = finSetOfBookLineRepo;
        this.finFastCodeRepo = finFastCodeRepo;
        this.finFastCodeLineRepo = finFastCodeLineRepo;
        this.finFastCodeLineRepoProc = finFastCodeLineRepoProc;
        this.finFastCodeRepoProc = finFastCodeRepoProc;
        this.finFlexibleRepo = finFlexibleRepo;
        this.finFlexibleRepoProc = finFlexibleRepoProc;
        this.finFlexibleValueRepo = finFlexibleValueRepo;
        this.finFlexibleValueRepoProc = finFlexibleValueRepoProc;
        this.finSobAccountPeriodRepo = finSobAccountPeriodRepo;
        this.finJournalRepo = finJournalRepo;
        this.udcProvider = udcProvider;
        this.tenantClientProvider = tenantClientProvider;
    }

    static class JournalLogInfo {
        private String docNum;
        private String eventTable;
        private String accountEngine;
        private String detDataName;
        private String columnName;
        private String errMsg;

        public String getDocNum() {
            return this.docNum;
        }

        public void setDocNum(String docNum) {
            this.docNum = docNum;
        }

        public String getEventTable() {
            return this.eventTable;
        }

        public void setEventTable(String eventTable) {
            this.eventTable = eventTable;
        }

        public String getAccountEngine() {
            return this.accountEngine;
        }

        public void setAccountEngine(String accountEngine) {
            this.accountEngine = accountEngine;
        }

        public String getDetDataName() {
            return this.detDataName;
        }

        public void setDetDataName(String detDataName) {
            this.detDataName = detDataName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getErrMsg() {
            return this.errMsg;
        }

        public void setErrMsg(String errMsg) {
            this.errMsg = errMsg;
        }

        public JournalLogInfo(String docNum, String eventTable, String accountEngine) {
            this.docNum = docNum;
            this.eventTable = eventTable;
            this.accountEngine = accountEngine;
        }
    }
}

