/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.limitadjustorder;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.cloudt.apm.common.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.limitadjustorder.LimitAdjustOrderConvert;
import com.elitesland.fin.application.facade.base.BaseModelDTO;
import com.elitesland.fin.application.facade.dto.limitadjustorder.LimitAdjustOrderDTO;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.param.limitadjustorder.LimitAdjustOrderParam;
import com.elitesland.fin.application.facade.vo.limitadjustorder.LimitAdjustOrderVO;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;
import com.elitesland.fin.application.service.limitadjustorder.LimitAdjustOrderService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.common.SysNumEnum;
import com.elitesland.fin.common.SysNumberGenerator;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.limitadjustorder.LimitAdjustOrderDO;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import com.elitesland.fin.repo.creditaccountflow.CreditAccountFlowRepo;
import com.elitesland.fin.repo.limitadjustorder.LimitAdjustOrderRepo;
import com.elitesland.fin.repo.limitadjustorder.LimitAdjustOrderRepoProc;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class LimitAdjustOrderServiceImpl
implements LimitAdjustOrderService {
    private static final Logger log = LoggerFactory.getLogger(LimitAdjustOrderServiceImpl.class);
    private final LimitAdjustOrderRepo limitAdjustOrderRepo;
    private final LimitAdjustOrderRepoProc limitAdjustOrderRepoProc;
    private final SysNumberGenerator sysNumberGenerator;
    private final WorkflowRpcService workflowRpcService;
    private final JPAQueryFactory jpaQueryFactory;
    private final CreditAccountFlowService creditAccountFlowService;
    private final CreditAccountFlowRepo creditAccountFlowRepo;
    private final CreditAccountRepo creditAccountRepo;
    private final CreditAccountRepoProc creditAccountRepoProc;
    private final TransactionTemplate transactionTemplate;

    @Override
    @SysCodeProc
    public PagingVO<LimitAdjustOrderVO> page(LimitAdjustOrderParam limitAdjustOrderParam) {
        return LimitAdjustOrderConvert.INSTANCE.limitAdjustOrderDTOPagingVO2LimitAdjustOrderVOPagingVO(this.limitAdjustOrderRepoProc.page(limitAdjustOrderParam));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdate(LimitAdjustOrderParam limitAdjustOrderParam) {
        this.checkSave(limitAdjustOrderParam);
        if (limitAdjustOrderParam.getId() == null) {
            LimitAdjustOrderDO limitAdjustOrderDO = LimitAdjustOrderConvert.INSTANCE.limitAdjustOrderParam2LimitAdjustOrderDO(limitAdjustOrderParam);
            limitAdjustOrderDO.setWorkflowProcInstStatus(ProcInstStatus.NOTSUBMIT);
            limitAdjustOrderDO.setDocState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
            limitAdjustOrderDO.setDocNo(this.sysNumberGenerator.generate(SysNumEnum.FIN_ADJ_ORDER.getCode()));
            this.limitAdjustOrderRepo.save((Object)limitAdjustOrderDO);
            return limitAdjustOrderDO.getId();
        }
        LimitAdjustOrderDO limitAdjustOrderDO = this.limitAdjustOrderRepoProc.findById(limitAdjustOrderParam.getId());
        this.checkAdjustOrderState(limitAdjustOrderDO);
        LimitAdjustOrderConvert.INSTANCE.limitAdjustOrderParam2LimitAdjustOrderDO(limitAdjustOrderParam, limitAdjustOrderDO);
        return limitAdjustOrderDO.getId();
    }

    @Override
    public void submit(Long id) {
        LimitAdjustOrderDO limitAdjustOrderDO = this.limitAdjustOrderRepoProc.findById(id);
        ArrayList<String> flowNos = new ArrayList<String>();
        if (!StrUtil.equals((CharSequence)limitAdjustOrderDO.getDocState(), (CharSequence)UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
            throw new BusinessException("\u8c03\u6574\u5355\u4e0d\u5904\u4e8e\u5f85\u63d0\u4ea4\u72b6\u6001\uff0c\u8bf7\u52ff\u63d0\u4ea4");
        }
        if (StrUtil.equals((CharSequence)limitAdjustOrderDO.getAdjustType(), (CharSequence)UdcEnum.ADJUST_TYPE_2.getValueCode())) {
            CreditAccountFlowParam creditAccountFlowParam = this.buildCreditAccountFlowParam(limitAdjustOrderDO, UdcEnum.APPLY_STATUS_DOING.getValueCode());
            String flowNo = this.creditAccountFlowService.generateCreditAccountFlow(creditAccountFlowParam);
            flowNos.add(flowNo);
        }
        try {
            this.workFlow(limitAdjustOrderDO);
        }
        catch (Exception e) {
            log.error("\u4fe1\u7528\u8c03\u6574\u5355\u8c03\u7528\u5de5\u4f5c\u6d41\u5f02\u5e38,\u53c2\u6570\uff1a{}\uff0c\u539f\u56e0\uff1a {}", (Object)limitAdjustOrderDO, (Object)e.getMessage());
            if (StrUtil.equals((CharSequence)limitAdjustOrderDO.getAdjustType(), (CharSequence)UdcEnum.ADJUST_TYPE_2.getValueCode())) {
                CreditAccountFlowParam creditAccountFlowParam = this.buildCreditAccountFlowParam(limitAdjustOrderDO, UdcEnum.APPLY_STATUS_REJECTED.getValueCode());
                String backFlowNo = this.creditAccountFlowService.generateCreditAccountFlow(creditAccountFlowParam);
                flowNos.add(backFlowNo);
                this.creditAccountFlowRepo.deleteByFlowNos(flowNos);
            }
            throw new BusinessException(e.getMessage());
        }
    }

    private void checkAdjustOrderState(LimitAdjustOrderDO limitAdjustOrderDO) {
        Assert.equals((Object)limitAdjustOrderDO.getDocState(), (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode(), (String)"\u5f53\u524d\u72b6\u6001\u65e0\u6cd5\u7f16\u8f91", (Object[])new Object[0]);
    }

    private CreditAccountFlowParam buildCreditAccountFlowParam(LimitAdjustOrderDO limitAdjustOrderDO, String docStatus) {
        CreditAccountFlowParam creditAccountFlowParam = new CreditAccountFlowParam();
        creditAccountFlowParam.setSourceNo(limitAdjustOrderDO.getDocNo());
        creditAccountFlowParam.setSourceId(limitAdjustOrderDO.getId());
        creditAccountFlowParam.setSourceDoc(UdcEnum.DOC_CLS_AO.getValueCode());
        creditAccountFlowParam.setSourceDocType(UdcEnum.ADJUST_TYPE_2.getValueCode());
        creditAccountFlowParam.setSourceDocStatus(docStatus);
        creditAccountFlowParam.setSourceDocAmount(limitAdjustOrderDO.getAdjustLimit());
        creditAccountFlowParam.setCreditAccountCode(limitAdjustOrderDO.getCreditAccountCode());
        return creditAccountFlowParam;
    }

    private void checkSave(LimitAdjustOrderParam limitadjustOrderParam) {
        Assert.notEmpty((CharSequence)limitadjustOrderParam.getAdjustType(), (String)"\u8c03\u6574\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)limitadjustOrderParam.getAdjustReason(), (String)"\u8c03\u6574\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)limitadjustOrderParam.getCreditAccountName(), (String)"\u4fe1\u7528\u8d26\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)limitadjustOrderParam.getCreditAccountCode(), (String)"\u4fe1\u7528\u8d26\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notNull((Object)limitadjustOrderParam.getAdjustLimit(), (String)"\u8c03\u6574\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        if (limitadjustOrderParam.getAdjustLimit().compareTo(BigDecimal.ZERO) <= 0) {
            throw new BusinessException("\u8c03\u6574\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u6216\u7b49\u4e8e0");
        }
    }

    public void workFlow(LimitAdjustOrderDO limitAdjustOrderDO) {
        String docNo = limitAdjustOrderDO.getDocNo();
        if (limitAdjustOrderDO.getWorkflowProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(limitAdjustOrderDO.getWorkflowProcInstStatus())) {
            String procInstName = "\u4fe1\u7528\u8c03\u6574\u5355\u7533\u8bf7(" + docNo + ")\u5ba1\u6279";
            String businessKey = docNo + "#" + limitAdjustOrderDO.getId();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(WorkFlowDefKey.FIN_CREDIT_ADJUST.name(), procInstName, businessKey, new HashMap<String, Object>());
            this.limitAdjustOrderRepoProc.updateWorkflow(limitAdjustOrderDO, processInfo);
        }
    }

    @Override
    public void expireLimitAdjustOrder() {
        LimitAdjustOrderParam limitAdjustOrderParam = new LimitAdjustOrderParam();
        limitAdjustOrderParam.setCreditType(UdcEnum.CREDIT_TYPE_2.getValueCode());
        limitAdjustOrderParam.setDocState(UdcEnum.APPLY_STATUS_ACTIVE.getValueCode());
        limitAdjustOrderParam.setCurrentTime(LocalDateTime.now());
        List<LimitAdjustOrderDTO> limitAdjustOrderDTOList = this.limitAdjustOrderRepoProc.queryByParam(limitAdjustOrderParam);
        if (CollectionUtils.isNotEmpty(limitAdjustOrderDTOList)) {
            limitAdjustOrderDTOList.stream().forEach(item -> {
                CreditAccountFlowParam creditAccountFlowParam = this.buildCreditAccountFlowParam((LimitAdjustOrderDTO)item, UdcEnum.APPLY_STATUS_EXPIRED.getValueCode());
                this.creditAccountFlowService.generateCreditAccountFlow(creditAccountFlowParam);
            });
            limitAdjustOrderParam.setIds(limitAdjustOrderDTOList.stream().map(BaseModelDTO::getId).collect(Collectors.toList()));
            limitAdjustOrderParam.setDocState(UdcEnum.APPLY_STATUS_EXPIRED.getValueCode());
            this.limitAdjustOrderRepoProc.updateDocStateByIds(limitAdjustOrderParam);
        }
    }

    @Override
    public void activeLimitAdjustOrder() {
        LimitAdjustOrderParam limitAdjustOrderParam = new LimitAdjustOrderParam();
        limitAdjustOrderParam.setDocState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        limitAdjustOrderParam.setCurrEffectiveTime(LocalDateTime.now());
        List<LimitAdjustOrderDTO> limitAdjustOrderDTOList = this.limitAdjustOrderRepoProc.queryByParam(limitAdjustOrderParam);
        if (CollectionUtils.isNotEmpty(limitAdjustOrderDTOList)) {
            limitAdjustOrderDTOList.stream().forEach(item -> {
                CreditAccountFlowParam creditAccountFlowParam = this.buildCreditAccountFlowParam((LimitAdjustOrderDTO)item, UdcEnum.APPLY_STATUS_ACTIVE.getValueCode());
                this.creditAccountFlowService.generateCreditAccountFlow(creditAccountFlowParam);
            });
            limitAdjustOrderParam.setIds(limitAdjustOrderDTOList.stream().map(BaseModelDTO::getId).collect(Collectors.toList()));
            limitAdjustOrderParam.setDocState(UdcEnum.APPLY_STATUS_ACTIVE.getValueCode());
            this.limitAdjustOrderRepoProc.updateDocStateByIds(limitAdjustOrderParam);
        }
    }

    private CreditAccountFlowParam buildCreditAccountFlowParam(LimitAdjustOrderDTO limitAdjustOrderDTO, String sourceDocStatus) {
        CreditAccountFlowParam creditAccountFlowParam = new CreditAccountFlowParam();
        creditAccountFlowParam.setSourceNo(limitAdjustOrderDTO.getDocNo());
        creditAccountFlowParam.setSourceId(limitAdjustOrderDTO.getId());
        creditAccountFlowParam.setSourceDoc(UdcEnum.DOC_CLS_AO.getValueCode());
        creditAccountFlowParam.setSourceDocType(limitAdjustOrderDTO.getAdjustType());
        creditAccountFlowParam.setSourceDocStatus(sourceDocStatus);
        creditAccountFlowParam.setSourceDocAmount(limitAdjustOrderDTO.getAdjustLimit());
        creditAccountFlowParam.setCreditAccountCode(limitAdjustOrderDTO.getCreditAccountCode());
        return creditAccountFlowParam;
    }

    public LimitAdjustOrderServiceImpl(LimitAdjustOrderRepo limitAdjustOrderRepo, LimitAdjustOrderRepoProc limitAdjustOrderRepoProc, SysNumberGenerator sysNumberGenerator, WorkflowRpcService workflowRpcService, JPAQueryFactory jpaQueryFactory, CreditAccountFlowService creditAccountFlowService, CreditAccountFlowRepo creditAccountFlowRepo, CreditAccountRepo creditAccountRepo, CreditAccountRepoProc creditAccountRepoProc, TransactionTemplate transactionTemplate) {
        this.limitAdjustOrderRepo = limitAdjustOrderRepo;
        this.limitAdjustOrderRepoProc = limitAdjustOrderRepoProc;
        this.sysNumberGenerator = sysNumberGenerator;
        this.workflowRpcService = workflowRpcService;
        this.jpaQueryFactory = jpaQueryFactory;
        this.creditAccountFlowService = creditAccountFlowService;
        this.creditAccountFlowRepo = creditAccountFlowRepo;
        this.creditAccountRepo = creditAccountRepo;
        this.creditAccountRepoProc = creditAccountRepoProc;
        this.transactionTemplate = transactionTemplate;
    }
}

