package com.elitesland.fin.application.facade.vo.accountreport;


import com.elitesland.fin.application.facade.base.BaseModelParam;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */

@Data
@ApiModel(description = "账户报表")
public class AccountReportVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -6084527411643768273L;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("主客户编码")
    private String custCode;

    @ApiModelProperty("主客户名称")
    private String custName;

    @ApiModelProperty("可用金额")
    private BigDecimal availableAmount;

    @ApiModelProperty("未汇款金额")
    private BigDecimal unremittedAmount;

    @ApiModelProperty("账户额度")
    private BigDecimal creditAccountLimit;

    @ApiModelProperty("账户使用额度")
    private BigDecimal creditAccountUsedLimit;

    @ApiModelProperty("占用额度")
    private BigDecimal creditAccountOccupancyLimit;

    @ApiModelProperty("可用额度")
    private BigDecimal creditAccountAvailableLimit;

    @ApiModelProperty("储值账户金额")
    private BigDecimal storageAccountAmount;

    @ApiModelProperty("储值账户占用金额")
    private BigDecimal storageAccountOccupancyAmount;

    @ApiModelProperty("储值账户可用金额")
    private BigDecimal storageAccountAvailableAmount;

    @ApiModelProperty("返利账户金额")
    private BigDecimal rebateAccountAmount;

    @ApiModelProperty("返利账户占用金额")
    private BigDecimal rebateAccountOccupancyAmount;

    @ApiModelProperty("返利账户可用金额")
    private BigDecimal rebateAccountAvailableAmount;
}
