package com.elitesland.fin.application.facade.vo.recorder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/13 11:16
 */
@Data
public class RecOrderVO implements Serializable {

    private static final long serialVersionUID = 5946723129761085196L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("销售公司编码")
    private String ouCode;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("销售公司ID")
    private Long ouId;

    @ApiModelProperty("销售公司名称")
    private String ouName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("应收单类型定义ID")
    private Long arTypeId;

    @ApiModelProperty("应收单类型名称")
    private String arTypeName;

    @ApiModelProperty("应收单类型代码")
    private String arTypeCode;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("收款单类型ID")
    private Long recTypeId;

    @ApiModelProperty("收款单类型代码")
    private String recTypeCode;

    @ApiModelProperty("收款单类型名称")
    private String recTypeName;

    @ApiModelProperty("收款单号")
    private String recOrderNo;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("本位币编码")
    private String localCurrCode;

    @ApiModelProperty("本位币名称")
    private String localCurrName;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-supp", mod = "APPLY_STATUS")
    private String orderState;
    private String orderStateName;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("实际收款金额")
    private BigDecimal realRecAmt;

    @ApiModelProperty("实际收款金额(本位币)")
    private BigDecimal realRecCurAmt;

    @ApiModelProperty("收款日期")
    private LocalDateTime reDate;

    @ApiModelProperty("是否预收")
    private Boolean reFlag;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejection;

    @ApiModelProperty("单据来源")
    @SysCode(sys = "yst-fin", mod = "REC_DOC_CLS")
    private String createMode;
    private String createModeName;

    @ApiModelProperty("核销状态")
    @SysCode(sys = "yst-fin", mod = "VERIFY_STATUS")
    private String verState;
    private String verStateName;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("销售部门ID")
    private Long buId;

    @ApiModelProperty("销售部门编码")
    private String buCode;

    @ApiModelProperty("销售部门名称")
    private String buName;

    @ApiModelProperty("收款公司编码")
    private String recOuCode;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("收款公司ID")
    private Long recOuId;

    @ApiModelProperty("收款公司名称")
    private String recOuName;

    @ApiModelProperty("销售组织编码")
    private String orgCode;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("销售组织ID")
    private Long orgId;

    @ApiModelProperty("销售组织名称")
    private String orgName;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("单据类型")
    private String recOrderType;
    private String recOrderTypeName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("销售业务员ID")
    private Long saleUserId;

    @ApiModelProperty("销售业务员")
    private String saleUser;

    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("创建人")
    private String creator;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("创建人ID")
    private Long createUserId;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("修改人")
    private String updater;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("具体订单场景")
    private String docType;

    @ApiModelProperty("B端订单/C端订单")
    private String docType2;

    @ApiModelProperty("SO代表正向RSO代表退货负向")
    private String docCls;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("明细信息")
    private List<RecOrderDtlVO> dtlVOList;

    @ApiModelProperty("地址号")
    private String addrNo;

    @ApiModelProperty("供应商地址号")
    private String suppAddrNo;

    @ApiModelProperty("支付凭证")
    private String applyFile;

    @ApiModelProperty("扩展表关联字段")
    private Long relateId;
}
