package com.elitesland.fin.application.service.flowrepair;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.flowrepair.CreditAccountFlowRepairPageParam;
import com.elitesland.fin.application.facade.param.flowrepair.CreditAccountFlowRepairParam;
import com.elitesland.fin.application.facade.param.flowrepair.CreditAccountFlowRepairRedoParam;
import com.elitesland.fin.application.facade.vo.flowrepair.CreditAccountFlowRepairVO;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/10/25
 * @Version 1.0
 * @Content:
 */
public interface CreditAccountFlowRepairService {

    /**
     * 信用账户流水修复重算分页查询
     *
     * @param pageParam 入参
     * @return 信用账户流水修复重算信息集合
     */
    PagingVO<CreditAccountFlowRepairVO> page(CreditAccountFlowRepairPageParam pageParam);

    /**
     * 信用账户流水修复重算保存
     *
     * @param param 入参
     * @return
     */
    void save(CreditAccountFlowRepairParam param);

    /**
     * 根据信用账户流水修复重算ID批量删除
     *
     * @param ids ID集合
     * @return
     */
    void deleteBatch(List<Long> ids);

    /**
     * 信用账户流水修复重算
     *
     * @param repairRedoParam 重算入参
     * @return
     */
    void repairRedo(CreditAccountFlowRepairRedoParam repairRedoParam);

    void removeFlowNoCacheBatch(List<String> flowNoList);

    void removeFlowNoCache(String flowNo);

    String getFlowNoCache(String flowNo);

    void saveFlowNoCache(String flowNo);

}
