package com.elitesland.fin.domain.param.recorder;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2022/4/13 10:31
 */
@Data
public class RecOrderPageParam extends AbstractOrderQueryParam {

    private static final long serialVersionUID = 5812683739447232229L;
    @ApiModelProperty("明细行来源单号")
    private String sourceNoDtl;

    @ApiModelProperty("销售公司ID")
    private Long ouId;

    @ApiModelProperty("销售业务员名称")
    private String saleUser;

    @ApiModelProperty("收款单类型ID")
    private Long recTypeId;

    @ApiModelProperty("收款单号")
    private String recOrderNo;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("含税总金额从")
    private BigDecimal totalAmtFrom;

    @ApiModelProperty("含税总金额至")
    private BigDecimal totalAmtTo;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核时间从")
    private LocalDateTime auditDateStart;

    @ApiModelProperty("审核时间至")
    private LocalDateTime auditDateEnd;

    @ApiModelProperty("单据状态")
    private String orderState;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("收款日期从")
    private LocalDateTime reDateStart;

    @ApiModelProperty("收款日期至")
    private LocalDateTime reDateEnd;

    @ApiModelProperty("是否预收")
    private Boolean reFlag;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejection;

    @ApiModelProperty("单据来源")
    private String createMode;

    @ApiModelProperty("核销状态")
    private String verState;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("销售部门ID")
    private Long buId;

    @ApiModelProperty("收款公司ID")
    private Long recOuId;

    @ApiModelProperty("销售组织ID")
    private Long orgId;


}
