package com.elitesland.fin.infr.repo.recorder;

import com.elitesland.fin.application.service.unionpay.entity.req.SendPayReq;
import com.elitesland.fin.domain.entity.recorder.QRecOrderDO;
import com.elitesland.fin.domain.entity.recorder.QRecOrderDtlDO;
import com.elitesland.fin.domain.entity.recorder.QRecOrderRpcFiledDO;
import com.elitesland.fin.domain.entity.recorder.RecOrderRpcFiledDO;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcExcelVO;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcPageRespVo;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcTwoParam;
import com.elitesland.fin.utils.SqlUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class RecOrderRpcFiledRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QRecOrderDO qRecOrderDO = QRecOrderDO.recOrderDO;
    private final QRecOrderRpcFiledDO qRecOrderRpcFiledDO = QRecOrderRpcFiledDO.recOrderRpcFiledDO;
    private final QRecOrderDtlDO qRecOrderDtlDO = QRecOrderDtlDO.recOrderDtlDO;

    private final QBean<RecOrderRpcPageRespVo> appList = Projections.bean(
            RecOrderRpcPageRespVo.class,
            qRecOrderDO.id,
            qRecOrderDO.sourceNo,
            qRecOrderDO.ouCode,
            qRecOrderDO.ouId,
            qRecOrderDO.ouName,
            qRecOrderDO.arTypeId,
            qRecOrderDO.arTypeName,
            qRecOrderDO.arTypeCode,
            qRecOrderDO.recTypeId,
            qRecOrderDO.recTypeCode,
            qRecOrderDO.recOrderNo,
            qRecOrderDO.currCode,
            qRecOrderDO.currName,
            qRecOrderDO.localCurrCode,
            qRecOrderDO.localCurrName,
            qRecOrderDO.totalAmt,
            qRecOrderDO.totalCurAmt,
            qRecOrderDO.auditUserId,
            qRecOrderDO.auditUser,
            qRecOrderDO.auditDate,
            qRecOrderDO.orderState,
            qRecOrderDO.exchangeRate,
            qRecOrderDO.initFlag,
            qRecOrderDO.realRecAmt,
            qRecOrderDO.realRecCurAmt,
            qRecOrderDO.reDate,
            qRecOrderDO.reFlag,
            qRecOrderDO.auditRejection,
            qRecOrderDO.createMode,
            qRecOrderDO.verState,
            qRecOrderDO.verAmt,
            qRecOrderDO.custId,
            qRecOrderDO.custCode,
            qRecOrderDO.custName,
            qRecOrderDO.buId,
            qRecOrderDO.buCode,
            qRecOrderDO.buName,
            qRecOrderDO.recOuCode,
            qRecOrderDO.recOuId,
            qRecOrderDO.recOuName,
            qRecOrderDO.orgCode,
            qRecOrderDO.orgId,
            qRecOrderDO.orgName,
            qRecOrderDO.taxAmt,
            qRecOrderDO.recOrderType,
            qRecOrderDO.saleUserId,
            qRecOrderDO.saleUser,
            qRecOrderDO.creator.as("creatorRec"),
            qRecOrderDO.remark.as("remarkRec"),
            qRecOrderDO.createUserId.as("createUserIdRec"),
            qRecOrderDO.taxCurAmt,
            qRecOrderDO.createTime,
            qRecOrderDO.modifyTime,
            qRecOrderDO.updater,
            qRecOrderDO.auditDataVersion,
            qRecOrderDO.procInstId,
            qRecOrderDO.procInstStatus,
            qRecOrderDO.approvedTime,
            qRecOrderDO.submitTime,
            qRecOrderDO.addrNo,
            qRecOrderDO.suppAddrNo,
            qRecOrderDO.docType,
            qRecOrderDO.docType2,
            qRecOrderDO.docCls,
            qRecOrderDO.workflowProcInstId,
            qRecOrderDO.workflowProcInstStatus,
            qRecOrderDO.workflowSubmitTime,
            qRecOrderDO.workflowEndTime,
            qRecOrderDO.workflowCurrentNodeKey,
            qRecOrderDO.workflowCurrentNodeName,
            qRecOrderDO.workflowCurrentUserIds,
            qRecOrderDO.workflowRejectedMessage,
            qRecOrderRpcFiledDO.id.as("dId"),
            qRecOrderRpcFiledDO.serviceNo,
            qRecOrderRpcFiledDO.serviceType,
            qRecOrderRpcFiledDO.masId,
            qRecOrderRpcFiledDO.shopCode,
            qRecOrderRpcFiledDO.shopName,
            qRecOrderRpcFiledDO.applyFile,
            qRecOrderRpcFiledDO.remitterBankCode,
            qRecOrderRpcFiledDO.remitterBankName,
            qRecOrderRpcFiledDO.remitterAccount
    );

    private final QBean<RecOrderRpcExcelVO> exportList = Projections.bean(
            RecOrderRpcExcelVO.class,
            qRecOrderDO.recOrderNo,
            qRecOrderRpcFiledDO.shopCode,
            qRecOrderRpcFiledDO.shopName,
            qRecOrderDO.custCode,
            qRecOrderDO.custName,
            qRecOrderDO.currName,
            qRecOrderDO.sourceNo,
            qRecOrderDO.createMode,
            qRecOrderDO.recOrderType,
            qRecOrderDO.realRecAmt,
            qRecOrderDO.orderState,
            qRecOrderDO.reDate,
            qRecOrderDO.remark,
            qRecOrderDO.creator,
            qRecOrderDO.realRecAmt,
            qRecOrderDO.totalAmt,
            qRecOrderDO.recTypeCode.as("recType"),
            qRecOrderDtlDO.recType.as("payMethod"),
            qRecOrderDtlDO.recAccount,
            qRecOrderDtlDO.recBank,
            qRecOrderDtlDO.recFlow,
            qRecOrderDtlDO.realRecAmt.as("realRecAmtDetail"),
            qRecOrderDtlDO.taxAmt,
            qRecOrderDtlDO.taxRate
    );

    public long countRecOrderRpc(RecOrderRpcTwoParam paramVO) {
        var jpaQuery = jpaQueryFactory.select(qRecOrderDO.count())
                .from(qRecOrderDO).leftJoin(qRecOrderRpcFiledDO).on(qRecOrderDO.id.eq(qRecOrderRpcFiledDO.masId));
        ;
        jpaQuery.where(this.whereRecOrderRpc(paramVO));
        return jpaQuery.fetchCount();
    }

    public List<RecOrderRpcPageRespVo> queryRecOrderPrc(RecOrderRpcTwoParam paramVO) {
        var jpaQuery = jpaQueryFactory.select(appList)
                .from(qRecOrderDO).leftJoin(qRecOrderRpcFiledDO).on(qRecOrderDO.id.eq(qRecOrderRpcFiledDO.masId));
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, qRecOrderDO);
        jpaQuery.where(this.whereRecOrderRpc(paramVO));

        return jpaQuery.fetch();
    }

    public RecOrderRpcPageRespVo queryRecOrderPrcDetail(Long id) {
        var jpaQuery = jpaQueryFactory.select(appList)
                .from(qRecOrderDO).leftJoin(qRecOrderRpcFiledDO).on(qRecOrderDO.id.eq(qRecOrderRpcFiledDO.masId)).where(qRecOrderDO.id.eq(id));
        // jpaQuery.where(franchiseeDO.franchiseeCode.eq(paramVO.getFranchiseeCode()));
        return jpaQuery.fetchOne();
    }

    public List<RecOrderRpcExcelVO> queryRecOrderExport(RecOrderRpcTwoParam paramVO) {
        var jpaQuery = jpaQueryFactory.select(exportList)
                .from(qRecOrderDO).leftJoin(qRecOrderRpcFiledDO)
                .on(qRecOrderDO.id.eq(qRecOrderRpcFiledDO.masId))
                .leftJoin(qRecOrderDtlDO).on(qRecOrderDO.id.eq(qRecOrderDtlDO.masId));
        jpaQuery.where(this.whereRecOrderRpc(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereRecOrderRpc(RecOrderRpcTwoParam paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNotEmpty(paramVO.getRecOrderNo())) {
            String likeStr = SqlUtil.toSqlLikeString(paramVO.getRecOrderNo());
            predicates.add(qRecOrderDO.recOrderNo.like(likeStr));
        }
        if (StringUtils.isNotEmpty(paramVO.getCustCode())) {
            String likeStr = SqlUtil.toSqlLikeString(paramVO.getCustCode());
            predicates.add(qRecOrderDO.custCode.like(likeStr));
        }
        if (StringUtils.isNotEmpty(paramVO.getCustName())) {
            String likeStr = SqlUtil.toSqlLikeString(paramVO.getCustName());
            predicates.add(qRecOrderDO.custName.like(likeStr));
        }
        if (StringUtils.isNotEmpty(paramVO.getShopCode())) {
            String likeStr = SqlUtil.toSqlLikeString(paramVO.getShopCode());
            predicates.add(qRecOrderRpcFiledDO.shopCode.like(likeStr));
        }
        if (StringUtils.isNotEmpty(paramVO.getOrderState())) {
            predicates.add(qRecOrderDO.orderState.eq(paramVO.getOrderState()));
        }
//        //是否过滤当前登录人待办
//        if (Boolean.TRUE.equals(paramVO.getIsMyTodo())) {
//            Long currentUserId = FosIamUtil.currentUser().getId();
//            predicates.add(franchiseeApplyDO.flowCurrentNodeHandlerUserIds.like("%`" + currentUserId + "`%"));
//        }
        if (StringUtils.isNotEmpty(paramVO.getRecTypeCode())) {
            predicates.add(qRecOrderDO.recTypeCode.eq(paramVO.getRecTypeCode()));
        }
        if (StringUtils.isNotEmpty(paramVO.getCreator())) {
            predicates.add(qRecOrderDO.creator.eq(paramVO.getCreator()));
        }
        if (StringUtils.isNotEmpty(paramVO.getShopName())) {
            String likeStr = SqlUtil.toSqlLikeString(paramVO.getShopName());
            predicates.add(qRecOrderRpcFiledDO.shopName.like(likeStr));
        }
        if (StringUtils.isNotEmpty(paramVO.getShopCode())) {
            String likeStr = SqlUtil.toSqlLikeString(paramVO.getShopCode());
            predicates.add(qRecOrderRpcFiledDO.shopCode.like(likeStr));
        }
//        if (StringUtils.isNotEmpty(paramVO.getChannelType())) {
//            predicates.add(franchiseeApplyDO.channelType.eq(paramVO.getChannelType()));
//        }
        if (!ObjectUtils.isEmpty(paramVO.getReDateStart())) {
            predicates.add(qRecOrderDO.reDate.after(paramVO.getReDateStart())
                    .or(qRecOrderDO.reDate.after(paramVO.getReDateStart())));
        }

        if (!ObjectUtils.isEmpty(paramVO.getReDateEnd())) {
            predicates.add(qRecOrderDO.reDate.before(paramVO.getReDateEnd())
                    .or(qRecOrderDO.reDate.before(paramVO.getReDateEnd())));
        }
        if (ObjectUtils.isNotEmpty(paramVO.getSourceNo())) {
            predicates.add(qRecOrderDO.sourceNo.eq(paramVO.getSourceNo()));
        }

        if (paramVO.getId() != null) {
            predicates.add(qRecOrderDO.id.eq(paramVO.getId()));
        }
//        if(StringUtils.isNotEmpty(paramVO.getFranchiseeCode())){
//            predicates.add(franchiseeDO.franchiseeCode.eq(paramVO.getFranchiseeCode()));
//        }
//        if(!ObjectUtils.isEmpty(paramVO.getFranchiseeIdList())){
//            predicates.add(franchiseeApplyDO.franchiseeId.in(paramVO.getFranchiseeIdList()));
//        }
//        if(StringUtils.isNotEmpty(paramVO.getFlowStatus())){
//            predicates.add(franchiseeApplyDO.flowStatus.eq(FlowStatus.valueOf(paramVO.getFlowStatus())));
//        }
//        // 加盟商权限过滤
//        Optional<FranchiseeUserDO> franchiseeUserDO = fosFranchiseeUtil.currentFranchiseeUser();
//        if (franchiseeUserDO.isPresent()) {
//            predicates.add(franchiseeApplyDO.franchiseeId.eq(franchiseeUserDO.get().getFranchiseeId()));
//        } else {
//            if (Arrays.asList(FosConstant.CT,FosConstant.KA).contains(FosIamUtil.getUserOrgCode())) {
//                predicates.add(franchiseeApplyDO.channelType.eq(FosIamUtil.getUserOrgCode()));
//            }
//            if (FosIamUtil.isEmployee()) {
//                predicates.add(franchiseeApplyDO.empUserId.eq(FosIamUtil.currentUser().getId()));
//            }
//        }
        return ExpressionUtils.allOf(predicates);
    }

    /**
     * 根据主表id修改数据
     */
    public Long masIdUpdateFiled(RecOrderRpcFiledDO rec) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(qRecOrderRpcFiledDO.id.eq(rec.getMasId()));
        JPAUpdateClause update = jpaQueryFactory.update(qRecOrderRpcFiledDO)
                .set(qRecOrderRpcFiledDO.shopName, rec.getShopName())
                .set(qRecOrderRpcFiledDO.shopCode, rec.getShopCode())
                .set(qRecOrderRpcFiledDO.applyFile, rec.getApplyFile())
                .set(qRecOrderRpcFiledDO.serviceNo, rec.getServiceNo())
                .set(qRecOrderRpcFiledDO.serviceType, rec.getServiceType())
                .where(ExpressionUtils.allOf(predicates));
        return update.execute();
    }

    public void updateRecOrderDtl(SendPayReq sendPayReq) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qRecOrderDtlDO);
        if (StringUtils.isNotEmpty(sendPayReq.getRecType())) {
            jpaUpdateClause.set(qRecOrderDtlDO.recType, sendPayReq.getRecType());
        }

        if (StringUtils.isNotEmpty(sendPayReq.getRecBank())) {
            jpaUpdateClause.set(qRecOrderDtlDO.recBank, sendPayReq.getRecBank());
        }

        if (StringUtils.isNotEmpty(sendPayReq.getRecAcc())) {
            jpaUpdateClause.set(qRecOrderDtlDO.recAccount, sendPayReq.getRecAcc());
        }

        jpaUpdateClause.where(qRecOrderDtlDO.sourceNo.eq(sendPayReq.getPayOrderId()));
        jpaUpdateClause.execute();
    }

    public void updateRecOrderExtend(SendPayReq sendPayReq) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qRecOrderRpcFiledDO);
        if (StringUtils.isNotEmpty(sendPayReq.getApplyFile())) {
            jpaUpdateClause.set(qRecOrderRpcFiledDO.applyFile, sendPayReq.getApplyFile());
        }
        jpaUpdateClause.where(qRecOrderRpcFiledDO.sourceNo.eq(sendPayReq.getPayOrderId()));
        jpaUpdateClause.execute();
    }

    public void updateRecOrder(SendPayReq sendPayReq) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qRecOrderDO);
        if (sendPayReq.getWorkflowProcInstStatus() != null) {
            jpaUpdateClause.set(qRecOrderDO.workflowProcInstStatus, sendPayReq.getWorkflowProcInstStatus());
        }

        if (StringUtils.isNotEmpty(sendPayReq.getWorkflowProcInstId())) {
            jpaUpdateClause.set(qRecOrderDO.workflowProcInstId, sendPayReq.getWorkflowProcInstId());
        }

        if (sendPayReq.getWorkflowSubmitTime() != null) {
            jpaUpdateClause.set(qRecOrderDO.workflowSubmitTime, sendPayReq.getWorkflowSubmitTime());
        }

        if (StringUtils.isNotEmpty(sendPayReq.getWorkflowCurrentNodeKey())) {
            jpaUpdateClause.set(qRecOrderDO.workflowCurrentNodeKey, sendPayReq.getWorkflowCurrentNodeKey());
        }

        if (StringUtils.isNotEmpty(sendPayReq.getWorkflowCurrentNodeName())) {
            jpaUpdateClause.set(qRecOrderDO.workflowCurrentNodeName, sendPayReq.getWorkflowCurrentNodeName());
        }

        if (StringUtils.isNotEmpty(sendPayReq.getWorkflowCurrentUserIds())) {
            jpaUpdateClause.set(qRecOrderDO.workflowCurrentUserIds, sendPayReq.getWorkflowCurrentUserIds());
        }

        if (StringUtils.isNotEmpty(sendPayReq.getWorkflowRejectedMessage())) {
            jpaUpdateClause.set(qRecOrderDO.workflowRejectedMessage, sendPayReq.getWorkflowRejectedMessage());
        }

        if (StringUtils.isNotEmpty(sendPayReq.getReceiptStatus())) {
            jpaUpdateClause.set(qRecOrderDO.orderState, sendPayReq.getReceiptStatus());
        }

        jpaUpdateClause.where(qRecOrderDO.id.eq(sendPayReq.getId()));
        jpaUpdateClause.execute();
    }
}
