package com.elitesland.fin.repo.creditaccount;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountInitialLimitDTO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountInitialLimitParam;
import com.elitesland.fin.application.facade.vo.creditaccount.InitialLimitPageVO;
import com.elitesland.fin.entity.creditaccount.QCreditAccountDO;
import com.elitesland.fin.entity.creditaccount.QCreditAccountInitialLimitDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Repository
@AllArgsConstructor
public class CreditAccountInitialLimitRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QCreditAccountInitialLimitDO Q_DO = QCreditAccountInitialLimitDO.creditAccountInitialLimitDO;

    private final QCreditAccountDO Q_CA_DO = QCreditAccountDO.creditAccountDO;


    public List<CreditAccountInitialLimitDTO> findByParam(List<CreditAccountInitialLimitParam> params) {
        List<Predicate> predicates = new ArrayList<>();
        params.stream().forEach(param -> {
            Predicate predicate = commonBuilder(param).build();
            predicates.add(predicate);
        });

        JPAQuery<CreditAccountInitialLimitDTO> jpaQuery = jpaQueryFactory.select(Projections.bean(CreditAccountInitialLimitDTO.class,
                Q_DO.creditAccountCode,
                Q_DO.creditAccountName,
                Q_DO.status,
                Q_DO.id
        )).from(Q_DO).where(ExpressionUtils.anyOf(predicates));
        return jpaQuery.fetch();
    }

    public PagingVO<InitialLimitPageVO> pageSearch(CreditAccountInitialLimitParam pageParam) {
        Predicate predicate = commonBuilder(pageParam)
                .andLike(StrUtil.isNotBlank(pageParam.getObjectName()), Q_CA_DO.objectName, pageParam.getObjectName())
                .build();
        JPAQuery<InitialLimitPageVO> query = select(InitialLimitPageVO.class)
                .innerJoin(Q_CA_DO).on(Q_DO.creditAccountCode.eq(Q_CA_DO.creditAccountCode))
                .where(predicate)
                .orderBy(Q_DO.createTime.desc());
        pageParam.setPaging(query);
        pageParam.fillOrders(query, Q_DO);
        return PagingVO.<InitialLimitPageVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                Q_DO.id,
                Q_DO.creditAccountCode,
                Q_DO.creditAccountName,
                Q_DO.initialAccountLimit.as("creditAccountLimit"),
                Q_DO.initialAccountAvailableLimit.as("creditAccountAvailableLimit"),
                Q_DO.initialAccountOccupancyLimit.as("creditAccountOccupancyLimit"),
                Q_DO.initialAccountUsedLimit.as("creditAccountUsedLimit"),
                Q_DO.finishedTime,
                Q_DO.status,
                Q_DO.remark,
                Q_DO.createTime,
                Q_DO.creator,
                Q_DO.createUserId,
                Q_DO.modifyTime,
                Q_DO.modifyUserId,
                Q_DO.updater,
                Q_DO.tenantId,
                Q_CA_DO.ouCode,
                Q_CA_DO.ouName,
                Q_CA_DO.objectType,
                Q_CA_DO.objectName,
                Q_CA_DO.creditAccountType,
                Q_CA_DO.objectCode,
                Q_CA_DO.deptId,
                Q_CA_DO.deptName,
                Q_CA_DO.productLineCode,
                Q_CA_DO.productLineName,
                Q_CA_DO.salesmanName,
                Q_CA_DO.salesmanNo
        )).from(Q_DO);
    }

    private BaseRepoProc.PredicateBuilder commonBuilder(CreditAccountInitialLimitParam param) {
        return BaseRepoProc.PredicateBuilder.builder()
                .andLike(StrUtil.isNotBlank(param.getCreditAccountCodeName()), new StringExpression[]{Q_DO.creditAccountCode, Q_DO.creditAccountName}, param.getCreditAccountCodeName())
                .andEq(StrUtil.isNotBlank(param.getStatus()), Q_DO.status, param.getStatus())
                .andEq(StrUtil.isNotBlank(param.getCreditAccountCode()), Q_DO.creditAccountCode, param.getCreditAccountCode())
                .andEq(StrUtil.isNotBlank(param.getCreditAccountName()), Q_DO.creditAccountName, param.getCreditAccountName());
    }

    public void deleteByAccountCodesAndStatus(Set<String> accountCodeList, String status) {
        jpaQueryFactory.update(Q_DO).set(Q_DO.deleteFlag, 1)
        .where(Q_DO.creditAccountCode.in(accountCodeList).and(Q_DO.status.eq(status)))
        .execute();
    }
}
