package com.elitesland.fin.repo.invoice;

import com.elitesland.fin.entity.invoice.PaymentRecordsDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2023/4/13
 */
@Repository
public interface PaymentRecordsRepo extends JpaRepository<PaymentRecordsDO, Long>, QuerydslPredicateExecutor<PaymentRecordsDO> {

    PaymentRecordsDO findByNoticeId(Long noticeId);

    List<PaymentRecordsDO> findBySourceDocIdIn(List<Long> sourceIdList);

    /**
     * 通过doc no获取付款记录
     *
     * @param docNoList
     * @return
     */
    List<PaymentRecordsDO> findByDocNoIn(List<String> docNoList);


    @Modifying
    @Query(value = "update fin_payment_records set delete_flag = :deleteFlag where id in :idList", nativeQuery = true)
    List<Long> updateDeleteFlagById(List<Long> idList, String deleteFlag);
}
