/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.web.unionpay;

import com.elitescloud.boot.context.TenantSession;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitesland.fin.application.service.unionpay.UnionPayService;
import com.elitesland.fin.application.service.unionpay.entity.req.SendPayReq;
import com.elitesland.fin.application.service.unionpay.util.UnionPayUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"tims\u94f6\u5546\u652f\u4ed8\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/unionpay"})
public class UnionPayController {
    private static final Logger log = LoggerFactory.getLogger(UnionPayController.class);
    private final UnionPayService unionPayService;
    private final TaskExecutor taskExecutor;

    @GetMapping(value={"/test/getCurrentTenant"})
    @ApiModelProperty(value="\u94f6\u5546\u63a5\u53e3\u4e0b\u7684\u5f53\u524d\u79df\u6237")
    public ApiResult<?> getCurrentTenant() {
        SysTenantDTO tenant = TenantSession.getCurrentTenant();
        return ApiResult.ok((Object)tenant);
    }

    @GetMapping(value={"/test/taskExecutorTenant"})
    @ApiModelProperty(value="\u7ebf\u7a0b\u4e2d\u7684\u5f53\u524d\u79df\u6237")
    public ApiResult<?> taskExecutorTenant() {
        SysTenantDTO tenant = TenantClient.getCurrentTenant();
        log.info("\u4e3b\u7ebf\u7a0b\u79df\u6237\uff1a{}", (Object)tenant);
        CompletableFuture.runAsync(() -> log.info("\u5f02\u6b65\u7ebf\u7a0b\u79df\u6237\uff1a{}", (Object)TenantClient.getCurrentTenant()), (Executor)this.taskExecutor);
        return ApiResult.ok((Object)tenant);
    }

    @PostMapping(value={"/sendPay"})
    @ApiModelProperty(value="\u53d1\u8d77\u652f\u4ed8")
    public ApiResult<Map<String, Object>> sendPay(@RequestBody SendPayReq payReq) {
        if (ObjectUtils.isEmpty((Object)payReq.getRemitterAmt())) {
            log.warn("\u8d26\u6237\u50a8\u503c\u91d1\u989d\u6709\u8bef:{}", (Object)payReq.getRemitterAmt());
            return ApiResult.fail((String)"\u8d26\u6237\u50a8\u503c\u91d1\u989d\u6709\u8bef");
        }
        Map<String, Object> respData = this.unionPayService.sendPay(payReq);
        return ApiResult.ok(respData);
    }

    @PostMapping(value={"/payCallback"})
    public ApiResult<Void> payCallback(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        log.info("4.1\u652f\u4ed8\u5f02\u6b65\u56de\u8c03\u54cd\u5e94\u4fe1\u606f is {}", (Object)parameterMap);
        if (CollectionUtils.isEmpty((Map)parameterMap)) {
            return ApiResult.fail((String)"4.1\u652f\u4ed8\u5f02\u6b65\u56de\u8c03\u54cd\u5e94\u4fe1\u606f\u4e3a\u7a7a");
        }
        Map<String, String> data = UnionPayUtil.valueArray2String(parameterMap);
        this.unionPayService.payCallBack(data);
        return ApiResult.ok();
    }

    @PostMapping(value={"/followPayCallback"})
    public ApiResult<Void> followPayCallback(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        log.info("4.15\u540e\u7eed\u4ea4\u6613\u5f02\u6b65\u56de\u8c03\u54cd\u5e94\u4fe1\u606f is {}", (Object)parameterMap);
        if (CollectionUtils.isEmpty((Map)parameterMap)) {
            return ApiResult.fail((String)"4.15\u540e\u7eed\u4ea4\u6613\u5f02\u6b65\u56de\u8c03\u54cd\u5e94\u4fe1\u606f\u4e3a\u7a7a");
        }
        Map<String, String> data = UnionPayUtil.valueArray2String(parameterMap);
        this.unionPayService.followPayCallback(data);
        return ApiResult.ok();
    }

    public UnionPayController(UnionPayService unionPayService, TaskExecutor taskExecutor) {
        this.unionPayService = unionPayService;
        this.taskExecutor = taskExecutor;
    }
}

