/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinSetOfBookConvert;
import com.elitesland.fin.application.convert.accountingengine.FinSetOfBookLineConvert;
import com.elitesland.fin.application.convert.accountingengine.FinSetOfBookOuConvert;
import com.elitesland.fin.application.facade.param.accountingengine.FinSetOfBookLineParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinSetOfBookOuParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinSetOfBookParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinSetOfBookOuVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinSetOfBookVO;
import com.elitesland.fin.application.service.accountingengine.FinSetOfBookService;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountPeriodDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountPeriodLineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookOuDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSobAccountPeriodDO;
import com.elitesland.fin.repo.accountingengine.FinAccountPeriodLineRepo;
import com.elitesland.fin.repo.accountingengine.FinAccountPeriodRepoProc;
import com.elitesland.fin.repo.accountingengine.FinJournalRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookLineRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookOuRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookOuRepoProc;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookRepoProc;
import com.elitesland.fin.repo.accountingengine.FinSobAccountPeriodRepo;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FinSetOfBookServiceImpl
implements FinSetOfBookService {
    private static final Logger log = LoggerFactory.getLogger(FinSetOfBookServiceImpl.class);
    private final FinSetOfBookRepo finSetOfBookRepo;
    private final FinSetOfBookRepoProc finSetOfBookRepoProc;
    private final FinSetOfBookLineRepo finSetOfBookLineRepo;
    private final FinSetOfBookOuRepo finSetOfBookOuRepo;
    private final FinSetOfBookOuRepoProc finSetOfBookOuRepoProc;
    private final FinSobAccountPeriodRepo finSobAccountPeriodRepo;
    private final FinJournalRepo finJournalRepo;
    private final FinAccountPeriodRepoProc finAccountPeriodRepoProc;
    private final FinAccountPeriodLineRepo finAccountPeriodLineRepo;

    @Override
    @SysCodeProc
    public PagingVO<FinSetOfBookVO> page(FinSetOfBookParam finSetOfBookParam) {
        return FinSetOfBookConvert.INSTANCE.DTOToVO(this.finSetOfBookRepoProc.page(finSetOfBookParam));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableOrDisable(FinSetOfBookParam finSetOfBookParam) {
        this.checkEnableOrDisableParam(finSetOfBookParam);
        List finSetOfBookDOList = this.finSetOfBookRepo.findAllById(finSetOfBookParam.getIds());
        finSetOfBookDOList.stream().forEach(item -> Assert.isFalse((boolean)finSetOfBookParam.getStatus().equals(item.getStatus()), (String)"\u6570\u636e\u5df2\u7ecf\u542f\u7528/\u7981\u7528", (Object[])new Object[0]));
        finSetOfBookDOList.stream().forEach(item -> item.setStatus(finSetOfBookParam.getStatus()));
    }

    @Override
    public void deleteFinSetOfBookOu(FinSetOfBookParam finSetOfBookParam) {
        this.checkDeleteFinSetOfBookOuParam(finSetOfBookParam);
        List<String> ouCodes = finSetOfBookParam.getOuDetailList().stream().map(FinSetOfBookOuParam::getOuCode).collect(Collectors.toList());
        List<FinSobAccountPeriodDO> finSobAccountPeriodDOList = this.finSobAccountPeriodRepo.findAllBySobCodeAndAccountPeriodCodeAndOuCodeIn(finSetOfBookParam.getSobCode(), finSetOfBookParam.getAccountPeriodCode(), ouCodes);
        if (CollectionUtils.isEmpty(finSobAccountPeriodDOList)) {
            return;
        }
        Assert.isTrue((boolean)CollectionUtils.isEmpty(finSobAccountPeriodDOList), (String)"{}\u4f1a\u8ba1\u671f\u95f4\u63a7\u5236\u5df2\u7ecf\u751f\u6210\uff0c\u4e0d\u80fd\u5220\u9664", (Object[])new Object[]{finSobAccountPeriodDOList.get(0).getOuCode()});
    }

    @Override
    public void deleteFinSetOfBookLine(FinSetOfBookParam finSetOfBookParam) {
        Assert.notEmpty((CharSequence)finSetOfBookParam.getSobCode(), (String)"\u8d26\u5957\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<FinJournalRepo> finJournalRepoList = this.finJournalRepo.findAllBySobLedgerCode(finSetOfBookParam.getSobCode());
        Assert.isTrue((boolean)CollectionUtils.isEmpty(finJournalRepoList), (String)"\u5e10\u5957\u5df2\u7ecf\u751f\u6210\u5206\u5f55,\u65e0\u6cd5\u5220\u9664", (Object[])new Object[0]);
    }

    private void checkDeleteFinSetOfBookOuParam(FinSetOfBookParam finSetOfBookParam) {
        Assert.notEmpty((CharSequence)finSetOfBookParam.getSobCode(), (String)"\u8d26\u5957\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finSetOfBookParam.getAccountPeriodCode(), (String)"\u4f1a\u8ba1\u671f\u95f4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty(finSetOfBookParam.getOuDetailList(), (String)"\u516c\u53f8\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        finSetOfBookParam.getOuDetailList().stream().forEach(item -> Assert.notEmpty((CharSequence)item.getOuCode(), (String)"\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]));
    }

    private void checkEnableOrDisableParam(FinSetOfBookParam finSetOfBookParam) {
        Assert.notEmpty(finSetOfBookParam.getIds(), (String)"id\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finSetOfBookParam.getStatus(), (String)"\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdate(FinSetOfBookParam finSetOfBookParam) {
        finSetOfBookParam.setDimenDetailList(Optional.ofNullable(finSetOfBookParam.getDimenDetailList()).orElse(Collections.emptyList()));
        finSetOfBookParam.setOuDetailList(Optional.ofNullable(finSetOfBookParam.getOuDetailList()).orElse(Collections.emptyList()));
        this.checkSaveOrUpdateParam(finSetOfBookParam);
        this.checkIdempotent(finSetOfBookParam);
        FinSetOfBookDO finSetOfBookDO = (FinSetOfBookDO)this.finSetOfBookRepo.save(FinSetOfBookConvert.INSTANCE.paramToDO(finSetOfBookParam));
        List<FinSetOfBookLineParam> dimenDetailList = finSetOfBookParam.getDimenDetailList();
        List<FinSetOfBookOuParam> ouDetailList = finSetOfBookParam.getOuDetailList();
        this.finSetOfBookLineRepo.deleteAllByMasId(finSetOfBookDO.getId());
        if (CollectionUtils.isNotEmpty(dimenDetailList)) {
            dimenDetailList.stream().forEach(item -> item.setMasId(finSetOfBookDO.getId()));
            this.finSetOfBookLineRepo.saveAll(FinSetOfBookLineConvert.INSTANCE.paramToDO(dimenDetailList));
        }
        this.finSetOfBookOuRepo.deleteAllByMasId(finSetOfBookDO.getId());
        if (CollectionUtils.isNotEmpty(ouDetailList)) {
            ouDetailList.stream().forEach(item -> item.setMasId(finSetOfBookDO.getId()));
            this.finSetOfBookOuRepo.saveAll(FinSetOfBookOuConvert.INSTANCE.paramToDO(ouDetailList));
        }
        return finSetOfBookDO.getId();
    }

    private void checkSaveOrUpdateParam(FinSetOfBookParam finSetOfBookParam) {
        Assert.notEmpty((CharSequence)finSetOfBookParam.getSobCode(), (String)"\u8d26\u5957\u7f16\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finSetOfBookParam.getSobName(), (String)"\u8d26\u5957\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finSetOfBookParam.getAccountPeriodCode(), (String)"\u4f1a\u8ba1\u671f\u95f4\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finSetOfBookParam.getAccountPeriodName(), (String)"\u4f1a\u8ba1\u671f\u95f4\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finSetOfBookParam.getCurrCode(), (String)"\u672c\u4f4d\u5e01\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finSetOfBookParam.getStatus(), (String)"\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
        List<FinSetOfBookLineParam> dimenDetailList = finSetOfBookParam.getDimenDetailList();
        List<FinSetOfBookOuParam> ouDetailList = finSetOfBookParam.getOuDetailList();
        Assert.isTrue((CollectionUtils.isNotEmpty(dimenDetailList) || CollectionUtils.isNotEmpty(ouDetailList) ? 1 : 0) != 0, (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ouDetailList.stream().forEach(item -> {
            Assert.notEmpty((CharSequence)item.getOuCode(), (String)"\u516c\u53f8\u7f16\u7801\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getOuName(), (String)"\u516c\u53f8\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        });
        dimenDetailList.stream().forEach(item -> {
            Assert.notEmpty((CharSequence)item.getColumnName(), (String)"\u5b57\u6bb5\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getAccountDimenCode(), (String)"\u6838\u7b97\u7ef4\u5ea6\u7f16\u7801\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getAccountDimenName(), (String)"\u6838\u7b97\u7ef4\u5ea6\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notNull((Object)item.getFlexibleFlag(), (String)"\u662f\u5426\u662f\u503c\u96c6\u5fc5\u586b", (Object[])new Object[0]);
            if (Boolean.TRUE.equals(item.getFlexibleFlag())) {
                Assert.notEmpty((CharSequence)item.getFlexibleCode(), (String)"\u503c\u96c6\u7f16\u7801\u5fc5\u586b", (Object[])new Object[0]);
                Assert.notEmpty((CharSequence)item.getFlexibleName(), (String)"\u503c\u96c6\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
            }
        });
    }

    private void checkIdempotent(FinSetOfBookParam finSetOfBookParam) {
        List<FinSetOfBookOuParam> ouDetailList;
        FinSetOfBookDO finSetOfBookDO = this.finSetOfBookRepoProc.findBySobCode(finSetOfBookParam.getSobCode());
        if (finSetOfBookDO != null) {
            Assert.equals((Object)finSetOfBookParam.getId(), (Object)finSetOfBookDO.getId(), (String)"\u8d26\u5957\u7f16\u7801\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        }
        if (CollectionUtils.isNotEmpty(ouDetailList = finSetOfBookParam.getOuDetailList())) {
            List<String> ouCodes = ouDetailList.stream().map(FinSetOfBookOuParam::getOuCode).collect(Collectors.toList());
            List<FinSetOfBookOuDO> finSetOfBookOuDOList = this.finSetOfBookOuRepo.findAllByOuCodeIn(ouCodes);
            if (finSetOfBookParam.getId() == null) {
                Assert.isNull(finSetOfBookOuDOList, (String)"{}\u5df2\u7ecf\u5206\u914d\u8d26\u5957", (Object[])new Object[]{finSetOfBookOuDOList.get(0).getOuCode()});
            } else {
                finSetOfBookOuDOList.stream().forEach(item -> Assert.equals((Object)item.getMasId(), (Object)finSetOfBookParam.getId(), (String)"{}\u5df2\u7ecf\u5206\u914d\u8d26\u5957", (Object[])new Object[]{item.getOuCode()}));
            }
        }
    }

    @Override
    public FinSetOfBookVO queryOuAndYear(FinSetOfBookParam finSetOfBookParam) {
        Assert.notBlank((CharSequence)finSetOfBookParam.getSobCode(), (String)"\u8d26\u5957\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        FinSetOfBookVO finSetOfBookVO = new FinSetOfBookVO();
        FinSetOfBookDO finSetOfBookDO = this.finSetOfBookRepoProc.findBySobCode(finSetOfBookParam.getSobCode());
        Assert.notNull((Object)"\u8d26\u5957\u4e0d\u5b58\u5728");
        FinAccountPeriodDO finAccountPeriodDO = this.finAccountPeriodRepoProc.findByAccountPeriodCode(finSetOfBookDO.getAccountPeriodCode());
        Assert.notNull((Object)"\u8be5\u8d26\u5957\u7684\u4f1a\u8ba1\u671f\u95f4\u8bbe\u7f6e\u4e0d\u5b58\u5728");
        List<FinAccountPeriodLineDO> finAccountPeriodLineDOList = this.finAccountPeriodLineRepo.findAllByMasIdIn(Lists.newArrayList((Object[])new Long[]{finAccountPeriodDO.getId()}));
        List<String> yearList = finAccountPeriodLineDOList.stream().map(FinAccountPeriodLineDO::getYear).distinct().collect(Collectors.toList());
        finSetOfBookVO.setYearList(yearList);
        return finSetOfBookVO;
    }

    @Override
    public PagingVO<FinSetOfBookOuVO> queryOu(FinSetOfBookOuParam finSetOfBookParam) {
        return this.finSetOfBookOuRepoProc.page(finSetOfBookParam);
    }

    public FinSetOfBookServiceImpl(FinSetOfBookRepo finSetOfBookRepo, FinSetOfBookRepoProc finSetOfBookRepoProc, FinSetOfBookLineRepo finSetOfBookLineRepo, FinSetOfBookOuRepo finSetOfBookOuRepo, FinSetOfBookOuRepoProc finSetOfBookOuRepoProc, FinSobAccountPeriodRepo finSobAccountPeriodRepo, FinJournalRepo finJournalRepo, FinAccountPeriodRepoProc finAccountPeriodRepoProc, FinAccountPeriodLineRepo finAccountPeriodLineRepo) {
        this.finSetOfBookRepo = finSetOfBookRepo;
        this.finSetOfBookRepoProc = finSetOfBookRepoProc;
        this.finSetOfBookLineRepo = finSetOfBookLineRepo;
        this.finSetOfBookOuRepo = finSetOfBookOuRepo;
        this.finSetOfBookOuRepoProc = finSetOfBookOuRepoProc;
        this.finSobAccountPeriodRepo = finSobAccountPeriodRepo;
        this.finJournalRepo = finJournalRepo;
        this.finAccountPeriodRepoProc = finAccountPeriodRepoProc;
        this.finAccountPeriodLineRepo = finAccountPeriodLineRepo;
    }
}

