/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.config;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccountEngineParam;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.accountingengine.FinAccountEngineService;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.application.service.limitadjustorder.LimitAdjustOrderService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JobHandler {
    private static final Logger log = LoggerFactory.getLogger(JobHandler.class);
    private final LimitAdjustOrderService limitAdjustOrderService;
    private final InvoiceAwaitService invoiceAwaitService;
    private final CreditAccountService creditAccountService;
    private final AccountService accountService;
    private final FinAccountEngineService finAccountEngineService;
    private final TenantClientProvider tenantClientProvider;

    @XxlJob(value="expireLimitAdjustOrder")
    public ReturnT<String> expireLimitAdjustOrder(String param) {
        try {
            this.limitAdjustOrderService.expireLimitAdjustOrder();
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="activeLimitAdjustOrder")
    public ReturnT<String> activeLimitAdjustOrder(String param) {
        try {
            log.info("\u767b\u5f55\u4eba\u4fe1\u606f\uff1a{}", (Object)SecurityContextUtil.currentUser());
            this.limitAdjustOrderService.activeLimitAdjustOrder();
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="invoiceAwaitOrder")
    public ReturnT<String> invoiceAwaitOrder(String param) {
        try {
            this.invoiceAwaitService.invoiceAwaitOrder(param);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="creditAccountSnapshot")
    public ReturnT<String> creditAccountSnapshot(String param) {
        XxlJobLogger.log((String)"creditAccountSnapshot \u53c2\u6570:{}", (Object[])new Object[]{param});
        try {
            this.creditAccountService.creditAccountSnapshot(param);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="accountSnapshot")
    public ReturnT<String> accountSnapshot(String param) {
        XxlJobLogger.log((String)"accountSnapshot \u53c2\u6570:{}", (Object[])new Object[]{param});
        try {
            this.accountService.accountSnapshot(param);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="accountJournalGenerate")
    public ReturnT<String> accountJournalGenerate(String param) {
        long tenantId = -1L;
        if (this.tenantClientProvider.getSessionTenant() != null) {
            tenantId = this.tenantClientProvider.getSessionTenant().getId();
        }
        XxlJobLogger.log((String)"\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0c\u5f00\u59cb\u6267\u884c,\u79df\u6237id:{}", (Object[])new Object[]{tenantId});
        XxlJobLogger.log((String)"\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0c\u5f00\u59cb\u6267\u884c,\u53c2\u6570:{}", (Object[])new Object[]{param});
        if (StringUtils.isBlank((CharSequence)param) || !param.contains(":")) {
            XxlJobLogger.log((String)"\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0c\u53c2\u6570\u4e3a\u7a7a\uff0c\u7ed3\u675f\u6267\u884c", (Object[])new Object[]{param});
            return ReturnT.SUCCESS;
        }
        String[] paramary = param.split(":");
        if (paramary.length < 2) {
            XxlJobLogger.log((String)"\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0c\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u7ed3\u675f\u6267\u884c", (Object[])new Object[]{param});
            return ReturnT.SUCCESS;
        }
        try {
            String eventTable = paramary[0];
            long id = Long.valueOf(paramary[1]);
            FinAccountEngineParam finAccountEngineParam = new FinAccountEngineParam();
            finAccountEngineParam.setEventTable(eventTable);
            finAccountEngineParam.setId(id);
            XxlJobLogger.log((String)"\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0ceventTable:{},id:{}", (Object[])new Object[]{eventTable, id});
            XxlJobLogger.log((String)("\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0cservice\u53c2\u6570\uff1a" + JSON.toJSONString((Object)((Object)finAccountEngineParam))), (Object[])new Object[0]);
            this.finAccountEngineService.generateJournal(finAccountEngineParam);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0c\u6267\u884c\u5f02\u5e38\uff1a" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        XxlJobLogger.log((String)"\u4f1a\u8ba1\u5206\u5f55\u751f\u6210\u5b9a\u65f6\u4efb\u52a1\uff0c\u6267\u884c\u7ed3\u675f", (Object[])new Object[0]);
        return ReturnT.SUCCESS;
    }

    public JobHandler(LimitAdjustOrderService limitAdjustOrderService, InvoiceAwaitService invoiceAwaitService, CreditAccountService creditAccountService, AccountService accountService, FinAccountEngineService finAccountEngineService, TenantClientProvider tenantClientProvider) {
        this.limitAdjustOrderService = limitAdjustOrderService;
        this.invoiceAwaitService = invoiceAwaitService;
        this.creditAccountService = creditAccountService;
        this.accountService = accountService;
        this.finAccountEngineService = finAccountEngineService;
        this.tenantClientProvider = tenantClientProvider;
    }
}

