/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.account;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.account.AccountRuleConfigQueryParam;
import com.elitesland.fin.application.facade.vo.account.AccountRuleConfigPageVO;
import com.elitesland.fin.entity.account.AccountRuleConfigDO;
import com.elitesland.fin.entity.account.QAccountRuleConfigDO;
import com.elitesland.fin.entity.account.QAccountRuleConfigDtlDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AccountRuleConfigRepoProc {
    private static final Logger log = LoggerFactory.getLogger(AccountRuleConfigRepoProc.class);
    private final JPAQueryFactory jpaQueryFactory;

    public void updateDynamically(AccountRuleConfigDO param) {
        QAccountRuleConfigDO jpaQDO = QAccountRuleConfigDO.accountRuleConfigDO;
        JPAUpdateClause updateClause = this.jpaQueryFactory.update((EntityPath)jpaQDO);
        if (StringUtils.isNotBlank((CharSequence)param.getRuleCode())) {
            updateClause.set((Path)jpaQDO.ruleCode, (Object)param.getRuleCode());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getRuleName())) {
            updateClause.set((Path)jpaQDO.ruleName, (Object)param.getRuleName());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getOptDoc())) {
            updateClause.set((Path)jpaQDO.optDoc, (Object)param.getOptDoc());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getStatus())) {
            updateClause.set((Path)jpaQDO.status, (Object)param.getStatus());
        }
        updateClause.set(jpaQDO.modifyTime, (Object)LocalDateTime.now());
        updateClause.where(new Predicate[]{jpaQDO.id.eq((Object)param.getId())}).execute();
    }

    public PagingVO<AccountRuleConfigPageVO> searchPage(AccountRuleConfigQueryParam param) {
        QAccountRuleConfigDO jpaQDo = QAccountRuleConfigDO.accountRuleConfigDO;
        QAccountRuleConfigDtlDO jpaDQDo = QAccountRuleConfigDtlDO.accountRuleConfigDtlDO;
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AccountRuleConfigPageVO.class, (Expression[])new Expression[]{jpaDQDo.id, jpaQDo.ruleCode, jpaQDo.ruleName, jpaQDo.optDoc, jpaDQDo.optDocType, jpaDQDo.optDocStatus, jpaDQDo.calculatePercent, jpaDQDo.maxLimit, jpaDQDo.automaticReview, jpaQDo.status, jpaDQDo.masId, jpaDQDo.ioCode, jpaDQDo.ioName, jpaDQDo.priorityNo, jpaQDo.createUserId, jpaQDo.creator, jpaQDo.createTime, jpaQDo.modifyUserId, jpaQDo.updater, jpaQDo.modifyTime, jpaQDo.deleteFlag, jpaQDo.tenantId, jpaQDo.auditDataVersion, jpaDQDo.remark})).from((EntityPath)jpaDQDo)).leftJoin((EntityPath)jpaQDo)).on((Predicate)jpaQDo.id.eq(jpaDQDo.masId));
        if (param != null) {
            jpaQuery.where(this.where(param));
            param.fillOrders(jpaQuery, jpaQDo);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where((Predicate)jpaQDo.deleteFlag.eq((Object)0).or((Predicate)jpaQDo.deleteFlag.isNull()));
        return PagingVO.builder().total(jpaQuery.fetchCount()).records(jpaQuery.fetch()).build();
    }

    private Predicate where(AccountRuleConfigQueryParam param) {
        QAccountRuleConfigDO jpaQDo = QAccountRuleConfigDO.accountRuleConfigDO;
        QAccountRuleConfigDtlDO jpaDQDo = QAccountRuleConfigDtlDO.accountRuleConfigDtlDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        if (StringUtils.isNotBlank((CharSequence)param.getMultiKeywords())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ExpressionUtils.or((Predicate)jpaQDo.ruleCode.like("%" + param.getMultiKeywords() + "%"), (Predicate)jpaQDo.ruleName.like("%" + param.getMultiKeywords() + "%")));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getOptDoc())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.optDoc.eq((Object)param.getOptDoc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getOptDocType())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaDQDo.optDocType.contains(param.getOptDocType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getOptDocStatus())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaDQDo.optDocStatus.eq((Object)param.getOptDocStatus()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getOptAccountType())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaDQDo.optAccountType.eq((Object)param.getOptAccountType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSpecificAccount())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaDQDo.specificAccount.contains(param.getSpecificAccount()).or((Predicate)jpaDQDo.specificAccount.isNull()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getStatus())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.status.eq((Object)param.getStatus()));
        }
        return predicate;
    }

    public AccountRuleConfigRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

