/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.arorder;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.SecurityUtil;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.facade.param.arorder.ArOrderRecordSaveParam;
import com.elitesland.fin.application.facade.param.arorder.ArOrderSaveParam;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderVO;
import com.elitesland.fin.application.service.arorder.ArOrderService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.domain.param.artype.ArTypePageParam;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.arorder.ArOrderDtlDomainService;
import com.elitesland.fin.domain.service.arorder.ArOrderRecordDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeOuDomainService;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeOuDTO;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ArOrderServiceImpl
implements ArOrderService {
    private static final Logger log = LoggerFactory.getLogger(ArOrderServiceImpl.class);
    private final ArOrderDomainService arOrderDomainService;
    private final ArOrderDtlDomainService arOrderDtlDomainService;
    private final ArTypeDomainService arTypeDomainService;
    private final SystemRpcService systemRpcService;
    private final WorkflowRpcService workflowRpcService;
    private final ArTypeOuDomainService arTypeOuDomainService;
    private final ArOrderRecordDomainService arOrderRecordDomainService;

    @Override
    @SysCodeProc
    public PagingVO<ArOrderVO> page(ArOrderPageParam arOrderPageParam) {
        PagingVO<ArOrderDTO> page = this.arOrderDomainService.page(arOrderPageParam);
        return ArOrderConvert.INSTANCE.convertPage(page);
    }

    @Override
    @SysCodeProc
    public ArOrderVO get(Long id) {
        ArOrderDTO arOrderDTO = this.arOrderDomainService.get(id);
        ArOrderVO res = ArOrderConvert.INSTANCE.convert(arOrderDTO);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> audit(Long id) {
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> refush(List<Long> ids, String content) {
        SysUserDTO user = SecurityUtil.getUser().getUser();
        Long res = this.arOrderDomainService.audit(ids, content, user);
        return ApiResult.ok((Object)res);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> del(List<Long> ids) {
        Long res = this.arOrderDomainService.del(ids);
        return ApiResult.ok((Object)res);
    }

    @Override
    @SysCodeProc
    public ArOrderVO getArOrderAndDtl(Long id) {
        ArOrderDTO arOrderAndDtl = this.arOrderDomainService.getArOrderAndDtl(id);
        ArOrderVO res = ArOrderConvert.INSTANCE.convert(arOrderAndDtl);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(ArOrderSaveParam apOrderSaveParam) {
        if (!apOrderSaveParam.getCreateMode().equals(UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            throw new BusinessException("\u65b0\u589e\u7684\u5355\u636e\u6765\u6e90\u9700\u4e3a\u624b\u5de5");
        }
        ArOrder apOrder = ArOrderConvert.INSTANCE.convert(apOrderSaveParam);
        Long res = this.arOrderDomainService.save(apOrder);
        return ApiResult.ok((Object)res);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public ApiResult<Long> commit(ArOrderSaveParam apOrderSaveParam) {
        ArOrder apOrder = ArOrderConvert.INSTANCE.convert(apOrderSaveParam);
        Boolean isAuto = this.arTypeDomainService.queryIsAuto(apOrderSaveParam.getArTypeId());
        if (isAuto.booleanValue()) {
            apOrder.setAuditDate(LocalDateTime.now());
            apOrder.setAuditUser("admin");
            SysUserDTO user = this.systemRpcService.getUserByName("admin");
            apOrder.setAuditUserId(user.getId());
        }
        Long resId = this.arOrderDomainService.commit(apOrder, isAuto);
        if (!isAuto.booleanValue()) {
            this.startWorkFlow(apOrder, resId);
        }
        return ApiResult.ok((Object)resId);
    }

    private void startWorkFlow(ArOrder apOrder, Long resId) {
        if (apOrder.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(apOrder.getProcInstStatus())) {
            String procInstName = "\u5e94\u6536\u5355\u5ba1\u6838-" + apOrder.getArOrderNo();
            String procKey = WorkFlowDefKey.FIN_AR_ORDER.name();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(procKey, procInstName, resId.toString(), new HashMap<String, Object>());
            this.arOrderDomainService.updateWorkInfo(processInfo, resId);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> update(ArOrderSaveParam apOrderSaveParam) {
        ArOrder apOrder = ArOrderConvert.INSTANCE.convert(apOrderSaveParam);
        apOrder.checkUpdate();
        Long res = this.arOrderDomainService.save(apOrder);
        return ApiResult.ok((Object)res);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Void> autoCreate(ArOrderRecordSaveParam arOrderRecordSaveParam) {
        log.info("\u81ea\u52a8\u751f\u6210\u5e94\u6536\u5355\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)arOrderRecordSaveParam));
        Long arOrderRecordId = this.saveArOrderRecord(arOrderRecordSaveParam);
        this.checkRequired(arOrderRecordSaveParam);
        ArTypePageParam arTypePageParam = new ArTypePageParam();
        arTypePageParam.setSourceDoc(arOrderRecordSaveParam.getCreateMode());
        arTypePageParam.setSourceDocType(arOrderRecordSaveParam.getSourceDocType());
        arTypePageParam.setSourceDocStatus(arOrderRecordSaveParam.getSourceDocStatus());
        List<ArTypeDTO> arTypeDTOList = this.arTypeDomainService.arOrderAutoSelectMatchByParam(arTypePageParam);
        if (CollectionUtil.isEmpty(arTypeDTOList)) {
            log.info("\u672a\u5339\u914d\u5230\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219, \u6765\u6e90\u5355\u636e: {},\u6765\u6e90\u5355\u636e\u7c7b\u578b: {},\u6765\u6e90\u5355\u636e\u72b6\u6001:{}", new Object[]{arOrderRecordSaveParam.getCreateMode(), arOrderRecordSaveParam.getSourceDocType(), arOrderRecordSaveParam.getSourceDocStatus()});
            throw new BusinessException("\u672a\u5339\u914d\u5230\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219");
        }
        if (CollectionUtil.isNotEmpty(arTypeDTOList) && arTypeDTOList.size() > 1) {
            log.info("\u5339\u914d\u5230\u591a\u6761\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219, \u6765\u6e90\u5355\u636e: {},\u6765\u6e90\u5355\u636e\u7c7b\u578b: {},\u6765\u6e90\u5355\u636e\u72b6\u6001:{}", new Object[]{arOrderRecordSaveParam.getCreateMode(), arOrderRecordSaveParam.getSourceDocType(), arOrderRecordSaveParam.getSourceDocStatus()});
            throw new BusinessException("\u5339\u914d\u5230\u591a\u6761\u5e94\u6536\u5355\u7c7b\u578b\u7684\u914d\u7f6e\u89c4\u5219");
        }
        Long arTypeId = arTypeDTOList.get(0).getId();
        List<ArTypeOuDTO> arTypeOuDTOList = this.arTypeOuDomainService.queryByArTypeId(arTypeId);
        if (CollectionUtil.isEmpty(arTypeOuDTOList)) {
            log.info("\u5e94\u6536\u5355\u7684\u5206\u914d\u516c\u53f8\u4e3a\u7a7a, \u5e94\u6536\u5355\u7f16\u7801: {}", (Object)arTypeDTOList.get(0).getArTypeCode());
            throw new BusinessException("\u5e94\u6536\u5355\u7684\u5206\u914d\u516c\u53f8\u4e3a\u7a7a");
        }
        List arTypeOuCodeList = arTypeOuDTOList.stream().map(ArTypeOuDTO::getOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (!arTypeOuCodeList.contains(arOrderRecordSaveParam.getOuCode())) {
            log.info("\u5e94\u6536\u5355\u672a\u5206\u914d\u8be5\u516c\u53f8, \u5e94\u6536\u5355\u7f16\u7801: {},\u516c\u53f8\u7f16\u7801: {}", (Object)arTypeDTOList.get(0).getArTypeCode(), (Object)arOrderRecordSaveParam.getOuCode());
            throw new BusinessException("\u5e94\u6536\u5355\u672a\u5206\u914d\u8be5\u516c\u53f8");
        }
        this.autoCreateArOrder(arOrderRecordSaveParam, arTypeDTOList.get(0));
        return ApiResult.ok();
    }

    private Long saveArOrderRecord(ArOrderRecordSaveParam arOrderRecordSaveParam) {
        Long arOrderRecordId = this.arOrderRecordDomainService.save(arOrderRecordSaveParam);
        return arOrderRecordId;
    }

    private void checkRequired(ArOrderRecordSaveParam arOrderRecordSaveParam) {
        if (StringUtils.isBlank((CharSequence)arOrderRecordSaveParam.getCreateMode())) {
            throw new BusinessException("\u5355\u636e\u6765\u6e90\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)arOrderRecordSaveParam.getSourceDocType())) {
            throw new BusinessException("\u6765\u6e90\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)arOrderRecordSaveParam.getSourceDocStatus())) {
            throw new BusinessException("\u6765\u6e90\u5355\u636e\u72b6\u6001\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)arOrderRecordSaveParam.getOuCode())) {
            throw new BusinessException("\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
        }
    }

    private void autoCreateArOrder(ArOrderRecordSaveParam arOrderRecordSaveParam, ArTypeDTO arTypeDTO) {
        Boolean isAuto = arTypeDTO.getAutoAudit();
        ArOrder apOrder = ArOrderConvert.INSTANCE.convertRecord(arOrderRecordSaveParam);
        if (isAuto.booleanValue()) {
            apOrder.setAuditDate(LocalDateTime.now());
            apOrder.setAuditUser("admin");
            SysUserDTO user = this.systemRpcService.getUserByName("admin");
            apOrder.setAuditUserId(user.getId());
            Long l = this.arOrderDomainService.commit(apOrder, isAuto);
        } else {
            Long l = this.arOrderDomainService.save(apOrder);
        }
    }

    @Override
    public void jobAutoCreate(String param) {
        if (StringUtils.isNotBlank((CharSequence)param)) {
            JSONObject jSONObject = JSONObject.parseObject((String)param);
        }
    }

    public ArOrderServiceImpl(ArOrderDomainService arOrderDomainService, ArOrderDtlDomainService arOrderDtlDomainService, ArTypeDomainService arTypeDomainService, SystemRpcService systemRpcService, WorkflowRpcService workflowRpcService, ArTypeOuDomainService arTypeOuDomainService, ArOrderRecordDomainService arOrderRecordDomainService) {
        this.arOrderDomainService = arOrderDomainService;
        this.arOrderDtlDomainService = arOrderDtlDomainService;
        this.arTypeDomainService = arTypeDomainService;
        this.systemRpcService = systemRpcService;
        this.workflowRpcService = workflowRpcService;
        this.arTypeOuDomainService = arTypeOuDomainService;
        this.arOrderRecordDomainService = arOrderRecordDomainService;
    }
}

