/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.arorder;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.convert.arorder.ArOrderDtlConvert;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.entity.arorder.ArOrderDO;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtl;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtlDO;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.domain.param.arorder.ArOrderParam;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.dto.common.ArVerDTO;
import com.elitesland.fin.infr.factory.arorder.ArOrderFactory;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.workflow.ProcessInfo;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ArOrderDomainServiceImpl
implements ArOrderDomainService {
    private final ArOrderRepo arOrderRepo;
    private final ArOrderRepoProc arOrderRepoProc;
    private final ArOrderDtlRepoProc arOrderDtlRepoProc;
    private final ArOrderDtlRepo arOrderDtlRepo;
    private final ArOrderFactory arOrderFactory;
    private final SeqNumProvider sysNumberRuleService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ArOrder arOrder) {
        if (arOrder.getVerAmt() == null) {
            arOrder.setDef();
        }
        arOrder.check();
        arOrder.checkDtlList();
        arOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        if (arOrder.getCreateMode().equals(UdcEnum.FIN_AR_DOC_CLS_SO.getValueCode())) {
            arOrder.setSoDef();
            arOrder.countBySo();
        }
        ArOrderDO apOrderRes = this.saveOrUpdate(arOrder);
        return apOrderRes.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public ArOrderDO saveOrUpdate(ArOrder arOrder) {
        ArOrderDO apOrderDO;
        if (CharSequenceUtil.isBlank((CharSequence)arOrder.getArOrderNo())) {
            String apOrderNo = this.sysNumberRuleService.generateCode("yst-fin", "YSD", null);
            arOrder.setArOrderNo(apOrderNo);
        }
        if ((apOrderDO = ArOrderConvert.INSTANCE.convert(arOrder)).getId() == null) {
            apOrderDO.setAuditDataVersion(0);
        }
        ArOrderDO apOrderRes = (ArOrderDO)this.arOrderRepo.save(apOrderDO);
        this.arOrderDtlRepoProc.delByMasId(Lists.newArrayList((Object[])new Long[]{apOrderRes.getId()}));
        List<ArOrderDtl> apOrderDtlList = arOrder.getDtlList();
        List<ArOrderDtlDO> apOrderDtlDOS = ArOrderDtlConvert.INSTANCE.convert(apOrderDtlList);
        apOrderDtlDOS.stream().forEach(x -> {
            x.setMasId(apOrderRes.getId());
            this.arOrderDtlRepo.save(x);
        });
        return apOrderRes;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long commit(ArOrder arOrder, Boolean auto) {
        arOrder.check();
        arOrder.checkDtlList();
        arOrder.checkAmt();
        arOrder.checkAmtSum();
        if (arOrder.getVerAmt() == null) {
            arOrder.setDef();
        }
        if (auto.booleanValue()) {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
            arOrder.setProposedStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());
        } else {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
        }
        ArOrderDO arOrderDO = this.saveOrUpdate(arOrder);
        return arOrderDO.getId();
    }

    @Override
    public ArOrderDTO getArOrderAndDtl(Long id) {
        ArOrderDTO apOrderDTO = this.get(id);
        List<ArOrderDtlDTO> apOrderDtlDOS = this.arOrderDtlRepoProc.listByMisId(id);
        apOrderDTO.setArOrderDtlDTOList(apOrderDtlDOS);
        return apOrderDTO;
    }

    @Override
    public Boolean queryByArTypeId(Long arTypeId) {
        return this.arOrderRepoProc.queryByArTypeId(arTypeId);
    }

    @Override
    public List<ArOrderDTO> getArOrderList(ArOrderParam arOrderParam) {
        List<ArOrderDTO> res = this.arOrderRepoProc.getArOrderList(arOrderParam);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateVerAmt(Long id, BigDecimal amt) {
        ArVerDTO arVerDTO = this.arOrderRepoProc.queryVerAmtById(id);
        BigDecimal totalAmt = arVerDTO.getTotalAmt();
        if (arVerDTO.getVerAmt().add(amt).compareTo(totalAmt) > 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u6838\u9500\u91d1\u989d\u5927\u4e8e\u5e94\u6536\u5355\u91d1\u989d\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u8f93\u5165");
        }
        arVerDTO.setAmtAndVerState(amt);
        long rows = this.arOrderRepoProc.updateVerAmt(arVerDTO);
        if (rows == 0L) {
            throw new BusinessException("\u5e94\u4ed8\u5355\u66f4\u65b0\u5df2\u6838\u9500\u91d1\u989d\u5931\u8d25");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateWorkInfo(ProcessInfo processInfo, Long resId) {
        this.arOrderRepoProc.updateWorkInfo(processInfo, resId);
    }

    @Override
    public PagingVO<ArOrderDTO> page(ArOrderPageParam arOrderPageParam) {
        PagingVO<ArOrderDTO> res = this.arOrderFactory.page(arOrderPageParam);
        return res;
    }

    @Override
    public ArOrderDTO get(Long id) {
        ArOrderDTO arOrderDTO = this.arOrderRepoProc.get(id);
        return arOrderDTO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long audit(List<Long> ids, String content, SysUserDTO user) {
        Long res = this.arOrderRepoProc.audit(ids, content, user);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        List<ArOrderDTO> arOrderDTOS = this.arOrderRepoProc.queryByIds(ids);
        arOrderDTOS.stream().forEach(x -> {
            if (!x.getOrderState().equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
                throw new BusinessException("\u975e\u8349\u7a3f\u72b6\u6001\u4e0d\u80fd\u5220\u9664");
            }
        });
        Long res = this.arOrderRepoProc.del(ids);
        this.arOrderDtlRepoProc.delByMasId(ids);
        return res;
    }

    public ArOrderDomainServiceImpl(ArOrderRepo arOrderRepo, ArOrderRepoProc arOrderRepoProc, ArOrderDtlRepoProc arOrderDtlRepoProc, ArOrderDtlRepo arOrderDtlRepo, ArOrderFactory arOrderFactory, SeqNumProvider sysNumberRuleService) {
        this.arOrderRepo = arOrderRepo;
        this.arOrderRepoProc = arOrderRepoProc;
        this.arOrderDtlRepoProc = arOrderDtlRepoProc;
        this.arOrderDtlRepo = arOrderDtlRepo;
        this.arOrderFactory = arOrderFactory;
        this.sysNumberRuleService = sysNumberRuleService;
    }
}

