package com.elitesland.fin.application.facade.dto.limitadjustorder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseWorkflowModelDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Data
public class LimitAdjustOrderDTO extends BaseWorkflowModelDTO {

    @ApiModelProperty(value = "单号")
    private String docNo;

    @ApiModelProperty(value = "状态")
    @SysCode(sys = "yst-fin",mod = "APPLY_STATUS")
    private String docState;
    private String docStateName;

    @ApiModelProperty(value = "授信类型")
    @SysCode(sys = "yst-fin",mod = "CREDIT_TYPE")
    private String creditType;
    private String creditTypeName;

    @ApiModelProperty(value = "调整类型")
    @SysCode(sys = "yst-fin",mod = "ADJUST_TYPE")
    private String adjustType;
    private String adjustTypeName;

    @ApiModelProperty(value = "效期至")
    private LocalDateTime expireTime;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "部门编码")
    private String buCode;

    @ApiModelProperty(value = "部门名称")
    private String buName;

    @ApiModelProperty(value = "产品线")
    private String productLine;

    @ApiModelProperty(value = "业务员")
    private String saleUser;

    @ApiModelProperty(value = "对象类型 客户/客户组")
    @SysCode(sys = "yst-fin",mod = "OBJECT_TYPE")
    private String objectType;
    private String objectTypeName;

    @ApiModelProperty(value = "对象名称 客户/客户组名称")
    private String objectName;

    @ApiModelProperty(value = "信用账户编码")
    private String creditAccountCode;

    @ApiModelProperty(value = "信用账户名称")
    private String creditAccountName;

    @ApiModelProperty(value = "调整额度")
    private BigDecimal adjustLimit;

    @ApiModelProperty(value = "调整原因")
    @SysCode(sys = "yst-fin",mod = "ADJUST_REASON")
    private String adjustReason;
    private String adjustReasonName;

    @ApiModelProperty(value = "审核人")
    private String auditUser;

    @ApiModelProperty(value = "审核时间")
    private LocalDateTime auditTime;

    @ApiModelProperty(value = "审核拒绝理由")
    private String auditRejectReason;

    @ApiModelProperty("附件编码")
    private String fileCode;

    @ApiModelProperty("效期起")
    private LocalDateTime effectiveTime;

}