package com.elitesland.fin.application.facade.param.arorder;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.param.arorder
 * @date 2022/4/12 17:29
 */
@Data
public class ArOrderDtlSaveParam implements Serializable {

    private static final long serialVersionUID = -8119774515716084630L;
    @ApiModelProperty(value = "主键ID")
    private Long id;

    @ApiModelProperty(value = "总单ID")
    private Long masId;

    @ApiModelProperty(value = "来源单号")
    private String sourceNo;

    @ApiModelProperty(value = "来源行号")
    private Integer sourceLine;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "规格型号")
    private String itemType;

    @ApiModelProperty(value = "小类编码")
    private String smallCateCode;

    @ApiModelProperty(value = "小类名称")
    private String smallCateName;

    @ApiModelProperty(value = "计量单位")
    private String uom;

    @ApiModelProperty(value = "计量单位名称")
    private String uomName;

    @ApiModelProperty(value = "数量")
    private BigDecimal qty;

    @ApiModelProperty(value = "单价")
    private BigDecimal exclTaxPrice;

    @ApiModelProperty(value = "含税单价")
    private BigDecimal price;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty(value = "不含税总金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty(value = "税额")
    private BigDecimal taxAmt;

    @ApiModelProperty(value = "含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty(value = "不含税总金额(本位币)")
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty(value = "税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty(value = "部门编码")
    private String buCode;

    @ApiModelProperty(value = "部门ID")
    private Long buId;

    @ApiModelProperty(value = "部门名称")
    private String buName;

    @ApiModelProperty(value = "费用类型")
    private String expensesType;

    @ApiModelProperty(value = "备注")
    private String remark;
}
