package com.elitesland.fin.application.service.creditaccount;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.convert.creditaccount.CreditSettingConvert;
import com.elitesland.fin.application.facade.param.creditaccount.CreditSettingParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditSettingDetailVO;
import com.elitesland.fin.entity.creditaccount.CreditSettingDO;
import com.elitesland.fin.repo.creditaccount.CreditSettingRepo;
import com.elitesland.fin.repo.creditaccount.CreditSettingRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
public class CreditSettingServiceImpl implements CreditSettingService {

    private final CreditSettingRepo creditSettingRepo;
    private final CreditSettingRepoProc creditSettingRepoProc;

    @Override
    public CreditSettingDetailVO detail() {
        CreditSettingDetailVO detailVO = creditSettingRepoProc.findAll();
        return detailVO;
    }

    @Override
    public Long saveOrUpdate(CreditSettingParam param) {
        Assert.notBlank(param.getGeneralParam(), "常规参数设置不能为空");
        CreditSettingDetailVO detailVO = creditSettingRepoProc.findAll();
        if (ObjectUtil.isNotNull(detailVO) && ObjectUtil.equals(detailVO.getEnableFlag(), Boolean.TRUE)) {
            throw new BusinessException("参数已经设置过，不能重复设置");
        }
        CreditSettingDO saveDo = CreditSettingConvert.INSTANCE.saveParam2Do(param);
        saveDo.setEnableFlag(Boolean.TRUE);
        CreditSettingDO save = creditSettingRepo.save(saveDo);
        return save.getId();
    }
}
