package com.elitesland.fin.application.web.adjustorder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.adjustorder.AdjustOrderPageParam;
import com.elitesland.fin.application.facade.param.adjustorder.AdjustOrderParam;
import com.elitesland.fin.application.facade.vo.adjustorder.AdjustOrderVO;
import com.elitesland.fin.application.service.adjustorder.AdjustOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/2/25 10:08
 */
@RestController
@RequestMapping("/fin/adjust")
@RequiredArgsConstructor
@Api(value = "调整单", tags = {"调整单"})
public class AdjustOrderController {
    private final AdjustOrderService adjustOrderService;
    @PostMapping("/save")
    @ApiOperation("新增调整单")
    public ApiResult<Long> save(@RequestBody AdjustOrderParam adjustOrderParam) {
        return ApiResult.ok(adjustOrderService.save(adjustOrderParam));
    }

    @PostMapping("/update")
    @ApiOperation("修改调整单")
    public ApiResult<Long> update(@RequestBody AdjustOrderParam adjustOrderParam) {
         return ApiResult.ok(adjustOrderService.update(adjustOrderParam));
    }

    @GetMapping("/submit/{id}")
    @ApiOperation("提交调整单")
    public ApiResult<Long> submit(@PathVariable("id") Long id) {
        return ApiResult.ok(adjustOrderService.submit(id));
    }

    @PostMapping("/page")
    @ApiOperation("分页查询调整单")
    public ApiResult<PagingVO<AdjustOrderVO>> page(@RequestBody AdjustOrderPageParam adjustOrderPageParam) {
        return ApiResult.ok(adjustOrderService.page(adjustOrderPageParam));
    }

    @GetMapping("/getOne/{id}")
    @ApiOperation("调整单详情")
    public ApiResult<AdjustOrderVO> getOne(@PathVariable("id") Long id) {
         return ApiResult.ok(adjustOrderService.getOne(id));
    }

    @PostMapping("/approve")
    @ApiOperation("批量审批调整单")
    public ApiResult<List<Long>> approve(@RequestBody List<Long> ids) {
        return ApiResult.ok(adjustOrderService.approve(ids));
    }

    @PostMapping("/reject")
    @ApiOperation("审批拒绝调整单")
    public ApiResult<List<Long>> reject(@RequestBody AdjustOrderParam adjustOrderParam) {
         return ApiResult.ok(adjustOrderService.reject(adjustOrderParam));
    }
}
