package com.elitesland.fin.application.web.arorder;

import com.elitesland.fin.application.facade.param.arorder.ArOrderRecordSaveParam;
import com.elitesland.fin.application.facade.param.arorder.ArOrderSaveParam;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderDtlVO;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderVO;
import com.elitesland.fin.application.service.arorder.ArOrderDtlService;
import com.elitesland.fin.application.service.arorder.ArOrderService;
import com.elitesland.fin.domain.param.arorder.ArOrderDtlPageParam;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.web.arorder
 * @date 2022/4/12 13:18
 */
@RestController
@RequestMapping("/fin/arOrder")
@RequiredArgsConstructor
@Api(value = "应收单", tags = {"应收单"})
public class ArOrderController {

    private final ArOrderService arOrderService;
    private final ArOrderDtlService arOrderDtlService;

    @PostMapping("page")
    @ApiOperation("应收单列表查询")
    public ApiResult<PagingVO<ArOrderVO>> page(@RequestBody ArOrderPageParam arOrderPageParam) {
        PagingVO<ArOrderVO> res = arOrderService.page(arOrderPageParam);
        return ApiResult.ok(res);
    }

    @GetMapping("get")
    @ApiOperation("获取单个应收单详情")
    public ApiResult<ArOrderVO> get(Long id) {
        ArOrderVO res = arOrderService.get(id);
        return ApiResult.ok(res);
    }

    @PostMapping("dtlPage")
    @ApiOperation("分页查询明细信息")
    public ApiResult<PagingVO<ArOrderDtlVO>> detailPage(@RequestBody ArOrderDtlPageParam arOrderDtlPageParam) {
        PagingVO<ArOrderDtlVO> res = arOrderDtlService.page(arOrderDtlPageParam);
        return ApiResult.ok(res);
    }

    @DeleteMapping("del")
    @ApiOperation("删除应收单")
    public ApiResult<Long> del(@RequestBody List<Long> ids) {
        ApiResult<Long> res = arOrderService.del(ids);
        return res;
    }

    @GetMapping("getForDtl")
    @ApiOperation("获取应付单详情和明细信息汇总信息")
    public ApiResult<ArOrderVO> getForDtl(Long id) {
        ArOrderVO res = arOrderService.getArOrderAndDtl(id);
        return ApiResult.ok(res);
    }

    @PostMapping("save")
    @ApiOperation("新增-应收单")
    public ApiResult<Long> save(@RequestBody ArOrderSaveParam arOrderSaveParam) {
        return arOrderService.save(arOrderSaveParam);
    }

    @PostMapping("update")
    @ApiOperation("修改-应收单")
    public ApiResult<Long> update(@RequestBody ArOrderSaveParam arOrderSaveParam) {
        return arOrderService.update(arOrderSaveParam);
    }

    @PostMapping("commit")
    @ApiOperation("提交-应收单")
    public ApiResult<Long> commit(@RequestBody ArOrderSaveParam arOrderSaveParam) {
        return arOrderService.commit(arOrderSaveParam);
    }

    @PostMapping("autoCreate")
    @ApiOperation("自动生成应收单")
    public ApiResult<Void> autoCreate(@RequestBody ArOrderRecordSaveParam arOrderRecordSaveParam) {
        return arOrderService.autoCreate(arOrderRecordSaveParam);
    }

}
