package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_event_table")
@org.hibernate.annotations.Table(appliesTo = "fin_event_table", comment = "事件表单")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinEventTableDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "event_table", columnDefinition = "varchar(20) comment '事件表单名称'")
    private String eventTable;

    @Column(name = "host", columnDefinition = "varchar(32) comment '主机'")
    private String host;

    @Column(name = "port", columnDefinition = "varchar(32) comment '端口'")
    private String port;

    @Column(name = "user_name", columnDefinition = "varchar(32) comment '用户名'")
    private String userName;

    @Column(name = "password", columnDefinition = "varchar(32) comment '密码'")
    private String password;

    @Column(name = "database_name", columnDefinition = "varchar(32) comment '数据库名称'")
    private String databaseName;

    @Column(name = "mas_table", columnDefinition = "varchar(32) comment '主表'")
    private String masTable;

    @Column(name = "table_name", columnDefinition = "varchar(32) comment '子表'")
    private String tableName;

    @Column(name = "mas_table_column", columnDefinition = "varchar(32) comment '主表条件字段'")
    private String masTableColumn;

    @Column(name = "table_column", columnDefinition = "varchar(32) comment '子表条件字段'")
    private String tableColumn;

    @Column(name = "status", columnDefinition = "varchar(32) comment '状态'")
    private String status;
}
