package com.elitesland.fin.domain.entity.arorder;

import cn.hutool.core.lang.Assert;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.entity.arorder
 * @date 2022/4/12 16:43
 */
@Data
public class ArOrder {


    private Long id;

    private String sourceNo;

    private String arOrderNo;

    private String ouCode;

    private Long ouId;

    private String ouName;

    private String createMode;

    private Long arTypeId;

    private String arTypeName;

    private String arTypeCode;

    private String orderState;

    private LocalDateTime buDate;

    private BigDecimal totalAmt;

    private BigDecimal exclTaxAmt;

    private BigDecimal taxAmt;

    private BigDecimal totalCurAmt;

    private BigDecimal exclTaxCurAmt;

    private BigDecimal taxCurAmt;

    private String currCode;

    private String currName;

    private String localCurrCode;

    private String localCurrName;

    private Long auditUserId;

    private String auditUser;

    private LocalDateTime auditDate;

    private BigDecimal exchangeRate;

    private Long operUserId;

    private String operator;

    private Boolean taxFlag;

    private Boolean initFlag;

    private String auditRejection;

    private Long custId;

    private String custCode;

    private String custName;

    private Long buId;

    private String buCode;

    private String buName;

    private String buType;

    private String verState;

    private BigDecimal verAmt;

    private Long orgId;

    private String orgCode;

    private String orgName;

    private Long saleUserId;

    private String saleUser;

    private String arOrderType;

    private String creator;

    private String remark;

    private Integer auditDataVersion;

    private String procInstId;

    private ProcInstStatus procInstStatus;

    private LocalDateTime submitTime;

    private LocalDateTime approvedTime;

    private List<ArOrderDtl> dtlList;

    private String docType;

    private String docType2;

    private String docCls;

    @ApiModelProperty("扩展表关联字段")
    private Long relateId;

//    @ApiModelProperty("订单客户")
//    private String es1;
//
//    @ApiModelProperty("发票号")
//    private String es2;
//
//    @ApiModelProperty("开票日期")
//    private LocalDateTime es3;
//
//    @ApiModelProperty("发票类型")
//    private String es4;
//
//    @ApiModelProperty("起算日期")
//    private LocalDateTime es5;
//
//    @ApiModelProperty("红冲标志")
//    private String es6;
//
//    @ApiModelProperty("开票备注")
//    private String es7;
//
//    @ApiModelProperty("第三方支付辅助")
//    private String es8;
//
//    @ApiModelProperty("消费卡辅助")
//    private String es9;
//
//    @ApiModelProperty("信用卡辅助")
//    private String es10;

    @ApiModelProperty("结算方式")
    private String settlementType;
    @ApiModelProperty("拟定状态")
    private String proposedStatus;

    /**
     * 校验字段
     */
    public void check() {
        // 手工校验 应收单类型
        if (this.createMode.equals(UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            // 应收单类型
            Assert.notNull(this.arTypeId, "应收单 arTypeId is null");
            Assert.notEmpty(this.arTypeCode, "应收单 arTypeCode is null");
            Assert.notEmpty(this.arTypeName, "应收单 arTypeName is null");
            // 含税金额
            Assert.notNull(this.totalAmt, "含税金额 totalAmt is null");
            Assert.notNull(this.totalCurAmt, "含税金额(本位币) totalCurAmt is null");
            // 不含税金额
            Assert.notNull(this.exclTaxAmt, "不含税金额 exclTaxAmt is null");
            Assert.notNull(this.exclTaxCurAmt, "不含税金额(本位币) exclTaxCurAmt is null");
            // 税额
            Assert.notNull(this.taxAmt, "税额 taxAmt is null");
            Assert.notNull(this.taxCurAmt, "税额(本位币) taxCurAmt is null");
            // 币种
            Assert.notEmpty(this.currName, "币种 currName is null");
            Assert.notEmpty(this.currCode, "币种 currCode is null");
            // 公司
            Assert.notNull(this.ouId, "公司 ouId is null");
            Assert.notEmpty(this.ouCode, "公司 ouCode is null");
            Assert.notEmpty(this.ouName, "公司 ouName is null");
            // 业务日期
            Assert.notNull(this.buDate, "业务日期 buDate is null");
            // 汇率
            Assert.notNull(this.exchangeRate, "汇率 exchangeRate is null");
            // 客户
            Assert.notNull(this.custId, "客户 custId is null");
            Assert.notEmpty(this.custCode, "客户 custCode is null");
            Assert.notEmpty(this.custName, "客户 custName is null");
            // 本位币
            Assert.notNull(this.localCurrCode, "本位币 localCurrCode is null");
            Assert.notNull(this.localCurrName, "本位币 localCurrName is null");
        }
        // 销售订单
        if (this.createMode.equals(UdcEnum.FIN_AR_DOC_CLS_SO.getValueCode())) {
            Assert.notNull(this.buDate, "业务日期 buDate is null");
            Assert.notNull(this.exchangeRate, "汇率 exchangeRate is null");
            Assert.notEmpty(this.currName, "币种 currName is null");
            Assert.notEmpty(this.currCode, "币种 currCode is null");
            Assert.notNull(this.ouId, "公司 ouId is null");
            Assert.notEmpty(this.ouCode, "公司 ouCode is null");
            Assert.notEmpty(this.ouName, "公司 ouName is null");
            Assert.notNull(this.orgId, "组织 orgId is null");
            Assert.notNull(this.orgCode, "组织 orgCode is null");
            Assert.notEmpty(this.orgName, "组织 orgName is null");
            Assert.notEmpty(this.docType, "docType is null");
            Assert.notEmpty(this.docType2, "docType2 is null");
            Assert.notEmpty(this.docCls, "docCls is null");
            if (this.docType2.equals("B")) {
                Assert.notNull(this.custId, "客户 custId is null");
                Assert.notEmpty(this.custCode, "客户 custCode is null");
            }
            Assert.notEmpty(this.custName, "客户 custName is null");
            Assert.notNull(this.localCurrCode, "本位币 localCurrCode is null");
            Assert.notNull(this.localCurrName, "本位币 localCurrName is null");
        }

    }

    /**
     * 验证应付单明细信息
     */
    public void checkDtlList() {
        // 明细信息为空
        Assert.notNull(this.dtlList, "dtlList is null");
        // 校验Dtl必填校验
        this.dtlList.stream().forEach(x -> {
            x.check(this.createMode);
        });
    }


    public void setDef() {
        this.verState = UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode();
        this.verAmt = new BigDecimal("0");
    }

    /**
     * 校验明细行金额数据
     */
    public void checkAmt() {
        Assert.notNull(exchangeRate, "exchangeRate不能为空");
        this.count();
    }

    private void count() {
        for (ArOrderDtl arOrderDtl : dtlList) {
            Assert.notNull(arOrderDtl.getTaxRate(), "taxRate税率不能为空");
            Assert.notNull(arOrderDtl.getQty(), "qty数量不能为空");
            Assert.notNull(arOrderDtl.getExclTaxPrice(), "exclTaxPrice单价（不含税）不能为空");
            Assert.notNull(arOrderDtl.getPrice(), "price单价不能为空");
            // 税率
            BigDecimal taxRate = arOrderDtl.getTaxRate();
            // 数量
            BigDecimal qty = arOrderDtl.getQty();
            // 单价(不含税)
            BigDecimal exclTaxPrice = arOrderDtl.getExclTaxPrice();
            BigDecimal countPrice = arOrderDtl.getPrice();
            taxCount(arOrderDtl, taxRate, qty, exclTaxPrice, countPrice);
        }
    }

    private void taxCount(ArOrderDtl arOrderDtl, BigDecimal taxRate, BigDecimal qty, BigDecimal exclTaxPrice, BigDecimal countPrice) {
        if (taxFlag) {
            exclTaxPrice = countPrice.divide(taxRate.add(new BigDecimal(1)), 6, RoundingMode.HALF_UP);
        } else {
            countPrice = exclTaxPrice.multiply(taxRate.add(new BigDecimal(1))).setScale(6, RoundingMode.HALF_UP);
        }
        // 不含税单价 = 不含税单价 *（1+税率）
        if (exclTaxPrice.compareTo(arOrderDtl.getExclTaxPrice()) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行不含税单价不相等!");
        }
        // 含税单价 = 含税单价 *（1+税率）
        if (countPrice.compareTo(arOrderDtl.getPrice()) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行含税单价不相等!");
        }
        // 不含税金额=不含税单价*数量
        BigDecimal countExclTaxAmt = exclTaxPrice.multiply(qty).setScale(2, RoundingMode.HALF_UP);
        if (countExclTaxAmt.compareTo(arOrderDtl.getExclTaxAmt()) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行不含税金额不相等!");
        }
        // 税额 =round((不含税金额)*税率),2)
        BigDecimal countTaxAmt = countExclTaxAmt.multiply(taxRate).setScale(2, RoundingMode.HALF_UP);
        if (countTaxAmt.compareTo(arOrderDtl.getTaxAmt()) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行税额不相等!");
        }
        // 含税金额=不含税金额+税额
        BigDecimal countTotalAmt = countExclTaxAmt.add(countTaxAmt).setScale(2, RoundingMode.HALF_UP);
        if (countTotalAmt.compareTo(arOrderDtl.getTotalAmt()) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行含税金额不相等!");
        }
        // 不含税金额(本位币)=不含税金额*汇率
        BigDecimal countExclTaxCurAmt = countExclTaxAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
        if (countExclTaxCurAmt.compareTo(arOrderDtl.getExclTaxCurAmt()) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行不含税金额(本位币)不相等!");
        }
        // 税额(本位币)=税额*汇率
        BigDecimal countTaxCurAmt = countTaxAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
        if (countTaxCurAmt.compareTo(arOrderDtl.getTaxCurAmt()) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行税额(本位币)不相等!");
        }
        // 含税金额(本位币)=不含税金额本位币+税额本位币
        BigDecimal countTotalCurAmt = countExclTaxCurAmt.add(countTaxCurAmt).setScale(2, RoundingMode.HALF_UP);
        if (countTotalCurAmt.compareTo(arOrderDtl.getTotalCurAmt()) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行含税金额(本位币)不相等!");
        }
    }

    /**
     * 校验单头/明细/汇总金额
     */
    public void checkAmtSum() {
        // 计算明细的汇总和
        // 税额的总和
        BigDecimal taxAmtSum = this.dtlList.stream().map(ArOrderDtl::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        // 税额（本位币）taxCurAmt
        BigDecimal taxCurAmtSum = this.dtlList.stream().map(ArOrderDtl::getTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        // 不含税金额 exclTaxAmt
        BigDecimal exclTaxAmtSum = this.dtlList.stream().map(ArOrderDtl::getExclTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        // 不含税金额（本位币）exclTaxCurAmt
        BigDecimal exclTaxCurAmtSum = this.dtlList.stream().map(ArOrderDtl::getExclTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        // 含税金额 totalAmt
        BigDecimal totalAmtSum = this.dtlList.stream().map(ArOrderDtl::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        // 含税金额（本位币）totalCurAmt
        BigDecimal totalCurAmtSum = this.dtlList.stream().map(ArOrderDtl::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);

        // 对比单头信息与明细总和
        if (totalAmt.compareTo(totalAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行含税金额之和与单头含税金额不相等!");
        }
        if (totalCurAmt.compareTo(totalCurAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行含税金额(本位币)之和与单头含税金额(本位币)不相等!");
        }
        if (exclTaxAmt.compareTo(exclTaxAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行不含税金额之和与单头不含税金额不相等!");
        }
        if (exclTaxCurAmt.compareTo(exclTaxCurAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行不含税金额(本位币)之和与单头不含税金额(本位币)不相等!");
        }
        if (taxAmt.compareTo(taxAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行税额之和与单头税额不相等!");
        }
        if (taxCurAmt.compareTo(taxCurAmtSum) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行税额(本位币)之和与单头税额(本位币)不相等!");
        }
    }

    /**
     * 更新接口校验
     */
    public void checkUpdate() {
        Assert.notNull(this.id, "主键id不能为空");
        if (!this.orderState.equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
            throw new BusinessException("非草稿状态不能进行修改操作");
        }
    }

    /**
     * 销售订单默认设置
     */
    public void setSoDef() {
        this.taxFlag = true;
        this.initFlag = false;
        if (null == this.buDate) {
            this.buDate = LocalDateTime.now();
        }
    }

    public void countBySo() {
        // 计算明细数据
        for (ArOrderDtl arOrderDtl : this.dtlList) {
            // 不含税金额(本位币)=不含税金额*汇率
            BigDecimal countExclTaxCurAmt = arOrderDtl.getExclTaxAmt().multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
            arOrderDtl.setExclTaxCurAmt(countExclTaxCurAmt);
            // 税额(本位币)=税额*汇率
            BigDecimal countTaxCurAmt = arOrderDtl.getTaxAmt().multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
            arOrderDtl.setTaxCurAmt(countTaxCurAmt);
            // 含税金额(本位币)=不含税金额本位币+税额本位币
            BigDecimal countTotalCurAmt = countExclTaxCurAmt.add(countTaxCurAmt).setScale(2, RoundingMode.HALF_UP);
            arOrderDtl.setTotalCurAmt(countTotalCurAmt);
        }
        // 计算单头数据
        // 税额的总和
        BigDecimal taxAmtSum = this.dtlList.stream().map(ArOrderDtl::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        this.taxAmt = taxAmtSum;
        // 税额（本位币）taxCurAmt
        BigDecimal taxCurAmtSum = this.dtlList.stream().map(ArOrderDtl::getTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        this.taxCurAmt = taxCurAmtSum;
        // 不含税金额 exclTaxAmt
        BigDecimal exclTaxAmtSum = this.dtlList.stream().map(ArOrderDtl::getExclTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        this.exclTaxAmt = exclTaxAmtSum;
        // 不含税金额（本位币）exclTaxCurAmt
        BigDecimal exclTaxCurAmtSum = this.dtlList.stream().map(ArOrderDtl::getExclTaxCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        this.exclTaxCurAmt = exclTaxCurAmtSum;
        // 含税金额 totalAmt
        BigDecimal totalAmtSum = this.dtlList.stream().map(ArOrderDtl::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        this.totalAmt = totalAmtSum;
        // 含税金额（本位币）totalCurAmt
        BigDecimal totalCurAmtSum = this.dtlList.stream().map(ArOrderDtl::getTotalCurAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        this.totalCurAmt = totalCurAmtSum;

    }
}
