package com.elitesland.fin.repo.accountingengine;

import com.elitesland.fin.domain.entity.accountingengine.QFinAccountEngineDetailsDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Component
@RequiredArgsConstructor
public class FinAccountEngineDetailsRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QFinAccountEngineDetailsDO qFinAccountEngineDetailsDO = QFinAccountEngineDetailsDO.finAccountEngineDetailsDO;

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qFinAccountEngineDetailsDO.id,
                qFinAccountEngineDetailsDO.masId,
                qFinAccountEngineDetailsDO.serialNum,
                qFinAccountEngineDetailsDO.accountEngine,
                qFinAccountEngineDetailsDO.activeFlag,

                qFinAccountEngineDetailsDO.createTime,
                qFinAccountEngineDetailsDO.creator,
                qFinAccountEngineDetailsDO.modifyTime,
                qFinAccountEngineDetailsDO.updater
        )).from(qFinAccountEngineDetailsDO);
    }

}
