package com.elitesland.fin.repo.accountingengine;


import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinEventTableConditionConvert;
import com.elitesland.fin.application.convert.accountingengine.FinEventTableLineConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinEventTableConditionDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinEventTableDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinEventTableLineDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinEventTableLineParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinEventTableParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinEventTableLineVO;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.domain.entity.accountingengine.QFinEventTableLineDO;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

@Component
@RequiredArgsConstructor
public class FinEventTableLineRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QFinEventTableLineDO qFinEventTableLineDO = QFinEventTableLineDO.finEventTableLineDO;
    public PagingVO<FinEventTableLineDTO> page(FinEventTableLineParam finEventTableLineParam) {
        Predicate where = where(finEventTableLineParam);
        JPAQuery<FinEventTableLineDTO> query = select(FinEventTableLineDTO.class).where(ExpressionUtils.allOf(where));
        finEventTableLineParam.setPaging(query);
        finEventTableLineParam.fillOrders(query, qFinEventTableLineDO);
        List<FinEventTableLineDTO> finEventTableLineDTOList = query.fetch();
        return PagingVO.<FinEventTableLineDTO>builder()
                .total(query.fetchCount())
                .records(finEventTableLineDTOList)
                .build();
    }
    private Predicate where(FinEventTableLineParam finEventTableLineParam) {
        return BaseRepoProc.PredicateBuilder.builder()
                .andEq(finEventTableLineParam.getMasId() != null, qFinEventTableLineDO.masId, finEventTableLineParam.getMasId())
                .andLike(StringUtils.isNotEmpty(finEventTableLineParam.getTableName()), qFinEventTableLineDO.tableName, finEventTableLineParam.getTableName())
                .andLike(StringUtils.isNotEmpty(finEventTableLineParam.getColumnName()), qFinEventTableLineDO.columnName, finEventTableLineParam.getColumnName())
                .andLike(StringUtils.isNotEmpty(finEventTableLineParam.getColumnType()), qFinEventTableLineDO.columnType, finEventTableLineParam.getColumnType())
                .andLike(StringUtils.isNotEmpty(finEventTableLineParam.getColumnComment()), qFinEventTableLineDO.columnComment, finEventTableLineParam.getColumnComment())
                .build();
    }
    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qFinEventTableLineDO.id,
                qFinEventTableLineDO.masId,
                qFinEventTableLineDO.tableName,
                qFinEventTableLineDO.columnComment,
                qFinEventTableLineDO.columnName,
                qFinEventTableLineDO.columnType,
                qFinEventTableLineDO.remark,
                qFinEventTableLineDO.deleteFlag,
                qFinEventTableLineDO.createTime,
                qFinEventTableLineDO.creator,
                qFinEventTableLineDO.modifyTime,
                qFinEventTableLineDO.updater
        )).from(qFinEventTableLineDO);
    }
}
