package com.elitesland.fin.repo.flowrepair;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.flowrepair.AccountFlowRepairPageParam;
import com.elitesland.fin.application.facade.vo.flowrepair.AccountFlowRepairVO;
import com.elitesland.fin.entity.flowrepair.QAccountFlowRepairDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/10/25
 * @Version 1.0
 * @Content:
 */
@Component
@RequiredArgsConstructor
public class AccountFlowRepairRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QAccountFlowRepairDO qAccountFlowRepairDO = QAccountFlowRepairDO.accountFlowRepairDO;


    public PagingVO<AccountFlowRepairVO> page(AccountFlowRepairPageParam pageParam) {
        List<Predicate> where = where(pageParam);
        JPAQuery<AccountFlowRepairVO> query = select(AccountFlowRepairVO.class).where(ExpressionUtils.allOf(where));
        pageParam.setPaging(query);
        pageParam.fillOrders(query, qAccountFlowRepairDO);
        return PagingVO.<AccountFlowRepairVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public List<AccountFlowRepairVO> selectListByParam(AccountFlowRepairPageParam pageParam) {
        List<Predicate> where = where(pageParam);
        JPAQuery<AccountFlowRepairVO> query = select(AccountFlowRepairVO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    private List<Predicate> where(AccountFlowRepairPageParam pageParam) {
        List<Predicate> predicates = new ArrayList<>();

        if (!Objects.isNull(pageParam.getId())) {
            predicates.add(qAccountFlowRepairDO.id.eq(pageParam.getId()));
        }
        if (!CollectionUtils.isEmpty(pageParam.getIds())) {
            predicates.add(qAccountFlowRepairDO.id.in(pageParam.getIds()));
        }

        if (StringUtils.isNotBlank(pageParam.getFlowNo())) {
            predicates.add(qAccountFlowRepairDO.flowNo.like("%" + pageParam.getFlowNo() + "%"));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getFlowNoList())){
            predicates.add(qAccountFlowRepairDO.flowNo.in(pageParam.getFlowNoList()));
        }

        if (Objects.nonNull(pageParam.getActualAmount())) {
            predicates.add(qAccountFlowRepairDO.actualAmount.eq(pageParam.getActualAmount()));
        }
        if (Objects.nonNull(pageParam.getAmount())) {
            predicates.add(qAccountFlowRepairDO.amount.eq(pageParam.getAmount()));
        }

        if (StringUtils.isNotBlank(pageParam.getOpenAccountEntityCode())) {
            predicates.add(qAccountFlowRepairDO.openAccountEntityCode.eq(pageParam.getOpenAccountEntityCode()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getOpenAccountEntityCodeList())){
            predicates.add(qAccountFlowRepairDO.openAccountEntityCode.in(pageParam.getOpenAccountEntityCodeList()));
        }
        if (StrUtil.isNotBlank(pageParam.getOpenAccountEntityName())) {
            predicates.add(qAccountFlowRepairDO.openAccountEntityName.like("%" + pageParam.getOpenAccountEntityName() + "%"));
        }
        if (!StringUtils.isEmpty(pageParam.getOpenAccountEntityKeyword())) {
            predicates.add(qAccountFlowRepairDO.openAccountEntityCode.like("%" + pageParam.getOpenAccountEntityKeyword() + "%").or(qAccountFlowRepairDO.openAccountEntityName.like("%" + pageParam.getOpenAccountEntityKeyword() + "%")));
        }

        if (StringUtils.isNotBlank(pageParam.getAccountType())) {
            predicates.add(qAccountFlowRepairDO.accountType.eq(pageParam.getAccountType()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getAccountTypeList())){
            predicates.add(qAccountFlowRepairDO.accountType.in(pageParam.getAccountTypeList()));
        }

        if (StringUtils.isNotBlank(pageParam.getAccountCode())) {
            predicates.add(qAccountFlowRepairDO.accountCode.eq(pageParam.getAccountCode()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getAccountCodeList())){
            predicates.add(qAccountFlowRepairDO.accountCode.in(pageParam.getAccountCodeList()));
        }
        if (StrUtil.isNotBlank(pageParam.getAccountName())) {
            predicates.add(qAccountFlowRepairDO.accountName.like("%" + pageParam.getAccountName() + "%"));
        }
        if (!StringUtils.isEmpty(pageParam.getAccountKeyword())) {
            predicates.add(qAccountFlowRepairDO.accountCode.like("%" + pageParam.getAccountKeyword() + "%").or(qAccountFlowRepairDO.accountName.like("%" + pageParam.getAccountKeyword() + "%")));
        }

        if (StringUtils.isNotBlank(pageParam.getSourceNo())) {
            predicates.add(qAccountFlowRepairDO.sourceNo.like("%" + pageParam.getSourceNo() + "%"));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getSourceNoList())){
            predicates.add(qAccountFlowRepairDO.sourceNo.in(pageParam.getSourceNoList()));
        }

        if (StringUtils.isNotBlank(pageParam.getRepairStatus())) {
            predicates.add(qAccountFlowRepairDO.repairStatus.eq(pageParam.getRepairStatus()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getRepairStatusList())){
            predicates.add(qAccountFlowRepairDO.repairStatus.in(pageParam.getRepairStatusList()));
        }

        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qAccountFlowRepairDO.id,
                qAccountFlowRepairDO.flowNo,
                qAccountFlowRepairDO.actualAmount,
                qAccountFlowRepairDO.amount,
                qAccountFlowRepairDO.openAccountEntityCode,
                qAccountFlowRepairDO.openAccountEntityName,
                qAccountFlowRepairDO.accountType,
                qAccountFlowRepairDO.accountCode,
                qAccountFlowRepairDO.accountName,
                qAccountFlowRepairDO.sourceNo,
                qAccountFlowRepairDO.repairStatus,
                qAccountFlowRepairDO.remark,
                qAccountFlowRepairDO.createTime,
                qAccountFlowRepairDO.createUserId,
                qAccountFlowRepairDO.creator,
                qAccountFlowRepairDO.modifyTime,
                qAccountFlowRepairDO.modifyUserId,
                qAccountFlowRepairDO.updater,
                qAccountFlowRepairDO.tenantId,
                qAccountFlowRepairDO.deleteFlag
        )).from(qAccountFlowRepairDO);
    }

    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> ids) {
        jpaQueryFactory.update(qAccountFlowRepairDO)
                .set(qAccountFlowRepairDO.deleteFlag, deleteFlag)
                .where(qAccountFlowRepairDO.id.in(ids))
                .execute();
    }


    public void updateAmountAndRepairStatusById(BigDecimal amount, String repairStatus,Long id) {
        jpaQueryFactory.update(qAccountFlowRepairDO)
                .set(qAccountFlowRepairDO.amount, amount)
                .set(qAccountFlowRepairDO.repairStatus, repairStatus)
                .where(qAccountFlowRepairDO.id.eq(id))
                .execute();
    }

}
