package com.elitesland.fin.repo.flowrepair;

import com.elitesland.fin.application.facade.param.flowrepair.CreditAccountFlowRepairPageParam;
import com.elitesland.fin.application.facade.vo.flowrepair.CreditAccountFlowRepairVO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.entity.flowrepair.QCreditAccountFlowRepairDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/10/25
 * @Version 1.0
 * @Content:
 */
@Component
@RequiredArgsConstructor
public class CreditAccountFlowRepairRepoProc {
    private final JPAQueryFactory jpaQueryFactory;

    private final QCreditAccountFlowRepairDO qCreditAccountFlowRepairDO = QCreditAccountFlowRepairDO.creditAccountFlowRepairDO;

    public PagingVO<CreditAccountFlowRepairVO> page(CreditAccountFlowRepairPageParam pageParam) {
        List<Predicate> where = where(pageParam);
        JPAQuery<CreditAccountFlowRepairVO> query = select(CreditAccountFlowRepairVO.class).where(ExpressionUtils.allOf(where));
        pageParam.setPaging(query);
        pageParam.fillOrders(query, qCreditAccountFlowRepairDO);
        return PagingVO.<CreditAccountFlowRepairVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public List<CreditAccountFlowRepairVO> selectListByParam(CreditAccountFlowRepairPageParam pageParam) {
        List<Predicate> where = where(pageParam);
        JPAQuery<CreditAccountFlowRepairVO> query = select(CreditAccountFlowRepairVO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    private List<Predicate> where(CreditAccountFlowRepairPageParam pageParam) {
        List<Predicate> predicates = new ArrayList<>();

        if (!Objects.isNull(pageParam.getId())) {
            predicates.add(qCreditAccountFlowRepairDO.id.eq(pageParam.getId()));
        }
        if (!CollectionUtils.isEmpty(pageParam.getIds())) {
            predicates.add(qCreditAccountFlowRepairDO.id.in(pageParam.getIds()));
        }

        if (StringUtils.isNotBlank(pageParam.getFlowNo())) {
            predicates.add(qCreditAccountFlowRepairDO.flowNo.like("%" + pageParam.getFlowNo() + "%"));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getFlowNoList())){
            predicates.add(qCreditAccountFlowRepairDO.flowNo.in(pageParam.getFlowNoList()));
        }

        if (Objects.nonNull(pageParam.getActualAmount())) {
            predicates.add(qCreditAccountFlowRepairDO.actualAmount.eq(pageParam.getActualAmount()));
        }
        if (Objects.nonNull(pageParam.getAmount())) {
            predicates.add(qCreditAccountFlowRepairDO.amount.eq(pageParam.getAmount()));
        }

        if (StringUtils.isNotBlank(pageParam.getOpenAccountEntityCode())) {
            predicates.add(qCreditAccountFlowRepairDO.openAccountEntityCode.eq(pageParam.getOpenAccountEntityCode()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getOpenAccountEntityCodeList())){
            predicates.add(qCreditAccountFlowRepairDO.openAccountEntityCode.in(pageParam.getOpenAccountEntityCodeList()));
        }
        if (StrUtil.isNotBlank(pageParam.getOpenAccountEntityName())) {
            predicates.add(qCreditAccountFlowRepairDO.openAccountEntityName.like("%" + pageParam.getOpenAccountEntityName() + "%"));
        }
        if (!StringUtils.isEmpty(pageParam.getOpenAccountEntityKeyword())) {
            predicates.add(qCreditAccountFlowRepairDO.openAccountEntityCode.like("%" + pageParam.getOpenAccountEntityKeyword() + "%").or(qCreditAccountFlowRepairDO.openAccountEntityName.like("%" + pageParam.getOpenAccountEntityKeyword() + "%")));
        }

        if (StringUtils.isNotBlank(pageParam.getAccountType())) {
            predicates.add(qCreditAccountFlowRepairDO.accountType.eq(pageParam.getAccountType()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getAccountTypeList())){
            predicates.add(qCreditAccountFlowRepairDO.accountType.in(pageParam.getAccountTypeList()));
        }

        if (StringUtils.isNotBlank(pageParam.getAccountCode())) {
            predicates.add(qCreditAccountFlowRepairDO.accountCode.eq(pageParam.getAccountCode()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getAccountCodeList())){
            predicates.add(qCreditAccountFlowRepairDO.accountCode.in(pageParam.getAccountCodeList()));
        }
        if (StrUtil.isNotBlank(pageParam.getAccountName())) {
            predicates.add(qCreditAccountFlowRepairDO.accountName.like("%" + pageParam.getAccountName() + "%"));
        }
        if (!StringUtils.isEmpty(pageParam.getAccountKeyword())) {
            predicates.add(qCreditAccountFlowRepairDO.accountCode.like("%" + pageParam.getAccountKeyword() + "%").or(qCreditAccountFlowRepairDO.accountName.like("%" + pageParam.getAccountKeyword() + "%")));
        }

        if (StringUtils.isNotBlank(pageParam.getSourceNo())) {
            predicates.add(qCreditAccountFlowRepairDO.sourceNo.like("%" + pageParam.getSourceNo() + "%"));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getSourceNoList())){
            predicates.add(qCreditAccountFlowRepairDO.sourceNo.in(pageParam.getSourceNoList()));
        }

        if (StringUtils.isNotBlank(pageParam.getRepairStatus())) {
            predicates.add(qCreditAccountFlowRepairDO.repairStatus.eq(pageParam.getRepairStatus()));
        }
        if (CollectionUtils.isNotEmpty(pageParam.getRepairStatusList())){
            predicates.add(qCreditAccountFlowRepairDO.repairStatus.in(pageParam.getRepairStatusList()));
        }

        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qCreditAccountFlowRepairDO.id,
                qCreditAccountFlowRepairDO.flowNo,
                qCreditAccountFlowRepairDO.actualAmount,
                qCreditAccountFlowRepairDO.amount,
                qCreditAccountFlowRepairDO.openAccountEntityCode,
                qCreditAccountFlowRepairDO.openAccountEntityName,
                qCreditAccountFlowRepairDO.accountType,
                qCreditAccountFlowRepairDO.accountCode,
                qCreditAccountFlowRepairDO.accountName,
                qCreditAccountFlowRepairDO.sourceNo,
                qCreditAccountFlowRepairDO.repairStatus,
                qCreditAccountFlowRepairDO.remark,
                qCreditAccountFlowRepairDO.createTime,
                qCreditAccountFlowRepairDO.createUserId,
                qCreditAccountFlowRepairDO.creator,
                qCreditAccountFlowRepairDO.modifyTime,
                qCreditAccountFlowRepairDO.modifyUserId,
                qCreditAccountFlowRepairDO.updater,
                qCreditAccountFlowRepairDO.tenantId,
                qCreditAccountFlowRepairDO.deleteFlag
        )).from(qCreditAccountFlowRepairDO);
    }

    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> ids) {
        jpaQueryFactory.update(qCreditAccountFlowRepairDO)
                .set(qCreditAccountFlowRepairDO.deleteFlag, deleteFlag)
                .where(qCreditAccountFlowRepairDO.id.in(ids))
                .execute();
    }

    public void updateAmountAndRepairStatusById(BigDecimal amount, String repairStatus, Long id) {
        jpaQueryFactory.update(qCreditAccountFlowRepairDO)
                .set(qCreditAccountFlowRepairDO.amount, amount)
                .set(qCreditAccountFlowRepairDO.repairStatus, repairStatus)
                .where(qCreditAccountFlowRepairDO.id.eq(id))
                .execute();
    }

}
