package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinAccountPeriodConvert;
import com.elitesland.fin.application.convert.accountingengine.FinAccountPeriodLineConvert;
import com.elitesland.fin.application.convert.accountingengine.FinSobAccountPeriodConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSobAccountPeriodDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccountPeriodLineParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinSobAccountPeriodParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinSobAccountPeriodVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.accountingengine.*;
import com.elitesland.fin.repo.accountingengine.*;
import com.google.common.collect.Lists;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class FinSobAccountPeriodServiceImpl implements FinSobAccountPeriodService {


    private final FinSobAccountPeriodRepo finSobAccountPeriodRepo;

    private final FinSobAccountPeriodRepoProc finSobAccountPeriodRepoProc;

    private final FinSetOfBookRepoProc finSetOfBookRepoProc;

    private final FinAccountPeriodRepoProc finAccountPeriodRepoProc;

    private final FinAccountPeriodLineRepo finAccountPeriodLineRepo;

    private final FinSetOfBookOuRepo finSetOfBookOuRepo;


    @SysCodeProc
    @Override
    public PagingVO<FinSobAccountPeriodVO> page(FinSobAccountPeriodParam finSobAccountPeriodParam) {
        return FinSobAccountPeriodConvert.INSTANCE.DTOToVO(finSobAccountPeriodRepoProc.page(finSobAccountPeriodParam));
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void generate(FinSobAccountPeriodParam finSobAccountPeriodParam) {

        checkGenerateParam(finSobAccountPeriodParam);

        List<FinSobAccountPeriodDO> finSobAccountPeriodDOList = buildGenerateList(finSobAccountPeriodParam);

        List<FinSobAccountPeriodDTO> finSobAccountPeriodDTOList = finSobAccountPeriodRepoProc.query(finSobAccountPeriodParam);

        //不重复创建
        finSobAccountPeriodDOList = finSobAccountPeriodDOList.stream().filter(finSobAccountPeriodDO ->
                !finSobAccountPeriodDTOList.stream().filter(finSobAccountPeriodDTO ->
                        finSobAccountPeriodDTO.getSobCode().equals(finSobAccountPeriodDO.getSobCode()) &&
                                finSobAccountPeriodDTO.getAccountPeriodCode().equals(finSobAccountPeriodDO.getAccountPeriodCode()) &&
                                finSobAccountPeriodDTO.getOuCode().equals(finSobAccountPeriodDO.getOuCode()) &&
                                finSobAccountPeriodDTO.getActiveStartTime().equals(finSobAccountPeriodDO.getActiveStartTime()) &&
                                finSobAccountPeriodDTO.getActiveEndTime().equals(finSobAccountPeriodDO.getActiveEndTime()))
                        .findFirst()
                        .isPresent())
                .collect(Collectors.toList());

        finSobAccountPeriodRepo.saveAll(finSobAccountPeriodDOList);
    }

    private void checkGenerateParam(FinSobAccountPeriodParam finSobAccountPeriodParam) {
        Assert.notEmpty(finSobAccountPeriodParam.getSobCode(), "账套编码必填");
        Assert.notEmpty(finSobAccountPeriodParam.getYear(), "年份必填");
        Assert.notEmpty(finSobAccountPeriodParam.getOuCodeList(), "公司编码必填");
    }

    private List<FinSobAccountPeriodDO> buildGenerateList(FinSobAccountPeriodParam finSobAccountPeriodParam) {
        FinSetOfBookDO finSetOfBookDO = finSetOfBookRepoProc.findBySobCode(finSobAccountPeriodParam.getSobCode());
        Assert.notNull("账套不存在");

        FinAccountPeriodDO finAccountPeriodDO = finAccountPeriodRepoProc.findByAccountPeriodCode(finSetOfBookDO.getAccountPeriodCode());
        Assert.notNull("条会计期间不存在");

        List<FinAccountPeriodLineDO> finAccountPeriodLineDOList = finAccountPeriodLineRepo.findAllByMasIdIn(Lists.newArrayList(finAccountPeriodDO.getId()));

        List<FinSetOfBookOuDO> finSetOfBookOuDOList = finSetOfBookOuRepo.findAllByMasIdIn(Lists.newArrayList(finSetOfBookDO.getId()));

        List<String> ouCodeList = finSobAccountPeriodParam.getOuCodeList();

        List<FinSobAccountPeriodDO> finSobAccountPeriodDOList = ouCodeList.stream().flatMap(ouCode ->
                finAccountPeriodLineDOList.stream()
                        .filter(finAccountPeriodLineDO -> finSobAccountPeriodParam.getYear().equals(finAccountPeriodLineDO.getYear()))
                        .map(finAccountPeriodLineDO -> {
                            FinSobAccountPeriodDO finSobAccountPeriodDO = new FinSobAccountPeriodDO();
                            finSobAccountPeriodDO.setSobCode(finSetOfBookDO.getSobCode());
                            finSobAccountPeriodDO.setSobName(finSetOfBookDO.getSobName());
                            finSobAccountPeriodDO.setAccountPeriodCode(finAccountPeriodDO.getAccountPeriodCode());
                            finSobAccountPeriodDO.setAccountPeriodName(finAccountPeriodDO.getAccountPeriodName());
                            finSobAccountPeriodDO.setOuCode(ouCode);

                            FinSetOfBookOuDO finSetOfBookOuDOResult = finSetOfBookOuDOList.stream()
                                    .filter(finSetOfBookOuDO -> finSetOfBookOuDO.getOuCode().equals(ouCode))
                                    .findFirst()
                                    .orElse(null);
                            Assert.notNull(finSetOfBookOuDOResult, "公司不存在");

                            finSobAccountPeriodDO.setOuName(finSetOfBookOuDOResult.getOuName());
                            finSobAccountPeriodDO.setPeriodStyle(finAccountPeriodLineDO.getPeriodStyle());
                            finSobAccountPeriodDO.setStatus(UdcEnum.ACCOUNT_PERIOD_CONTROL_STATUS_NOT_OPEN.getValueCode());
                            finSobAccountPeriodDO.setActiveStartTime(finAccountPeriodLineDO.getActiveStartTime());
                            finSobAccountPeriodDO.setActiveEndTime(finAccountPeriodLineDO.getActiveEndTime());

                            return finSobAccountPeriodDO;
                        })).collect(Collectors.toList());

        return finSobAccountPeriodDOList;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void openOrClose(FinSobAccountPeriodParam finSobAccountPeriodParam) {

        checkEnableOrDisableParam(finSobAccountPeriodParam);

        List<FinSobAccountPeriodDO> finSobAccountPeriodDOList = finSobAccountPeriodRepo.findAllById(finSobAccountPeriodParam.getIds());
        finSobAccountPeriodDOList.stream().forEach(item -> Assert.isFalse(finSobAccountPeriodParam.getStatus().equals(item.getStatus()), "已打开/关闭"));

        finSobAccountPeriodDOList.stream().forEach(item -> item.setStatus(finSobAccountPeriodParam.getStatus()));
    }

    private void checkEnableOrDisableParam(FinSobAccountPeriodParam finSobAccountPeriodParam) {
        Assert.notEmpty(finSobAccountPeriodParam.getIds(), "id必填");
        Assert.notEmpty(finSobAccountPeriodParam.getStatus(), "状态必填");
    }
}
