package com.elitesland.fin.application.service.excel.entity;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.metadata.BaseRowModel;
import com.elitescloud.cloudt.common.annotation.SysCode;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * <p>
 * 账户流水导出entity
 * </p>
 *
 * @author gyj
 * @date 2023/7/28
 */
@Data
@ExcelIgnoreUnannotated
public class AccountFlowExportEntity extends BaseRowModel implements Serializable {

    @ExcelProperty(value = "公司", index = 0)
    private String companyCodeName;

    @ExcelProperty(value = "归属加盟商", index = 1)
    private String secFranchiseeCodeName;

    @ExcelProperty(value = "流水号", index = 2)
    private String flowNo;

    @ExcelProperty(value = "交易类型", index = 3)
    private String transactionTypeName;

    @ExcelProperty(value = "发生金额", index = 4)
    private BigDecimal amount;

    @ExcelProperty(value = "交易日期", index = 5)
    private LocalDateTime transactionTime;

    @ExcelProperty(value = "开户主体名称", index = 6)
    private String accountHolderName;

    @ExcelProperty(value = "账户类型", index = 7)
    private String accountTypeName;

    @ExcelProperty(value = "账户编码", index = 8)
    private String accountCode;

    @ExcelProperty(value = "账户名称", index = 9)
    private String accountNameName;

    @ExcelProperty(value = "账户规则", index = 10)
    private String ruleName;

    @ExcelProperty(value = "规则优先级", index = 11)
    private Integer priorityNo;

    @ExcelProperty(value = "来源单据", index = 12)
    private String sourceDocName;

    @ExcelProperty(value = "来源单号", index = 13)
    private String sourceNo;

    @ExcelProperty(value = "审批状态", index = 14)
    private String orderStateName;

    @ExcelProperty(value = "审核人", index = 15)
    private String auditUserName;

    @ExcelProperty(value = "审核时间", index = 16)
    private LocalDateTime auditDate;
}
