package com.elitesland.fin.application.service.excel.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ContentStyle;
import com.elitesland.fin.utils.ExcelUtil;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@ApiModel(value = "账户快照返回值", description = "账户快照返回值")
@Data
public class AccountSnapshotExportEntity implements Serializable {

    @ExcelProperty(value = "快照时间", index = 0)
    private LocalDateTime snapshotTime;

    @ExcelProperty(value = "归属公司名称", index = 1)
    private String secOuName;

    @ExcelProperty(value = "开户主体名称", index = 2)
    private String accountHolderName;

    @ExcelProperty(value = "开户主体编码", index = 3)
    private String accountHolderCode;

    @ExcelProperty(value = "账户编码", index = 4)
    private String accountCode;

    @ExcelProperty(value = "账户名称", index = 5)
    private String accountName;

    @ExcelProperty(value = "账户类型", index = 6)
    private String accountTypeName;

    @ExcelProperty(value = "账户金额", index = 7)
    @ContentStyle(dataFormat = 2)
    private BigDecimal accountAmount;

    @ExcelProperty(value = "账户占用金额", index = 8)
    @ContentStyle(dataFormat = 2)
    private BigDecimal accountOccupancyAmount;

    @ExcelProperty(value = "账户可用金额", index = 9)
    @ContentStyle(dataFormat = 2)
    private BigDecimal accountAvailableAmount;

    @ExcelProperty(value = "状态", index = 10)
    private String stateName;

    public String getAccountAmount() {
        return ExcelUtil.twoPointNum(accountAmount);
    }

    public String getAccountAvailableAmount() {
        return ExcelUtil.twoPointNum(accountAvailableAmount);
    }

    public String getAccountOccupancyAmount() {
        return ExcelUtil.twoPointNum(accountOccupancyAmount);
    }

}
