package com.elitesland.fin.application.service.excel.exp;


import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.creditaccount.CreditAccountConvert;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountPageParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountPageVO;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.application.service.excel.entity.CreditAccountExportEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 品牌导出
 * @author : Scott.zhang(zhang hang)
 * @Date : 2022/2/2210:10
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class CreditAccountExportServiceImpl implements DataExport<CreditAccountExportEntity, CreditAccountPageParam> {

    private final CreditAccountService creditAccountService;

    @Override
    public String getTmplCode() {
        return "fin_credit_account_export";
    }

    public PagingVO<CreditAccountExportEntity> executeExport(CreditAccountPageParam queryParam) {
        PagingVO<CreditAccountPageVO> pagingVO= creditAccountService.pageSearch(queryParam);
        return CreditAccountConvert.INSTANCE.pageVo2ExportEntity(pagingVO);
    }
}
