package com.elitesland.fin.domain.entity.arorder;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/02/27
 * @Version 1.0
 * @Content:
 */
@Entity
@Table(name = "ar_order_dtl_record")
@org.hibernate.annotations.Table(appliesTo = "ar_order_dtl_record", comment = "应收单明细记录表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ArOrderDtlRecordDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 1301389300955545582L;

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表ID'")
    private Long masId;

    @Column(name = "source_no", columnDefinition = "varchar(32) comment '来源单号'")
    private String sourceNo;

    @Column(name = "source_line", columnDefinition = "int(10) comment '来源行号'")
    private Integer sourceLine;

    @Column(name = "item_id", columnDefinition = "bigint(20) comment '商品ID'")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(32) comment '商品编码'")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar(32) comment '商品名称'")
    private String itemName;

    @Column(name = "item_type", columnDefinition = "varchar(32) comment '规格型号'")
    private String itemType;

    @Column(name = "small_cate_code", columnDefinition = "varchar(32) comment '小类编码'")
    private String smallCateCode;

    @Column(name = "small_cate_name", columnDefinition = "varchar(32) comment '小类名称'")
    private String smallCateName;

    @Column(name = "uom", columnDefinition = "varchar(32) comment '计量单位'")
    private String uom;

    @Column(name = "uom_name", columnDefinition = "varchar(32) comment '计量单位名称'")
    private String uomName;

    @Column(name = "qty", columnDefinition = "decimal(16,4) comment '数量'")
    private BigDecimal qty;

    @Column(name = "excl_tax_price", columnDefinition = "decimal(18,8) comment '单价'")
    private BigDecimal exclTaxPrice;

    @Column(name = "price", columnDefinition = "decimal(18,8) comment '含税单价'")
    private BigDecimal price;

    @Column(name = "tax_rate", columnDefinition = "decimal(18,8) comment '税率'")
    private BigDecimal taxRate;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) comment '含税金额'")
    private BigDecimal totalAmt;

    @Column(name = "excl_tax_amt", columnDefinition = "decimal(18,8) comment '不含税金额'")
    private BigDecimal exclTaxAmt;

    @Column(name = "tax_amt", columnDefinition = "decimal(18,8) comment '税额'")
    private BigDecimal taxAmt;

    @Column(name = "total_cur_amt", columnDefinition = "decimal(18,8) comment '含税金额(本位币)'")
    private BigDecimal totalCurAmt;

    @Column(name = "excl_tax_cur_amt", columnDefinition = "decimal(18,8) comment '不含税金额(本位币)'")
    private BigDecimal exclTaxCurAmt;

    @Column(name = "tax_cur_amt", columnDefinition = "decimal(18,8) comment '税额(本位币)'")
    private BigDecimal taxCurAmt;

    @Column(name = "bu_code", columnDefinition = "varchar(32) comment '费用部门编码'")
    private String buCode;

    @Column(name = "bu_id", columnDefinition = "bigint(20) comment '费用部门ID'")
    private Long buId;

    @Column(name = "bu_name", columnDefinition = "varchar(32) comment '费用部门'")
    private String buName;

    @Column(name = "es11", columnDefinition = "varchar(32) comment '发货单号'")
    private String es11;

    @Column(name = "es12", columnDefinition = "bigint(20) comment '发货单明细ID（开票申请单）'")
    private Long es12;

    @Column(name = "es13", columnDefinition = "varchar(32) comment '订单客户'")
    private String es13;

    @Column(name = "es14", columnDefinition = "varchar(32) comment '客户编码(子客户)'")
    private String es14;

    @Column(name = "es15", columnDefinition = "decimal(18,8) comment '未税单价'")
    private BigDecimal es15;

    @Column(name = "es16", columnDefinition = "varchar(32) comment '税码'")
    private String es16;

    @Column(name = "es17", columnDefinition = "varchar(32) comment '发票号'")
    private String es17;

    @Column(name = "es18", columnDefinition = "varchar(32) comment '发票类型'")
    private String es18;

    @Column(name = "es19", columnDefinition = "varchar(32) comment '收款协议'")
    private String es19;

    @Column(name = "es20", columnDefinition = "varchar(32) comment '业务员编码'")
    private String es20;

    @Column(name = "es21", columnDefinition = "varchar(32) comment '币种'")
    private String es21;

    @Column(name = "es22", columnDefinition = "decimal(18,8) comment '汇率'")
    private BigDecimal es22;

    @Column(name = "es23", columnDefinition = "datetime(6) comment '起算日期'")
    private LocalDateTime es23;

    @Column(name = "es24", columnDefinition = "datetime(6) comment '到期付款日'")
    private LocalDateTime es24;


    @Column(name = "doc_type", columnDefinition = "varchar(32) comment '具体订单场景'")
    private String docType;

    @Column(name = "doc_type2", columnDefinition = "varchar(32) comment 'B端订单/C端订单'")
    private String docType2;

    @Column(name = "doc_cls", columnDefinition = "varchar(32) comment '传SO代表正向，传RSO代表退货负向'")
    private String docCls;

    /*@Column(name = "es25", columnDefinition = "bigint(20) comment '第三方应收单明细id'")
    private Long es25;*/

    /*@Column(name = "expenses_type", columnDefinition = "varchar(32) comment '费用类型'")
    private String expensesType;

    @ApiModelProperty("扩展表关联字段")
    @Column(name = "relate_id", columnDefinition = "bigint(20) comment '扩展表关联id'")
    private Long relateId;*/
}
