package com.elitesland.fin.infinity.config;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Configuration;

/**
 * @author eric.hao
 * @since 2023/04/16
 */
@Data
@Configuration
public class InfinityConfig implements InitializingBean {

    /**
     * 超时值为0，指无限时
     */
    @ApiModelProperty("请求连接时使用的超时（以毫秒为单位）")
    private int connectionRequestTimeout = 3000;

    /**
     * 超时值为0，指无限时
     */
    @ApiModelProperty("连接超时（以毫秒为单位）")
    private int connectTimeout = 3000;

    /**
     * 超时值为0，指无限时
     */
    @ApiModelProperty("套接字读取超时（以毫秒为单位）")
    private int readTimeout = 15000;

    public static int CONNECTION_REQUEST_TIMEOUT;
    public static int CONNECT_TIMEOUT;
    public static int READ_TIMEOUT;

    @Override
    public void afterPropertiesSet() throws Exception {
        CONNECTION_REQUEST_TIMEOUT = connectionRequestTimeout;
        CONNECT_TIMEOUT = connectTimeout;
        READ_TIMEOUT = readTimeout;
    }
}

