package com.elitesland.fin.application.convert.apverconfig;

import com.elitesland.fin.application.facade.param.apverconfig.ApVerConfigSaveParam;
import com.elitesland.fin.application.facade.vo.apverconfig.ApVerConfigVO;
import com.elitesland.fin.domain.entity.apverconfig.ApVerConfig;
import com.elitesland.fin.domain.entity.apverconfig.ApVerConfigDO;
import com.elitesland.fin.infr.dto.apverconfig.ApVerConfigDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/6 16:22
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface ApVerConfigConvert {

    ApVerConfigConvert INSTANCE = Mappers.getMapper(ApVerConfigConvert.class);

    ApVerConfig paramConvert(ApVerConfigSaveParam param);

    ApVerConfigDO convert(ApVerConfig apverConfig);

    @Mapping(source = "apVerConfigDtlDTOList", target = "configDtlVOS")
    ApVerConfigVO convertVo(ApVerConfigDTO apVerConfigDTO);

    PagingVO<ApVerConfigVO> convertPage(PagingVO<ApVerConfigDTO> pagingVO);

    List<ApVerConfigVO> dtoToVo(List<ApVerConfigDTO> dtoList);
}
